<?php

//session_start();

$error = '';
$html = '';
$group_name = isset($_POST['group_name']) ? $_POST['group_name'] : '';

// Check if file is uploaded
if ($_FILES['file']['name'] != '') {
    $file_array = explode(".", $_FILES['file']['name']);
    $extension = end($file_array);

    // Check if the file extension is CSV
    if ($extension == 'csv') {
        $file_data = fopen($_FILES['file']['tmp_name'], 'r');
        $file_header = fgetcsv($file_data);

        // Get the hidden input value for 'group_name' and include it in the HTML
        $html .= '<input type="hidden" name="group_name" value="' . htmlspecialchars($group_name) . '">';
        
        // Table structure for previewing the uploaded data
        $html .= '<table class="table table-bordered"><tr>';
        $html .= '
            <th>Code Type</th>
            <th>Code</th>
        ';
        $html .= '</tr>';

        $limit = 0;
        $temp_data = [];

        // Loop through CSV data and show preview
        while (($row = fgetcsv($file_data)) !== FALSE) {
            $limit++;

            if ($limit < 6) { // Preview the first 5 rows
                $html .= '<tr>';
                for ($count = 0; $count < count($row); $count++) {
                    $html .= '<td>' . $row[$count] . '</td>';
                }
                $html .= '</tr>';
            }

            // Store the row data temporarily in an array
            $temp_data[] = $row;
        }

        // Store the CSV data in session for later processing
        $_SESSION['file_data'] = $temp_data;

        // Display import button
        $html .= '
            </table>
            <br />
            <div align="right">
                <button type="button" name="import" id="import" class="btn btn-success">Import</button>
            </div>
            <br />
        ';
    } else {
        $error = 'Only <b>.csv</b> file allowed';
    }
} else {
    $error = 'Please Select CSV File';
}

// Return the response in JSON format
$output = array(
    'error' => $error,
    'output' => $html
);

echo json_encode($output);
?>
