<script src="https://code.jquery.com/jquery.js"></script>
<?php if (loggedin_role_id() != 4) { ?>
    <section class="panel-group" id="accordion">
        <div class="panel panel-accordion">
            <div class="panel-heading">
                <h4 class="panel-title">
                    <a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion"
                       href="#client_filter_field"><?php echo translate('Select Grounds For Filter'); ?></a>
                </h4>
            </div>

            <div id="client_filter_field"
                 class="accordion-body collapse <?php echo($this->session->flashdata('active_box') == 1 ? 'in' : ''); ?>">
                <?php echo form_open($this->uri->uri_string()); ?>
                <div class="panel-body">
                    <?php if (in_array(loggedin_role_id(), array(1, 2))) { ?>
                        <div class="col-md-4 mb-lg">
                            <div class="form-group <?= form_error('client_id') ? 'has-error' : null ?>">
                                <label for="client_id" class="control-label">
                                    <?php
                                    echo translate('Client_list');
                                    ?>
                                    <span class="required"></span>
                                </label>
                                <div class="input-group">
                                    <span class="input-group-addon"><i class="fas fa-users"></i></span>
                                    <select class="form-control" data-plugin-selectTwo data-width="100%"
                                            name="client_id"
                                            id="client_id">
                                        <?php /** @var array<array> $nasList */ ?>
                                        <?php if (empty($client_id_list)): ?>
                                            <option value=""><?= translate('No Clients Found'); ?></option>
                                        <?php else: ?>
                                            <option value=""><?= translate('Select A Client') ?></option>
                                            <?php foreach ($client_id_list as $client_id): ?>
                                                <option value="<?= $client_id->id ?>" <?= set_select('client_id', $client_id->id) ?>>
                                                    <?= html_escape($client_id->staff_id . '--' . $client_id->name) ?>
                                                </option>
                                            <?php endforeach; ?>
                                        <?php endif; ?>

                                    </select>
                                    <span class="error"><?= form_error('client_id'); ?></span>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                    
                    <div class="col-md-6 mb-lg">
                        <div class="form-group">
                            <label class="control-label" for="daterange"><?php echo translate('date'); ?> <span class="required"></span></label>
                            <div class="input-group">
                                <span class="input-group-addon"><i class="fas fa-calendar-check"></i></span>
                                <input type="text" class="form-control daterange" id="daterange" name="daterange"
                                       value="<?php echo set_value('daterange', date("Y/m/1") . ' - ' . date("Y/m/d")); ?>"
                                       required/>
                            </div>
                        </div>
                    </div>
                </div>
                <footer class="panel-footer">
                    <div class="row">
                        <div class="col-md-offset-10 col-md-2">
                            <button type="button" name="btn-filter" id="btn-filter" value="1"
                                    class="btn btn btn-default btn-block"><i
                                        class="fas fa-filter"></i> <?php echo translate('filter'); ?></button>
                        </div>
                    </div>
                </footer>
                <?php echo form_close(); ?>
            </div>
        </div>
    </section>
<?php } ?>
<section class="panel">
    <div class="tabs-custom">
        <ul class="nav nav-tabs">
            <?php if (get_permission('coupon', 'is_view')) { ?>
                <li class="<?php echo(!isset($validation_error) ? 'active' : ''); ?>">
                    <a href="#list" data-toggle="tab"><i
                                class="fas fa-list-ul"></i> <?php echo translate('coupon') . " " . translate('list'); ?>
                    </a>
                </li>
            <?php }
            if (get_permission('coupon', 'is_add')) { ?>
                <li class="<?php echo(isset($validation_error) ? 'active' : ''); ?>">
                    <a href="#create" data-toggle="tab"><i
                                class="far fa-edit"></i> <?php echo translate('upload') . " " . translate('information'); ?>
                    </a>
                </li>
            <?php } ?>
        </ul>

        <div class="tab-content">
            <div id="list" class="tab-pane <?php echo(!isset($validation_error) ? 'active' : ''); ?>">
                <div class="row">
                    <div class="col-md-12">
                        <div class="table-responsive mb-sm mt-xs">
                            <?php $this->datatables->generate('dt_authors'); ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php if (get_permission('coupon', 'is_add')) { ?>

                <!-- Add the Download Sample button here -->
                <div class="tab-pane <?php echo(isset($validation_error) ? 'active' : ''); ?>" id="create">
                    <?php //echo form_open_multipart($this->uri->uri_string(), array('class' => 'form-horizontal form-bordered')); ?>
                    <!--------------------- TODO: Download CSV File-------------- -->
                    <div class="form-group">
                        <label class="col-md-3 control-label">
                            <?= translate('Download Sample'); ?>
                            <span class="required">*</span></label>
                        <div class="col-md-8">
                            <a href="<?= base_url("assets/file/CSV/coupon_code_sample_tts.csv") ?> "
                               download>
                                <button class="btn btn-default" id="download_sample_create">
                                    <i class="fas fa-download" style="color: #FFB534;"></i>
                                    <?= translate('Download Sample'); ?>
                                </button>
                            </a>
                        </div>
                    </div>
                    <br>

                    <div id="upload_form_errors" class="alert-danger p-lg" style="display: none;">

                    </div>

                    <form method="post" id="upload_form" enctype="multipart/form-data">

                        <div class="form-group <?php if (form_error('title')) echo 'has-error'; ?>">
                            <label class="col-md-3 control-label"><?php echo translate('Group') . " " . translate('name'); ?>
                                <span class="required">*</span></label>
                            <div class="col-md-8">
                                <input type="text" class="form-control" name="group_name" value="" required/>
                            </div>
                        </div>

                        <div id="upload_area">
                            <div class="form-group <?php if (form_error('photo')) echo 'has-error'; ?>">
                                <label class="col-md-3 control-label"><?php echo translate('select CSV'); ?> <span
                                            class="required">*</span></label>
                                <div class="col-md-8">
                                    <input type="file" name="file" class="dropify" data-height="150"
                                           data-default-file="" id="csv_file"/>
                                    <span class="error"><?php echo form_error('photo'); ?></span>
                                </div>
                            </div>


                            <footer class="panel-footer mt-lg">
                                <div class="row">
                                    <div class="col-md-2 col-md-offset-3">

                                        <button type="submit" class="btn btn-default btn-block" name="upload_file"
                                                id="upload_file" value="Upload">
                                            <i class="fas fa-plus-circle"></i> <?php echo translate('upload'); ?>
                                        </button>
                                    </div>
                                </div>
                            </footer>
                        </div>
                        <div class="table-responsive" id="process_area"></div>
                    </form>
                </div>
            <?php } ?>
        </div>
    </div>
</section>


<script>
    $(document).ready(function() {

        $('#upload_form').on('submit', function(event) {

            event.preventDefault();
            $.ajax({
                url: base_url + 'coupon/csv_upload_preview',
                method: "POST",
                data: new FormData(this),
                dataType: 'json',
                contentType: false,
                cache: false,
                processData: false,
                success: function(data) {
                    if (data.error !== '') {
                        $('#message').html('<div class="alert alert-danger">' + data.error + '</div>');
                    } else {
                        $('#process_area').html(data.output);
                        $('#upload_area').css('display', 'none');
                    }
                }
            });

        });

        let total_selection = 0;



        let code_type = 0;
        let code = 0;


        const column_data = [];

        $(document).on('change', '.set_column_data', function() {

            const column_name = $(this).val();

            const column_number = $(this).data('column_number');

            if (column_name in column_data) {
                alert('You have already define ' + column_name + ' column');

                $(this).val('');

                return false;
            }

            if (column_name !== '') {
                column_data[column_name] = column_number;
            } else {
                const entries = Object.entries(column_data);

                for (const [key, value] of entries) {
                    if (value === column_number) {
                        delete column_data[key];
                    }
                }
            }

            total_selection = Object.keys(column_data).length;

            if (total_selection >= 2) {
                $('#import').attr('disabled', false);


                code_type = column_data.code_type;
                code = column_data.code;

            } else {
                $('#import').attr('disabled', 'disabled');
            }

        });

        $(document).on('click', '#import', function(event) {

            event.preventDefault();
            const uploadFormErrorsDiv = $('#upload_form_errors');
            $.ajax({
                url: base_url + 'coupon/csv_insert_data',
                method: "POST",
                data: {

                    code_type: code_type,
                    code: code,

                    group_name: $('input[name="group_name"]').val()
                },
                beforeSend: function() {
                    $('#import').attr('disabled', true);
                    $('#import').text('Importing...');
                    uploadFormErrorsDiv.show(false);
                },
                success: function(data) {
                    data = JSON.parse(data);
                    // console.log(data);
                    if (data.status == 'success') {
                        window.location.href = base_url + 'coupon';
                    }

                    if (data.status == 'error') {

                        uploadFormErrorsDiv.html("");

                        let uploadFormErrors = '';

                        // Show a notification error message: ${data.error}
                        uploadFormErrors += `<p>${data.error}</p>`

                        // Display a list in the HTML body for ${data.errors}
                        if (Array.isArray(data.errors) && data.errors.length > 0) {
                            uploadFormErrors += '<ul>';
                            data.errors.forEach((error) => {
                                uploadFormErrors += `<li>${error}</li>`;
                            });
                            uploadFormErrors += '</ul>';
                        }

                        uploadFormErrorsDiv.html(uploadFormErrors);
                        uploadFormErrorsDiv.show();
                    }
                },
            })

        });

    });
</script>


<!-- add payment / deduce payment -->

<script>
    $("#btn-filter").click(function () {
        erTable_dt_authors.ajax.reload();
    });
</script>


<!-- Jquery Datatables JS -->
<script src="<?php echo base_url('assets/vendor/datatables/media/js/jquery.dataTables.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/vendor/datatables/media/js/dataTables.bootstrap.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/vendor/datatables/extras/TableTools/Buttons-1.4.2/js/dataTables.buttons.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/vendor/datatables/extras/TableTools/Buttons-1.4.2/js/buttons.bootstrap.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/vendor/datatables/extras/TableTools/Buttons-1.4.2/js/buttons.html5.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/vendor/datatables/extras/TableTools/Buttons-1.4.2/js/buttons.print.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/vendor/datatables/extras/TableTools/Buttons-1.4.2/js/buttons.colVis.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/vendor/datatables/extras/TableTools/JSZip-2.5.0/jszip.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/vendor/datatables/extras/TableTools/pdfmake-0.1.32/pdfmake.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/vendor/datatables/extras/TableTools/pdfmake-0.1.32/vfs_fonts.js'); ?>"></script>
<?php $this->datatables->jquery('dt_authors'); ?>