<script src="https://code.jquery.com/jquery.js"></script>
<section class="panel">
	<div class="tabs-custom">
		<ul class="nav nav-tabs">
		<?php if (get_permission('contacts_list', 'is_view')) { ?>
			<li class="<?php echo (!isset($validation_error) ? 'active' : ''); ?>">
				<a href="#list" data-toggle="tab"><i class="fas fa-list-ul"></i> <?php echo translate('Campaign') . " " . translate('name'); ?></a>
			</li>
		<?php } if (get_permission('contacts_list', 'is_add')) { ?>
			<li class="<?php echo (isset($validation_error) ? 'active' : ''); ?>">
				<a href="#create" data-toggle="tab"><i class="far fa-edit"></i> <?php echo translate('upload') . " " . translate('information'); ?></a>
			</li>
	<?php } ?>
		</ul>
		
		<div class="tab-content">
			<div id="list" class="tab-pane <?php echo (!isset($validation_error) ? 'active' : ''); ?>">
				<table class="table table-bordered table-hover table-condensed table_default" cellspacing="0" width="100%">
					<thead>
						<tr>
							<th><?php echo translate('sl'); ?></th>
							<th><?php echo translate('datetime'); ?></th>
							<th><?php echo translate('name'); ?></th>
							<th><?php echo translate('phone'); ?></th>
							<th><?php echo translate('address'); ?></th>
							<th><?php echo translate('email'); ?></th>
							<th><?php echo translate('group'); ?></th>
							<th><?php echo translate('action'); ?></th>
						</tr>
					</thead>
					<tbody>
						<?php
							$count = 1;
							if (!empty($contact_list)) {
								foreach ($contact_list as $row):
								?>
						<tr>
							<td><?php echo $count++; ?></td>
							<td><?php echo $row['datetime']; ?></td>
							<td>
							   <a href="<?php echo base_url('contacts/contact_details/' . $row['id']); ?>" class="" data-toggle="tooltip">
								  <?php echo $row['name']; ?>
							   </a>
							</td>
							<td><?php echo $row['phone']; ?></td>
							<td><?php echo $row['address']; ?></td>
							<td><?php echo $row['email']; ?></td>
							<td><?php echo $row['group_name']; ?></td>
							<td>
							<a class="btn btn-default btn-circle icon" href="javascript:void(0);" data-toggle="tooltip" data-original-title="<?php echo translate('edit');?>"
									onclick="getContact('<?php echo html_escape($row['id']); ?>')">
										<i class="fas fa-pen-nib"></i>
									</a>
							<?php
								if (get_permission('contacts_list', 'is_delete')) {
									echo btn_delete('contacts/delete/' . $row['id']);
								}
							?>
							</td>
						</tr>
						<?php endforeach; }?>
					</tbody>
				</table>
			</div>
	<?php if (get_permission('contacts_list', 'is_add')) { ?>
			
			  <!-- Add the Download Sample button here -->
			<div class="tab-pane <?php echo (isset($validation_error) ? 'active' : ''); ?>" id="create">
				<?php //echo form_open_multipart($this->uri->uri_string(), array('class' => 'form-horizontal form-bordered')); ?>
				<!--------------------- TODO: Download CSV File-------------- -->
					<div class="form-group">
					  <label class="col-md-3 control-label"><?php echo translate('Download Sample'); ?> <span class="required">*</span></label>
					    <div class="col-md-8">
							<a href="https://voice.tolpar.com.bd/contact_center/assets/file/CSV/upload_sample_tts.csv" download > 
							 <button class="btn btn-default" id="download_sample_create">
							   <i class="fas fa-download" style="color: #FFB534;"></i> <?php echo translate('Download Sample'); ?>
						     </button>
							</a>
					    </div>
                    </div>
					<div id="upload_area">
					  <form method="post" id="upload_form" enctype="multipart/form-data" >
					
					<div class="form-group <?php if (form_error('title')) echo 'has-error'; ?>">
						<label class="col-md-3 control-label"><?php echo translate('Group') . " " . translate('name'); ?> <span class="required">*</span></label>
						<div class="col-md-8">
							<input type="text" class="form-control" name="group_name" value="" required />
						</div>
					</div>
				
				
				
					<div class="form-group <?php if (form_error('photo')) echo 'has-error'; ?>">
						<label class="col-md-3 control-label"><?php echo translate('select CSV'); ?> <span class="required">*</span></label>
						<div class="col-md-8">
							<input type="file" name="file" class="dropify" data-height="150" data-default-file="" id="csv_file" />
							<span class="error"><?php echo form_error('photo'); ?></span>
						</div>
					</div>

					
					<footer class="panel-footer mt-lg">
						<div class="row">
							<div class="col-md-2 col-md-offset-3">
						
								<button type="submit" class="btn btn-default btn-block"  name="upload_file" id="upload_file"  value="Upload">
									<i class="fas fa-plus-circle"></i> <?php echo translate('upload'); ?>
								</button>
							</div>
						</div>	
					</footer>
					</form>
					</div>
				<?php //echo form_close(); ?>
				
				
				 <div class="table-responsive" id="process_area">

				 </div>
			</div>
	<?php } ?>
		</div>
	</div>
</section>


<div class="zoom-anim-dialog modal-block modal-block-primary mfp-hide" id="modal">
	<section class="panel">
		<header class="panel-heading">
			<h4 class="panel-title">
				<i class="far fa-edit"></i> <?php echo translate('edit') . " " . translate('Contact'); ?>
			</h4>
		</header>
		
		
		<?php echo form_open(base_url('contacts/index'), array('class' => 'validate')); ?>
			<div class="panel-body">
				<input type="hidden" name="contact_id" id="econtact_id" value="" />
				<input type="hidden" name="datetime" id="edatetime" value="" />
				<input type="hidden" name="user_id" id="euser_id" value="" />
				<div class="form-group mb-md">
					<label class="control-label">Name<span class="required">*</span></label>
					<input type="text" class="form-control" required  value="" name="name" id="ename" />
				</div>
				
				<div class="form-group mb-md">
					<label class="control-label">Phone<span class="required">*</span></label>
					<input type="text" class="form-control" required  value="" name="phone" id="ephone" />
				</div>
				
				<div class="form-group mb-md">
					<label class="control-label">Address<span class="required">*</span></label>
					<input type="text" class="form-control" required  value="" name="address" id="eaddress" />
				</div>
				
				<div class="form-group mb-md">
					<label class="control-label">Email<span class="required">*</span></label>
					<input type="text" class="form-control" required  value="" name="email" id="eemail" />
				</div>
				
				<div class="form-group mb-md">
					<label class="control-label">Group<span class="required">*</span></label>
					<input type="text" class="form-control" required  value="" name="group_name" id="egroup_name" readonly />
				</div>
				

			</div>
			<footer class="panel-footer">
				<div class="row">
					<div class="col-md-12 text-right">
						<button type="submit" class="btn btn-default"><?php echo translate('update'); ?></button>
						<button class="btn btn-default modal-dismiss"><?php echo translate('cancel'); ?></button>
					</div>
				</div>
			</footer>
		<?php echo form_close(); ?>
	</section>
</div>



<script>
$(document).ready(function(){

  $('#upload_form').on('submit', function(event){

    event.preventDefault();
    $.ajax({
	  url: base_url + 'contacts/csv_upload_preview',
      method:"POST",
      data:new FormData(this),
      dataType:'json',
      contentType:false,
      cache:false,
      processData:false,
      success:function(data)
      {
        if(data.error != '')
        {
          $('#message').html('<div class="alert alert-danger">'+data.error+'</div>');
        }
        else
        {
          $('#process_area').html(data.output);
          $('#upload_area').css('display', 'none');
        }
      }
    });

  });

  var total_selection = 0;

  var name = 0;

  var phone = 0;

  var address = 0;
  
  var email = 0;

  var column_data = [];

  $(document).on('change', '.set_column_data', function(){

    var column_name = $(this).val();

    var column_number = $(this).data('column_number');

    if(column_name in column_data)
    {
      alert('You have already define '+column_name+ ' column');

      $(this).val('');

      return false;
    }

    if(column_name != '')
    {
      column_data[column_name] = column_number;
    }
    else
    {
      const entries = Object.entries(column_data);

      for(const [key, value] of entries)
      {
        if(value == column_number)
        {
          delete column_data[key];
        }
      }
    }

    total_selection = Object.keys(column_data).length;

    if(total_selection >= 2)
    {
      $('#import').attr('disabled', false);

      name = column_data.name;

      phone = column_data.phone;

      address = column_data.address;
	  
      email = column_data.email;
    }
    else
    {
      $('#import').attr('disabled', 'disabled');
    }

  });

  $(document).on('click', '#import', function(event){

    event.preventDefault();

    $.ajax({
	  url: base_url + 'contacts/csv_insert_data',
      method:"POST",
      data:{name:name, phone:phone, address:address, email:email, group_name: $('input[name="group_name"]').val() },
      beforeSend:function(){
        $('#import').attr('disabled', 'disabled');
        $('#import').text('Importing...');
      },
      success:function(data)
      {
        $('#import').attr('disabled', false);
        $('#import').text('Import');
        $('#process_area').css('display', 'none');
        $('#upload_area').css('display', 'block');
        $('#upload_form')[0].reset();
        $('#message').html("<div class='alert alert-success'>"+data+"</div>");

		window.location.href = base_url + 'contacts'; 
		<?php //set_alert('success', translate('data uploaded successfully'));?>
      }
    })

  });
  
});
</script>