<?php
$userID = get_loggedin_user_id();
$current_time = date('Y-m-d H:i:s');
//$connect = new PDO("mysql:host=localhost; dbname=contact_center", "root", "");


if (isset($_POST["name"])) {
    $file_data = $_SESSION['file_data'];
    unset($_SESSION['file_data']);
    $group_name = $_POST["group_name"] ?? '';
    $datetime = date('Y-m-d H:i:s');
    $assigned_to = get_loggedin_user_id();

    $total_data = count($file_data);
    $inserted_data = 0;
    $errors = [];
    foreach ($file_data as $line => $row) {

        $data = [
            'name' => isset($row[$_POST["name"]]) ? $row[$_POST["name"]] : '',
            'birthday' => isset($row[$_POST["birthday"]]) ? $row[$_POST["birthday"]] : '',
            'mobile_no' => isset($row[$_POST["mobile_no"]]) ? $row[$_POST["mobile_no"]] : '',
            'email' => isset($row[$_POST["email"]]) ? $row[$_POST["email"]] : '',
            'username' => isset($row[$_POST["username"]]) ? $row[$_POST["username"]] : '',
            'password' => isset($row[$_POST["password"]]) ? $row[$_POST["password"]] : '',
            'nas_id' => isset($row[$_POST["nas_id"]]) ? $row[$_POST["nas_id"]] : '',
            'zone_id' => isset($row[$_POST["zone_id"]]) ? $row[$_POST["zone_id"]] : '',
            'connection_type' => isset($row[$_POST["connection_type"]]) ? $row[$_POST["connection_type"]] : '',
            'package_id' => isset($row[$_POST["package_id"]]) ? $row[$_POST["package_id"]] : '',
            'client_type' => $row[$_POST["client_type"]] ?? '',
            'server_username' => isset($row[$_POST["server_username"]]) ? $row[$_POST["server_username"]] : '',
            'server_password' => isset($row[$_POST["server_password"]]) ? $row[$_POST["server_password"]] : '',
            'expire_date' => isset($row[$_POST["expire_date"]]) ? $row[$_POST["expire_date"]] : '',
            'assign_to' => $assigned_to,
            'user_role' => ROLE_CUSTOMER_ID,
        ];

        if ($this->isValidName($data['name'])){
            $errors[] = 'Invalid name on line '. ($line +1);
        }

        if ($this->isValidEmailAddress($data['email'])){
            $errors[] = 'Invalid email address on line '. ($line +1);
        }

        if ($this->isUniqueEmailAddress($data['email'])){
            $errors[] = 'The email address on line '. ($line +1) . ' is already on the database.';
        }

        if ($this->isValidMobileNumber($data['mobile_no'])){
            $errors[] = 'Invalid mobile number on line '. ($line +1);
        }

        if ($this->employee_model->save($data)) {
            $inserted_data++;
        }
    }
    set_alert('success', 'Data Imported Successfully. Total Data: ' . $total_data . ', Imported Data: ' . $inserted_data);

    $returnData = [
        'status' =>     'success',
        'message' =>    'Data Imported Successfully. Total Data: ' . $total_data . ', Imported Data: ' . $inserted_data,
    ];

} else {
    set_alert('danger', 'No data imported');

    $returnData =[
        'status' =>     'error',
        'message' =>    'No data imported'
    ];
}

echo json_encode($returnData);
