<div class="row">

	

	<div class="col-md-12">
		<section class="panel">
			<header class="panel-heading">
				<h4 class="panel-title"><i class="fas fa-list-ul"></i> <?php echo translate('Contact') . " " . translate('Groups'); ?></h4>
			</header>
			<div class="panel-body">
				<div class="table-responsive">
					<table class="table table-bordered table-hover table-condensed mb-none">
						<thead>
							<tr>
								<th><?php echo translate('sl'); ?></th>
								<th><?php echo translate('created time'); ?></th>
								<th><?php echo translate('Contact Group'); ?></th>
								<th><?php echo translate('Total Contacts'); ?></th>
								<th><?php echo translate('Assigned To'); ?></th>
								<th><?php echo translate('Customer'); ?></th>
								<th><?php echo translate('status'); ?></th>
								<th><?php echo translate('action'); ?></th>
							</tr>
						</thead>
						<tbody>
						<?php
						
						$count = 1;
						if (!empty($contact_group_list)){
							foreach ($contact_group_list as $row):
							?>
							<tr>
								<td><?php echo $count++; ?></td>
								<td><?php echo html_escape($row['created_date']); ?></td>
								<td><?php echo html_escape($row['contact_group']); ?></td>
								<td>
									<?php
									foreach ($contact_count as $count_row) {
										if ($count_row['group_name'] == $row['contact_group']) {
											echo $count_row['contact_count'];
											break;
										}
									}
									?>
								</td>
								<td>
									<?php
									$assigned_to_list = explode(',', trim($row['assigned_to'], '{}'));
									$firstIteration = true;

									foreach ($assigned_to_list as $agent_id) {
										foreach ($all_agents as $ag_list) {
											if ($ag_list->id == $agent_id) {
												echo ($firstIteration ? '' : ', ') . html_escape($ag_list->name);
												$firstIteration = false;
												break;
											}
										}
									}
									?>
								</td>
								<td>
								<?php
									$assigned_customers_list = explode(',', trim($row['assigned_customers'], '{}'));
									$firstIteration = true;

									foreach ($assigned_customers_list as $c_id) {
										foreach ($all_customers as $c_list) {
											if ($c_list->id == $c_id) {
												echo ($firstIteration ? '' : ', ') . html_escape($c_list->name);
												$firstIteration = false;
												break;
											}
										}
									}
									?>
								</td>
								<td><?php echo html_escape($row['status']); ?></td>
								<td>
									<a class="btn btn-default btn-circle icon" href="javascript:void(0);" data-toggle="tooltip" data-original-title="<?php echo translate('edit');?>"
									onclick="getContactAssign('<?php echo html_escape($row['id']); ?>')">
										<i class="fas fa-pen-nib"></i>
									</a>
									<?php echo btn_delete('contacts/contacts_group_delete/' . $row['id']); ?>
								</td>
							</tr>
						<?php
								endforeach;
							}else{
								echo '<tr><td colspan="8"><h5 class="text-danger text-center">' . translate('no_information_available') . '</td></tr>';
							}
						?>
						</tbody>
					</table>
				</div>
			</div>
		</section>
	</div>
</div>


<div class="zoom-anim-dialog modal-block modal-block-primary mfp-hide" id="modal">
	<section class="panel">
		<header class="panel-heading">
			<h4 class="panel-title">
				<i class="far fa-edit"></i> <?php echo translate('edit') . " " . translate('Contact Assign'); ?>
			</h4>
		</header>
		
		
		<?php echo form_open(base_url('contacts/assign_to'), array('class' => 'validate')); ?>
			<div class="panel-body">
				<input type="hidden" name="id" id="e_id" value="" />
				<input type="hidden" class="form-control" required  value="" name="created_date" id="ecreated_date" />
				<div class="form-group mb-md">
					<label class="control-label">Contact Group<span class="required">*</span></label>
					<input type="text" class="form-control" required  value="" name="contact_group" id="econtact_group" readonly />
				</div>
				
				
				<div class="form-group mb-md">
					<label class="control-label">Assigned To<span class="required">*</span></label>
					<?php
						foreach ($all_agents as $ag_list) {
							$agent_id = $ag_list->id;
							$agent_name = $ag_list->name;
							$all_agents_list[$agent_id] =$agent_name;
						}
						echo form_dropdown("selected_agents[]", $all_agents_list, 'eassigned_to', "class='form-control' data-plugin-selectTwo data-width='100%' data-minimum-results-for-search='Infinity' multiple='multiple'");
						?>
				</div>
				
				<div class="form-group mb-md">
					<label class="control-label">Assigned Customer<span class="required">*</span></label>
					<?php
						foreach ($all_customers as $c_list) {
							$c_id = $c_list->id;
							$c_name = $c_list->name;
							$all_customers_list[$c_id] =$c_name;
						}
						echo form_dropdown("selected_customers[]", $all_customers_list, 'eassigned_customers', "class='form-control' data-plugin-selectTwo data-width='100%' data-minimum-results-for-search='Infinity' multiple='multiple'");
						?>
				</div>
				
				<div class="form-group mb-md">
					<label class="control-label">Status<span class="required">*</span></label>
					
					<select class='form-control' name="status" id="estatus" data-width='100%' >
							  <option value="Active">Active</option>
							  <option value="Inactive">Inactive</option>
					</select>

				</div>

			</div>
			<footer class="panel-footer">
				<div class="row">
					<div class="col-md-12 text-right">
						<button type="submit" class="btn btn-default"><?php echo translate('update'); ?></button>
						<button class="btn btn-default modal-dismiss"><?php echo translate('cancel'); ?></button>
					</div>
				</div>
			</footer>
		<?php echo form_close(); ?>
	</section>
</div>