<!-- chat modal -->
<div class="modal fade right-side-modal" id="modal" tabindex="-1" role="dialog" aria-labelledby="modalLabel"
     aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalLabel">
                    <?= translate('Client :') . " <b>$client_support->client_name</b>" ?>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </h5>
            </div>

            <?= form_open(
                'client_support/problem_category_change_modal',
                "id='problemCategoryForm'",
                ['client_support_id' => $client_support->id]
            ); ?>
            <div class="modal-body">
                <!-- Problem Category -->
                <div class="form-group">
                    <label for="problem_category"><?= translate('problem_category'); ?></label>
                    <?= form_dropdown('problem_category', $problem_categories ?? [], $client_support->problem_category, 'class="form-control" name="problem_category" id="problem_category" data-plugin-selecttwo'); ?>
                </div>
            </div>

            <div class="modal-footer">
                <button type="button" class="btn btn-primary btn-sm pull-right" onclick="submitProblemCategory(this)">
                    <i class="fa fa-paper-plane"></i>
                    <?= translate('update'); ?>
                </button>
            </div>
            <?= form_close(); ?>
        </div>
    </div>
</div>

<script>
    function submitProblemCategory(object) {
        // get closest formData
        const form = $(object).closest('form');
        const formData = new FormData(form[0]);
        // get selected problem category html

        $.ajax({
            url: form.attr('action'),
            type: 'POST',
            data: {
                client_support_id: formData.get('client_support_id'),
                problem_category: formData.get('problem_category')
            },
            dataType: 'json',
            success: function (response) {
                // close this modal
                $('#modal').modal('hide');
                if (response.status === 'success') {
                    // Display a success message
                    //alert(response.success)  // notify is a custom function

                    const problemCategory = $('#problem_category option:selected').text();
                    $(`button[data-support-id="${formData.get('client_support_id')}"]`).closest('td').find('span').text(problemCategory);
                    window.location.reload();
                } else if (response.status === 'error') {
                    // Display error message
                    alert(response.error);   // notify is a custom function
                }
            },
            error: function (jqXHR, textStatus) {
                // Handle the error here
                console.error(jqXHR, textStatus);
            }
        });
    }
</script>