<div class="row">
    <div class="col-md-12">
        <section class="panel">
            <?= form_open_multipart(current_url()); ?>
            <div class="panel-heading">
                <h4 class="panel-title">
                    <i class="fa fa-server"></i> <?= translate('create_support_ticket'); ?>
                </h4>
            </div>

            <div class="panel-body">
                <span><?= validation_errors() ?></span>

                <!-- User Name (ID) -->
                <div class="form-group">
                    <label for="user_id" class="control-label">
                        <?= translate('User Name'); ?>
                        <span class="required">*</span>
                    </label>
                    <div class="input-group">
                        <span class="input-group-addon"><i class="fa fa-user"></i></span>
                        <select class="form-control" name="user_id" id="user_id" data-plugin-selecttwo required>
                            <option value=""><?= translate('Select a User'); ?></option>
                            <?php if (!empty($users)): ?>
                                <?php foreach ($users as $user) : ?>
                                    <option value="<?= $user->id; ?>" <?= set_select('user_id', $user->id) ?>>
                                        <?= '(' . $user->id . ')' . '-- (' . $user->staff_id . ')' . '-- (' . $user->name . ')' . '-- (' . $user->mobileno . ')' . '-- (' . $user->server_username . ')'; ?>
                                    </option>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </select>

                    </div>
                </div>

                <hr>

                <div class="row">
                    <!-- Customer Name -->
                    <div class="form-group col-sm-3">
                        <label for="customer_name" class="control-label"><?= translate('customer_name'); ?></label>
                        <div class="input-group">
                            <span class="input-group-addon"><i class="fa fa-user"></i></span>
                            <input class="form-control" name="customer_name" id="customer_name" type="text"
                                   value="<?= set_value('customer_name'); ?>" readonly>
                        </div>
                    </div>

                    <!-- Mobile Number -->
                    <div class="form-group col-sm-3">
                        <label for="mobile_number" class="control-label"><?= translate('mobile_number'); ?></label>
                        <div class="input-group">
                            <span class="input-group-addon"><i class="fa fa-phone"></i></span>
                            <input class="form-control " name="mobile_number" id="mobile_number" type="text"
                                   value="<?= set_value('mobile_number'); ?>" readonly>
                        </div>
                    </div>

                    <!-- Client Address -->
                    <div class="form-group col-sm-3">
                        <label for="client_address" class="control-label"><?= translate('client_address'); ?></label>
                        <div class="input-group">
                            <span class="input-group-addon"><i class="fa fa-map-marker"></i></span>
                            <input class="form-control " name="client_address" id="client_address" type="text"
                                   value="<?= set_value('client_address'); ?>" readonly>
                        </div>
                    </div>

                    <!-- Zone -->
                    <div class="form-group col-sm-3">
                        <label for="zone" class="control-label"><?= translate('zone'); ?></label>
                        <div class="input-group">
                            <span class="input-group-addon"><i class="fa fa-map"></i></span>
                            <input class="form-control " name="zone" id="zone" type="text"
                                   value="<?= set_value('zone'); ?>" readonly>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <!-- Billing Status -->
                    <div class="form-group col-sm-2">
                        <label for="billing_status" class="control-label"><?= translate('billing_status'); ?></label>
                        <div class="input-group">
                            <span class="input-group-addon"><i class="fa fa-dollar-sign"></i></span>
                            <input class="form-control " name="billing_status" id="billing_status" type="text"
                                   value="<?= set_value('billing_status'); ?>" readonly>
                        </div>
                    </div>

                    <!-- Monthly Bill -->
                    <div class="form-group col-sm-2">
                        <label for="monthly_bill" class="control-label"><?= translate('monthly_bill'); ?> <span
                                    class="required">*</span></label>
                        <div class="input-group">
                            <span class="input-group-addon"><i class="fa fa-dollar-sign"></i></span>
                            <input class="form-control " name="monthly_bill" id="monthly_bill" type="text"
                                   value="<?= set_value('monthly_bill'); ?>" readonly>
                        </div>
                    </div>

                    <!-- Last Paid Amount -->
                    <div class="form-group col-sm-3">
                        <label for="last_paid_amount"
                               class="control-label"><?= translate('last_paid_amount'); ?></label>
                        <div class="input-group">
                            <span class="input-group-addon"><i class="fa fa-dollar-sign"></i></span>
                            <input class="form-control " name="last_paid_amount" id="last_paid_amount"
                                   type="text"
                                   value="<?= set_value('last_paid_amount'); ?>" readonly>
                        </div>
                    </div>

                    <!-- Payment Status -->
                    <div class="form-group col-sm-3">
                        <label for="payment_status" class="control-label"><?= translate('payment_status'); ?></label>
                        <div class="input-group">
                            <span class="input-group-addon"><i class="fa fa-dollar-sign"></i></span>
                            <input class="form-control " name="payment_status" id="payment_status" type="text"
                                   value="<?= set_value('payment_status'); ?>" readonly>
                        </div>
                    </div>

                    <!-- Mikrotik Status -->
                    <div class="form-group col-sm-2">
                        <label for="mikrotik_status" class="control-label"><?= translate('mikrotik_status'); ?></label>
                        <div class="input-group">
                            <span class="input-group-addon"><i class="fa fa-wifi"></i></span>
                            <input class="form-control " name="mikrotik_status" id="mikrotik_status"
                                   type="text"
                                   value="<?= set_value('mikrotik_status'); ?>" readonly>
                        </div>
                    </div>
                </div>

                <hr>

                <div class="row">
                    <!-- Connectivity Status -->
                    <div class="form-group col-sm-3">
                        <label for="connectivity_status"
                               class="control-label"><?= translate('connectivity_status'); ?></label>
                        <div class="input-group">
                            <span class="input-group-addon"><i class="fa fa-wifi"></i></span>
                            <input class="form-control " name="connectivity_status" id="connectivity_status"
                                   type="text" value="<?= set_value('connectivity_status'); ?>" readonly>
                        </div>
                    </div>

                    <!-- Uptime -->
                    <div class="form-group col-sm-3">
                        <label for="uptime" class="control-label"><?= translate('uptime'); ?></label>
                        <div class="input-group">
                            <span class="input-group-addon"><i class="fa fa-clock"></i></span>
                            <input class="form-control " name="uptime" id="uptime" type="text"
                                   value="<?= set_value('uptime'); ?>" readonly>
                        </div>
                    </div>

                    <!-- MAC Address/Caller ID -->
                    <div class="form-group col-sm-3">
                        <label for="mac_address_caller_id"
                               class="control-label"><?= translate('mac_address_caller_id'); ?> </label>
                        <div class="input-group">
                            <span class="input-group-addon"><i class="fa fa-id-card"></i></span>
                            <input class="form-control " name="mac_address_caller_id" id="mac_address_caller_id"
                                   type="text" value="<?= set_value('mac_address_caller_id'); ?>" readonly>
                        </div>
                    </div>

                    <!-- IP Address -->
                    <div class="form-group col-sm-3">
                        <label for="ip_address" class="control-label"><?= translate('ip_address'); ?> </label>
                        <div class="input-group">
                            <span class="input-group-addon"><i class="fa fa-globe"></i></span>
                            <input class="form-control " name="ip_address" id="ip_address" type="text"
                                   value="<?= set_value('ip_address'); ?>" readonly>
                        </div>
                    </div>

                    <!-- Device Vendor Name -->
                    <div class="form-group col-sm-3">
                        <label for="device_vendor_name"
                               class="control-label"><?= translate('device_vendor_name'); ?> </label>
                        <div class="input-group">
                            <span class="input-group-addon"><i class="fa fa-industry"></i></span>
                            <input class="form-control " name="device_vendor_name" id="device_vendor_name"
                                   type="text" value="<?= set_value('device_vendor_name'); ?>" readonly>
                        </div>
                    </div>

                    <!-- Last Logout Time -->
                    <div class="form-group col-sm-3">
                        <label for="last_logout_time"
                               class="control-label"><?= translate('last_logout_time'); ?> </label>
                        <div class="input-group">
                            <span class="input-group-addon"><i class="fa fa-clock"></i></span>
                            <input class="form-control " name="last_logout_time" id="last_logout_time"
                                   type="text"
                                   value="<?= set_value('last_logout_time'); ?>" readonly>
                        </div>
                    </div>
                </div>

                <hr>

                <div class="row">
                    <!-- Problem Category -->
                    <div class="form-group col-sm-3">
                        <label for="problem_category" class="control-label">
                            <?= translate('problem_category'); ?>
                            <span class="required">*</span>
                        </label>
                        <div class="input-group">
                            <span class="input-group-addon"><i class="fa fa-list"></i></span>
                            <select class="form-control" name="problem_category" id="problem_category"
                                    data-plugin-selecttwo required>
                                <option value=""><?= translate('Select a Category'); ?></option>
                                <?php if (!empty($problem_categories)): ?>
                                    <?php foreach ($problem_categories as $problem_category) : ?>
                                        <option value="<?= $problem_category->id; ?>"
                                            <?= set_select('problem_category', $problem_category->id) ?>>
                                            <?= $problem_category->name; ?>
                                        </option>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </select>
                        </div>
                    </div>

                    <!-- Problem Priority -->
                    <div class="form-group col-sm-3">
                        <label for="problem_priority" class="control-label">
                            <?= translate('problem_priority'); ?> <span class="required">*</span>
                        </label>
                        <div class="input-group">
                            <span class="input-group-addon"><i class="fa fa-exclamation-circle"></i></span>
                            <select class="form-control" name="problem_priority" id="problem_priority"
                                    data-plugin-selecttwo required>
                                <option value=""><?= translate('Select a Priority'); ?></option>
                                <?php if (!empty($problem_priorities)): ?>
                                    <?php foreach ($problem_priorities as $key => $value) : ?>
                                        <option value="<?= $key; ?>" <?= set_select('problem_priority', $key) ?>>
                                            <?= $value; ?>
                                        </option>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </select>
                        </div>
                    </div>

                    <!-- Complained Number -->
                    <div class="form-group col-sm-3">
                        <label for="complained_number" class="control-label">
                            <?= translate('complained_number'); ?> <span class="required">*</span>
                        </label>
                        <div class="input-group">
                            <span class="input-group-addon"><i class="fa fa-phone"></i></span>
                            <input class="form-control " name="complained_number" id="complained_number"
                                   type="text" value="<?= set_value('complained_number'); ?>" required>
                        </div>
                    </div>

                    <!-- assign to -->
                    <div class="form-group col-sm-3">
                        <label for="assign_to" class="control-label">
                            <?= translate('assign_to'); ?> <span class="required">*</span>
                        </label>
                        <div class="input-group">
                            <span class="input-group-addon"><i class="fa fa-exclamation-circle"></i></span>
                            <select class="form-control" name="assign_to" id="assign_to"
                                    data-plugin-selecttwo required>
                                <option value=""><?= translate('Select a Priority'); ?></option>
                                <?php if (!empty($parents)): ?>
                                    <?php foreach ($parents as $value) : ?>
                                        <option value="<?= $value->id; ?>" <?= set_select('assign_to', $value->id, get_loggedin_user_id() == $value->id) ?>>
                                            <?= $value->name; ?>
                                        </option>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </select>
                        </div>
                    </div>


                    <!-- Attachment -->
                    <div class="form-group col-sm-12">
                        <label for="input-file-now"><?php echo translate('attachment'); ?></label>
                        <input type="file" name="attachment" class="dropify" data-allowed-file-extensions="jpg png"
                               data-height="120"/>
                    </div>
                </div>

                <!-- Remarks/Note/Comments -->
                <div class="form-group">
                    <label for="problem_description" class="control-label">
                        <?= translate('problem_description'); ?> <span class="required">*</span></label>
                    <div class="input-group">
                        <span class="input-group-addon"><i class="fa fa-comments"></i></span>
                        <textarea class="form-control" name="problem_description" id="problem_description"
                                  required><?= set_value('problem_description'); ?></textarea>
                    </div>
                </div>
            </div>
            <footer class="panel-footer">
                <div class="row">
                    <div class="col-md-offset-10 col-md-2">
                        <button type="submit" name="submit" value="save" class="btn btn btn-default btn-block">
                            <i class="fas fa-plus-circle"></i>
                            <?= translate('submit'); ?>
                        </button>
                    </div>
                </div>
            </footer>
            <?= form_close(); ?>
        </section>
    </div>
</div>

<script src="https://cdn.ckeditor.com/4.16.0/standard/ckeditor.js"></script>

<script>
    CKEDITOR.replace('problem_description');
</script>

<script>
    $(function () {
        $('#user_id').change(function () {
            const user_id = $(this).val();
            if (user_id !== '') {
                $.ajax({
                    url: `<?= base_url('client_support/get_user_info'); ?>`,
                    type: 'post',
                    data: {user_id: user_id},
                    dataType: 'json',
                    success: function (response) {
                        console.log(response);

                        $('#customer_name').val(response.name);
                        $('#mobile_number').val(response.mobileno);
                        $('#client_address').val(response.address);
                        $('#zone').val(response.zone);
                        $('#billing_status').val(response.billing_status);
                        $('#monthly_bill').val(response.monthly_bill);
                        $('#last_paid_amount').val(response.last_paid_amount);
                        $('#payment_status').val(response.payment_status);
                        $('#mikrotik_status').val(response.mikrotik.status);
                        $('#uptime').val(response.mikrotik.user_status_info.uptime);
                        $('#mac_address_caller_id').val(response.mikrotik.user_status_info.callerid);
                        $('#ip_address').val(response.mikrotik.user_status_info.address);
                        $('#device_vendor_name').val(response.mikrotik.user_status_info.deviceVendorName);
                        $('#connectivity_status').val(response.mikrotik.user_status_info.status);
                        $('#last_logout_time').val(response.mikrotik.user_secret_info.lastloggedout);
                    }
                });
            }
        });
    });
</script>