<script src="https://code.jquery.com/jquery.js"></script>
<?php if (loggedin_role_id() != ROLE_CUSTOMER_ID) : ?>
    <section class="panel-group" id="accordion">
        <div class="panel panel-accordion">
            <div class="panel-heading">
                <h4 class="panel-title">
                    <a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion"
                        href="#client_filter_field"><?php echo translate('Search with Filter'); ?></a>
                </h4>
            </div>

            <div id="client_filter_field"
                class="accordion-body collapse <?php echo ($this->session->flashdata('active_box') == 1 ? 'in' : ''); ?>">
                <?php echo form_open($this->uri->uri_string()); ?>
                <div class="panel-body">
                    <?php if (!in_array(loggedin_role_id(), array(2, 3, 4))) { ?>
                        <div class="col-md-3 mb-lg">
                            <div class="form-group <?= form_error('reseller_subreseller_id') ? 'has-error' : null ?>">
                                <label for="reseller_subreseller_id" class="control-label">
                                    <?php
                                    if (loggedin_role_id() != 2 && loggedin_role_id() != 4) {
                                        echo translate('Branch_list');
                                    } elseif (loggedin_role_id() == 2) {
                                        echo translate('Sub_Manager_list');
                                    }
                                    ?>
                                    <span class="required"></span>
                                </label>
                                <div class="input-group">
                                    <span class="input-group-addon"><i class="fas fa-users"></i></span>
                                    <select class="form-control" data-plugin-selectTwo data-width="100%"
                                        name="reseller_subreseller_id"
                                        id="reseller_subreseller_id">
                                        <?php /** @var array<array> $nasList */ ?>
                                        <?php if (empty($reseller_subreseller_list)): ?>
                                            <option value=""><?= translate('No Manager Found'); ?></option>
                                        <?php else: ?>
                                            <option value=""><?= translate('Select') ?></option>
                                            <?php foreach ($reseller_subreseller_list as $reseller_subreseller): ?>
                                                <option value="<?= $reseller_subreseller->id ?>" <?= set_select('reseller_subreseller_id', $reseller_subreseller->id) ?>>
                                                    <?= html_escape($reseller_subreseller->name) ?>
                                                </option>
                                            <?php endforeach; ?>
                                        <?php endif; ?>

                                    </select>
                                    <span class="error"><?= form_error('reseller_subreseller_id'); ?></span>
                                </div>
                            </div>
                        </div>
                    <?php } ?>

                    <div class="col-md-3 mb-lg">
                        <div class="form-group <?= form_error('package_list_id') ? 'has-error' : null ?>">
                            <label for="package_list_id" class="control-label">
                                <?= translate('package_list'); ?>
                                <span class="required"></span>
                            </label>
                            <div class="input-group">
                                <span class="input-group-addon"><i class="fas fa-list-ul"></i></span>
                                <select class="form-control" data-plugin-selectTwo data-width="100%"
                                    name="package_list_id"
                                    id="package_list_id">
                                    <?php /** @var array<array> $nasList */ ?>
                                    <?php if (empty($package_list)): ?>
                                        <option value=""><?= translate('No Package Found'); ?></option>
                                    <?php else: ?>
                                        <option value=""><?= translate('Select A Package') ?></option>
                                        <?php foreach ($package_list as $package): ?>
                                            <option value="<?= $package->id ?>" <?= set_select('package_list_id', $package->id) ?>>
                                                <?= html_escape($package->name) ?>
                                            </option>
                                        <?php endforeach; ?>
                                    <?php endif; ?>

                                </select>
                                <span class="error"><?= form_error('package_list_id'); ?></span>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 mb-lg">
                        <div class="form-group">
                            <label class="control-label"><?php echo translate('date'); ?> <span class="required"></span></label>
                            <div class="input-group">
                                <span class="input-group-addon"><i class="fas fa-calendar-check"></i></span>
                                <input type="text" class="form-control daterange" name="daterange" id="daterange"
                                    value="<?php echo set_value('daterange', date("2024/1/1") . ' - ' . date("Y/m/d")); ?>" />
                            </div>
                        </div>
                    </div>
                </div>
                <footer class="panel-footer">
                    <div class="row">
                        <div class="col-md-offset-10 col-md-2">
                            <button type="button" name="btn-filter" id="btn-filter" value="1"
                                class="btn btn btn-default btn-block"><i
                                    class="fas fa-filter"></i> <?php echo translate('filter'); ?></button>
                        </div>
                    </div>
                </footer>
                <?php echo form_close(); ?>
            </div>
        </div>
    </section>
<?php endif ?>

<section class="panel">
    <div class="tabs-custom">
        <ul class="nav nav-tabs">
            <?php if (get_permission('client', 'is_view')) { ?>
                <li class="<?php echo (!isset($validation_error) ? 'active' : ''); ?>">
                    <a href="#list" data-toggle="tab"><i
                            class="fas fa-list-ul"></i> <?php echo translate('Client') . " " . translate('list'); ?>
                    </a>
                </li>
            <?php }
            if (get_permission('client_upload', 'is_add')) { ?>
                <!-- <li class="<?php echo (isset($validation_error) ? 'active' : ''); ?>">
                    <a href="#create" data-toggle="tab"><i
                                class="far fa-edit"></i> <?php echo translate('upload') . " " . translate('information'); ?>
                    </a>
                </li> -->
            <?php } ?>
        </ul>

        <div class="tab-content">
            <div id="list" class="tab-pane <?php echo (!isset($validation_error) ? 'active' : ''); ?>">
                <div class="row">
                    <div class="col-md-12">
                        <div class="table-responsive mb-sm mt-xs">
                            <?php $this->datatables->generate('dt_authors'); ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php if (get_permission('client_upload', 'is_add')) { ?>

                <!-- Add the Download Sample button here -->
                <div class="tab-pane <?php echo (isset($validation_error) ? 'active' : ''); ?>" id="create">
                    <?php //echo form_open_multipart($this->uri->uri_string(), array('class' => 'form-horizontal form-bordered')); 
                    ?>
                    <!--------------------- TODO: Download CSV File-------------- -->
                    <div class="form-group">
                        <label class="col-md-3 control-label">
                            <?= translate('Download Sample'); ?>
                            <span class="required">*</span></label>
                        <div class="col-md-8">
                            <a href="<?= base_url("assets/file/CSV/upload_sample_tts.csv") ?> "
                                download>
                                <button class="btn btn-default" id="download_sample_create">
                                    <i class="fas fa-download" style="color: #FFB534;"></i>
                                    <?= translate('Download Sample'); ?>
                                </button>
                            </a>
                        </div>
                    </div>
                    <br>

                    <div id="upload_form_errors" class="alert-danger p-lg" style="display: none;">

                    </div>

                    <form method="post" id="upload_form" enctype="multipart/form-data">

                        <div class="form-group <?php if (form_error('title')) echo 'has-error'; ?>">
                            <label class="col-md-3 control-label"><?php echo translate('Group') . " " . translate('name'); ?>
                                <span class="required">*</span></label>
                            <div class="col-md-8">
                                <input type="text" class="form-control" name="group_name" value="" required />
                            </div>
                        </div>

                        <div id="upload_area">
                            <div class="form-group <?php if (form_error('photo')) echo 'has-error'; ?>">
                                <label class="col-md-3 control-label"><?php echo translate('select CSV'); ?> <span
                                        class="required">*</span></label>
                                <div class="col-md-8">
                                    <input type="file" name="file" class="dropify" data-height="150"
                                        data-default-file="" id="csv_file" />
                                    <span class="error"><?php echo form_error('photo'); ?></span>
                                </div>
                            </div>


                            <footer class="panel-footer mt-lg">
                                <div class="row">
                                    <div class="col-md-2 col-md-offset-3">

                                        <button type="submit" class="btn btn-default btn-block" name="upload_file"
                                            id="upload_file" value="Upload">
                                            <i class="fas fa-plus-circle"></i> <?php echo translate('upload'); ?>
                                        </button>
                                    </div>
                                </div>
                            </footer>
                        </div>
                        <div class="table-responsive" id="process_area"></div>
                    </form>
                </div>
            <?php } ?>
        </div>
    </div>
</section>
<style>
    table#dt_authors th,
    table#dt_authors td {
        text-align: center !important;
        vertical-align: middle !important;
    }
</style>


<script>
    $(document).ready(function() {

        $('#upload_form').on('submit', function(event) {

            event.preventDefault();
            $.ajax({
                url: base_url + 'client/csv_upload_preview',
                method: "POST",
                data: new FormData(this),
                dataType: 'json',
                contentType: false,
                cache: false,
                processData: false,
                success: function(data) {
                    if (data.error !== '') {
                        $('#message').html('<div class="alert alert-danger">' + data.error + '</div>');
                    } else {
                        $('#process_area').html(data.output);
                        $('#upload_area').css('display', 'none');
                    }
                }
            });

        });

        let total_selection = 0;


        let name = 0;
        let birthday = 0;
        let mobile_no = 0
        let email = 0;
        let username = 0;
        let password = 0;
        let nas_id = 0;
        let zone_id = 0;
        let connection_type = 0;
        let package_id = 0;
        let client_type = 0;
        let server_username = 0;
        let server_password = 0;
        let expire_date = 0;
        let remaining_day = 0;

        const column_data = [];

        $(document).on('change', '.set_column_data', function() {

            const column_name = $(this).val();

            const column_number = $(this).data('column_number');

            if (column_name in column_data) {
                alert('You have already define ' + column_name + ' column');

                $(this).val('');

                return false;
            }

            if (column_name !== '') {
                column_data[column_name] = column_number;
            } else {
                const entries = Object.entries(column_data);

                for (const [key, value] of entries) {
                    if (value === column_number) {
                        delete column_data[key];
                    }
                }
            }

            total_selection = Object.keys(column_data).length;

            if (total_selection >= 2) {
                $('#import').attr('disabled', false);

                name = column_data.name;
                birthday = column_data.birthday;
                mobile_no = column_data.mobile_no;
                email = column_data.email;
                username = column_data.username;
                password = column_data.password;
                nas_id = column_data.nas_id;
                zone_id = column_data.zone_id;
                connection_type = column_data.connection_type;
                package_id = column_data.package_id;
                client_type = column_data.client_type;
                server_username = column_data.server_username;
                server_password = column_data.server_password;
                expire_date = column_data.expire_date;
                remaining_day = column_data.remaining_day;


            } else {
                $('#import').attr('disabled', 'disabled');
            }

        });

        $(document).on('click', '#import', function(event) {

            event.preventDefault();
            const uploadFormErrorsDiv = $('#upload_form_errors');
            $.ajax({
                url: base_url + 'client/csv_insert_data',
                method: "POST",
                data: {
                    name: name,
                    birthday: birthday,
                    mobile_no: mobile_no,
                    email: email,
                    username: username,
                    password: password,
                    nas_id: nas_id,
                    zone_id: zone_id,
                    connection_type: connection_type,
                    package_id: package_id,
                    client_type: client_type,
                    server_username: server_username,
                    server_password: server_password,
                    expire_date: expire_date,
                    remaining_day: remaining_day,

                    group_name: $('input[name="group_name"]').val()
                },
                beforeSend: function() {
                    $('#import').attr('disabled', true);
                    $('#import').text('Importing...');
                    uploadFormErrorsDiv.show(false);
                },
                success: function(data) {
                    data = JSON.parse(data);
                    // console.log(data);
                    if (data.status == 'success') {
                        window.location.href = base_url + 'client/view';
                    }

                    if (data.status == 'error') {

                        uploadFormErrorsDiv.html("");

                        let uploadFormErrors = '';

                        // Show a notification error message: ${data.error}
                        uploadFormErrors += `<p>${data.error}</p>`

                        // Display a list in the HTML body for ${data.errors}
                        if (Array.isArray(data.errors) && data.errors.length > 0) {
                            uploadFormErrors += '<ul>';
                            data.errors.forEach((error) => {
                                uploadFormErrors += `<li>${error}</li>`;
                            });
                            uploadFormErrors += '</ul>';
                        }

                        uploadFormErrorsDiv.html(uploadFormErrors);
                        uploadFormErrorsDiv.show();
                    }
                },
            })

        });

    });
</script>

<!-- add payment / deduce payment -->
<script>
    // get rateProfile details
    function addClientPayment(id) {
        $.ajax({
            url: base_url + 'client/add_payment_ui',
            type: 'POST',
            data: {
                'id': id
            },
            dataType: "html",
            success: function(html) {
                $('#quick_add_payment').html(html);
                mfp_modal('#addPaymentModel');
            }
        });
    }

    // deduce payment on user list
    function deduceClientPayment(id) {
        $.ajax({
            url: base_url + 'client/deduce_payment_ui',
            type: 'POST',
            data: {
                'id': id
            },
            dataType: 'html',
            success: function(data) {
                $('#quick_deduce_payment').html(data);
                mfp_modal('#deducePaymentModel');
            }
        });
    }
</script>
<script type="text/javascript">
    function make_closed(id) {
        swal({
            title: "<?php echo translate('are_you_sure'); ?>",
            text: "<?php echo translate('You Want to Disable This Client'); ?> ?",
            type: "warning",
            showCancelButton: true,
            confirmButtonClass: "btn btn-default swal2-btn-default",
            cancelButtonClass: "btn btn-default swal2-btn-default",
            confirmButtonText: "<?php echo translate('yes_continue'); ?>",
            cancelButtonText: "<?php echo translate('cancel'); ?>",
            buttonsStyling: false
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: "<?php echo base_url('client/disable_client/'); ?>" + id,
                    success: function(data) {
                        swal({
                            title: "<?php echo translate('done'); ?>",
                            text: "<?php echo translate('the_User_has_been_disabled'); ?>",
                            buttonsStyling: false,
                            showCloseButton: true,
                            focusConfirm: false,
                            confirmButtonClass: "btn btn-default swal2-btn-default",
                            type: "success"
                        }).then((result) => {
                            if (result.value) {
                                window.location.reload(true);
                            }
                        });
                    }
                });
            }
        });
    }
</script>
<script type="text/javascript">
    function syncClient(id) {
        swal({
            title: "<?php echo translate('are_you_sure'); ?>",
            text: "<?php echo translate('You want to sync this client'); ?>?",
            type: "warning",
            showCancelButton: true,
            confirmButtonClass: "btn btn-default swal2-btn-default",
            cancelButtonClass: "btn btn-default swal2-btn-default",
            confirmButtonText: "<?php echo translate('yes_continue'); ?>",
            cancelButtonText: "<?php echo translate('cancel'); ?>",
            buttonsStyling: false
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: "<?php echo base_url('client/sync_router_client/'); ?>" + id,
                    type: 'GET',
                    dataType: 'json',
                    success: function(response) {
                        if (response.status === 'success') {
                            swal({
                                title: "<?php echo translate('done'); ?>",
                                text: "<?php echo translate('the_client_has_been_synced'); ?>",
                                buttonsStyling: false,
                                showCloseButton: true,
                                focusConfirm: false,
                                confirmButtonClass: "btn btn-default swal2-btn-default",
                                type: "success"
                            }).then((result) => {
                                if (result.value) {
                                    location.reload();

                                }
                            });
                        } else {
                            swal({
                                title: "<?php echo translate('error'); ?>",
                                text: response.message ?? "<?php echo translate('something_went_wrong'); ?>",
                                buttonsStyling: false,
                                showCloseButton: true,
                                focusConfirm: false,
                                confirmButtonClass: "btn btn-default swal2-btn-default",
                                type: "error"
                            });
                        }
                    },
                    error: function() {
                        swal({
                            title: "<?php echo translate('error'); ?>",
                            text: "<?php echo translate('something_went_wrong'); ?>",
                            buttonsStyling: false,
                            showCloseButton: true,
                            focusConfirm: false,
                            confirmButtonClass: "btn btn-default swal2-btn-default",
                            type: "error"
                        });
                    }
                });
            }
        });
    }
</script>


<script type="text/javascript">
    function temporaryActivateClient(id) {
        swal({
            title: "<?php echo translate('are_you_sure'); ?>",
            text: "<?php echo translate('You Want to Temporarily Activate This Client'); ?> ?",
            type: "warning",
            showCancelButton: true,
            confirmButtonClass: "btn btn-default swal2-btn-default",
            cancelButtonClass: "btn btn-default swal2-btn-default",
            confirmButtonText: "<?php echo translate('yes_continue'); ?>",
            cancelButtonText: "<?php echo translate('cancel'); ?>",
            buttonsStyling: false
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: "<?php echo base_url('client/temporary_active_client/'); ?>" + id,
                    type: 'GET',
                    dataType: 'json', // Expect a JSON response
                    success: function(response) {
                        if (response.status === 'success') {
                            swal({
                                title: "<?php echo translate('done'); ?>",
                                text: "<?php echo translate('the_Client_has_been_temporarily_activated'); ?>",
                                buttonsStyling: false,
                                showCloseButton: true,
                                focusConfirm: false,
                                confirmButtonClass: "btn btn-default swal2-btn-default",
                                type: "success"
                            }).then((result) => {
                                if (result.value) {
                                    // Optionally update the status dynamically in the table (without page reload)
                                    var row = $('tr[data-id="' + id + '"]'); // Find the row with the matching ID
                                    row.find('.label').text('<?php echo translate('Active'); ?>')
                                        .removeClass('label-warning-custom')
                                        .addClass('label-success-custom');

                                    // Optionally, update the button color and disable it
                                    row.find('.btn').css('background-color', 'green').prop('disabled', true);

                                    // Reload the page to reflect all changes properly
                                    location.reload(); // Forces page reload after the success
                                }
                            });
                        } else {
                            swal({
                                title: "<?php echo translate('error'); ?>",
                                text: "<?php echo translate('something_went_wrong'); ?>",
                                buttonsStyling: false,
                                showCloseButton: true,
                                focusConfirm: false,
                                confirmButtonClass: "btn btn-default swal2-btn-default",
                                type: "error"
                            });
                        }
                    },
                    error: function() {
                        swal({
                            title: "<?php echo translate('error'); ?>",
                            text: "<?php echo translate('something_went_wrong'); ?>",
                            buttonsStyling: false,
                            showCloseButton: true,
                            focusConfirm: false,
                            confirmButtonClass: "btn btn-default swal2-btn-default",
                            type: "error"
                        });
                    }
                });
            }
        });
    }
</script>

<script type="text/javascript">
    function make_active(id) {
        swal({
            title: "<?php echo translate('are_you_sure'); ?>",
            text: "<?php echo translate('You Want to Active This Client'); ?> ?",
            type: "warning",
            showCancelButton: true,
            confirmButtonClass: "btn btn-default swal2-btn-default",
            cancelButtonClass: "btn btn-default swal2-btn-default",
            confirmButtonText: "<?php echo translate('yes_continue'); ?>",
            cancelButtonText: "<?php echo translate('cancel'); ?>",
            buttonsStyling: false
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: "<?php echo base_url('client/active_client/'); ?>" + id,
                    success: function(data) {
                        swal({
                            title: "<?php echo translate('done'); ?>",
                            text: "<?php echo translate('the_user_has_been_activated'); ?>",
                            buttonsStyling: false,
                            showCloseButton: true,
                            focusConfirm: false,
                            confirmButtonClass: "btn btn-default swal2-btn-default",
                            type: "success"
                        }).then((result) => {
                            if (result.value) {
                                window.location.reload(true);
                            }
                        });
                    }
                });
            }
        });
    }
</script>

<script type="text/javascript">
    function make_hold(id) {
        swal({
            title: "<?php echo translate('are_you_sure'); ?>",
            text: "<?php echo translate('You Want to Hold This Client'); ?> ?",
            type: "warning",
            showCancelButton: true,
            confirmButtonClass: "btn btn-default swal2-btn-default",
            cancelButtonClass: "btn btn-default swal2-btn-default",
            confirmButtonText: "<?php echo translate('yes_continue'); ?>",
            cancelButtonText: "<?php echo translate('cancel'); ?>",
            buttonsStyling: false
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: "<?php echo base_url('client/hold_client/'); ?>" + id,
                    success: function(data) {
                        swal({
                            title: "<?php echo translate('done'); ?>",
                            text: "<?php echo translate('the_user_has_been_Hold'); ?>",
                            buttonsStyling: false,
                            showCloseButton: true,
                            focusConfirm: false,
                            confirmButtonClass: "btn btn-default swal2-btn-default",
                            type: "success"
                        }).then((result) => {
                            if (result.value) {
                                window.location.reload(true);
                            }
                        });
                    }
                });
            }
        });
    }
</script>

<script>
    $("#btn-filter").click(function() {
        erTable_dt_authors.ajax.reload();
    });
</script>
<script>
    $(document).ready(function() {
        $('#reseller_subreseller_id').change(function() {
            let reseller_subreseller_id = $(this).val();

            // change reseller_subreseller_id to integer
            reseller_subreseller_id = parseInt(reseller_subreseller_id);

            // if reseller_subreseller_id is integer then request
            if (isNaN(reseller_subreseller_id)) {
                $('#package_list_id').html('<option value="">No Package Found</option>');
                $('#zone_list_id').html('<option value="">No Zone Found</option>');
                return;
            }

            $.ajax({
                url: `<?= base_url('package/ajax_packages_by_reseller_subreseller_id') ?>/${reseller_subreseller_id}`,
                method: 'GET',
                dataType: 'json',
                beforeSend: function() {
                    $('#package_list_id').html('<option value="">Loading...</option>');
                    $('#zone_list_id').html('<option value="">Loading...</option>');
                    // disable the full form
                    $('#client_filter_field').find('input, select, button').attr('disabled', true);
                },
                success: function(data) {
                    ////Get packages
                    let options_packages = '<option value="">Select A Package</option>';
                    const packages = data.packages;
                    console.log(packages);
                    for (let i = 0; i < packages.length; i++) {
                        options_packages += `<option value="${packages[i].id}">${packages[i].name}</option>`;
                    }
                    $('#package_list_id').html(options_packages);

                    /// Get Zones
                    let options_zones = '<option value="">Select A Zone</option>';
                    const zones = data.zones;
                    console.log(zones);
                    for (let i = 0; i < zones.length; i++) {
                        options_zones += `<option value="${zones[i].id}">${zones[i].name}</option>`;
                    }
                    $('#zone_list_id').html(options_zones);

                },
                complete: function() {
                    // enable the full form
                    $('#client_filter_field').find('input, select, button').attr('disabled', false);
                },
                error: function(jqXHR) {
                    const errorData = JSON.parse(jqXHR.responseText);
                    // Show sweetalert
                    Swal.fire({
                        title: 'Oops...',
                        text: errorData.message,
                    });

                    // remove the options
                    $('#package_list_id').html('<option value="">No Package Found</option>');
                }
            });
        });
    });
</script>

<!-- Jquery Datatables JS -->
<script src="<?php echo base_url('assets/vendor/datatables/media/js/jquery.dataTables.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/vendor/datatables/media/js/dataTables.bootstrap.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/vendor/datatables/extras/TableTools/Buttons-1.4.2/js/dataTables.buttons.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/vendor/datatables/extras/TableTools/Buttons-1.4.2/js/buttons.bootstrap.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/vendor/datatables/extras/TableTools/Buttons-1.4.2/js/buttons.html5.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/vendor/datatables/extras/TableTools/Buttons-1.4.2/js/buttons.print.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/vendor/datatables/extras/TableTools/Buttons-1.4.2/js/buttons.colVis.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/vendor/datatables/extras/TableTools/JSZip-2.5.0/jszip.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/vendor/datatables/extras/TableTools/pdfmake-0.1.32/pdfmake.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/vendor/datatables/extras/TableTools/pdfmake-0.1.32/vfs_fonts.js'); ?>"></script>
<?php $this->datatables->jquery('dt_authors'); ?>