<section class="panel">
    <div class="row">
        <div class="col-md-12">
            <?= form_open('client/set_package'); ?>

            <input type="hidden" name="user_id" value="<?= $user_id; ?>" id="user_id">
            <input type="hidden" name="profile_id" value="<?= $profile_id; ?>" id="profile_id">

            <div class="panel-body">
                <!-- Current Package Row -->
                <div class="row mb-sm" id="current_package_row" style="display: block;">
                    <div class="col-md-12 mb-sm">
                        <div class="form-group">
                            <label class="control-label"><?= translate('current_package'); ?></label>
                            <?php if (!empty($current_package_id) && !empty($current_package)) : ?>
                                <input type="text" class="form-control" value="<?= htmlspecialchars($current_package); ?>" readonly>
                                <input type="hidden" class="form-control" value="<?= htmlspecialchars($current_package_id); ?>" readonly>
                            <?php else : ?>
                                <input type="text" class="form-control" value="No package assigned" readonly>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- Current Package Sale Price -->
                <div class="row mb-sm" id="current_package_sale_price_row">
                    <div class="col-md-12 mb-sm">
                        <div class="form-group">
                            <label class="control-label"><?= translate('current_package_sale_price'); ?></label>
                            <?php if (!empty($current_package_sale_price)) : ?>
                                <input type="text" class="form-control" value="<?= htmlspecialchars($current_package_sale_price); ?>" readonly id="current_package_sale_price">
                            <?php else : ?>
                                <input type="text" class="form-control" value="Sale price not available" readonly id="current_package_sale_price">
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- Package Selection Dropdown -->
                <div class="row mb-sm">
                    <div class="col-md-12 mb-sm">
                        <div class="form-group">
                            <label class="control-label"><?= translate('packages'); ?> <span class="required">*</span></label>
                            <select class="form-control" name="package_id" id="package_id" required onchange="showSalePrice()">
                                <option value="" data-sale-price=""><?= translate('select_package'); ?></option>
                                <?php foreach ($packages as $package): ?>
                                    <option value="<?= $package->id; ?>"
                                        data-sale-price="<?= $package->sale_price; ?>"
                                        <?= ($package->id == $package_id) ? 'selected' : ''; ?>
                                        data-original-title="<?= translate('current_package') . ': ' . $package->name . ' (ID: ' . $package->id . ')'; ?>">
                                        <?= $package->name; ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                </div>

                <!-- Row to display sale price -->
                <div class="row mb-sm" id="sale_price_row" style="display: none;">
                    <div class="col-md-12 mb-sm">
                        <div class="form-group">
                            <label class="control-label"><?= translate('sale_price'); ?></label>
                            <input type="text" class="form-control" id="sale_price" readonly>
                        </div>
                    </div>
                </div>

                <!-- Debit Section -->
                <div class="row mb-sm" id="debit_row" style="display: none;">
                    <div class="col-md-12 mb-sm">
                        <div class="form-group">
                            <label class="control-label">Debit</label>
                            <input type="text" class="form-control" id="debit" readonly>
                        </div>
                    </div>
                </div>

                <!-- Credit Section -->
                <div class="row mb-sm" id="credit_row" style="display: none;">
                    <div class="col-md-12 mb-sm">
                        <div class="form-group">
                            <label class="control-label">Credit</label>
                            <input type="text" class="form-control" id="credit" readonly>
                        </div>
                    </div>
                </div>

                <!-- Submit Button -->
                <div class="row mb-sm">
                    <div class="col-md-12 mb-sm">
                        <button type="submit" name="submit" class="btn btn-primary">Update</button>
                    </div>
                </div>
            </div>

            <?= form_close(); ?>
        </div>
    </div>
</section>
<style>
    /* Debit Data Style */
    #debit {
        background-color: #f8d7da;  /* Red background for Debit */
        color: #721c24;  /* Dark red text for Debit */
        padding: 5px 10px;
        border-radius: 5px;
        font-size: 16px;
        font-weight: bold;
    }

    /* Credit Data Style */
    #credit {
        background-color: #d4edda;  /* Green background for Credit */
        color: #155724;  /* Dark green text for Credit */
        padding: 5px 10px;
        border-radius: 5px;
        font-size: 16px;
        font-weight: bold;
    }
</style>

<script>
    $(document).ready(function() {
        $('[data-toggle="tooltip"]').tooltip();
    });

    function showSalePrice() {
        const packageSelect = document.getElementById('package_id');
        const selectedOption = packageSelect.options[packageSelect.selectedIndex];
        const salePrice = selectedOption.getAttribute('data-sale-price');
        const currentPackageSalePrice = document.getElementById('current_package_sale_price').value;

        const salePriceRow = document.getElementById('sale_price_row');
        const salePriceInput = document.getElementById('sale_price');
        const debitRow = document.getElementById('debit_row');
        const creditRow = document.getElementById('credit_row');
        const debitInput = document.getElementById('debit');
        const creditInput = document.getElementById('credit');

        // Show sale price row
        if (salePrice) {
            salePriceInput.value = salePrice;
            salePriceRow.style.display = 'block';
        } else {
            salePriceInput.value = '';
            salePriceRow.style.display = 'none';
        }

        // Debit or Credit Calculation
        if (currentPackageSalePrice && salePrice) {
            const currentPrice = parseFloat(currentPackageSalePrice);
            const newPrice = parseFloat(salePrice);
            const difference = newPrice - currentPrice;

            // Hide both Debit and Credit initially
            debitRow.style.display = 'none';
            creditRow.style.display = 'none';

            // Show Debit or Credit based on the price difference
            if (difference < 0) {
                debitRow.style.display = 'block';
                debitInput.value = '-' + Math.abs(difference);  // Show Debit if negative
            } else if (difference > 0) {
                creditRow.style.display = 'block';
                creditInput.value = ' +' + difference;  // Show Credit if positive
            } else {
                // No change, hide both rows
                debitRow.style.display = 'none';
                creditRow.style.display = 'none';
            }
        }

        // Update the current package tooltip and input value
        const package_nameInput = document.getElementById('current_package');
        const packageName = selectedOption.text; // Get only the package name
        const tooltipContent = selectedOption.getAttribute('data-original-title');

        package_nameInput.value = packageName; // Set only the name
        $(package_nameInput).attr('data-original-title', tooltipContent);
        $(package_nameInput).tooltip('hide').tooltip('show');
    }
</script>
