<div class="row">

  <!-- Connectivity Information -->
  <div class="col-md-12 mb-lg">
    <div class="panel panel-default modern-panel">
      <div class="panel-heading" style="color: #ff04f0;">
        <h4>Connectivity Information</h4>
        <span class="status-badge" style="background-color: <?= $status === 'online' ? '#9deb9d' : '#ff6b6b'; ?>;">
          <?= ucfirst($status); ?>
        </span>
      </div>

      <div class="panel-body">
        <div class="row">
          <!-- Uptime -->
          <div class="col-md-3">
            <div class="info-item-gradient">
              <div class="info-icon">
                <i class="fas fa-clock"></i>
              </div>
              <div class="info-data">
                <h5>Uptime:</h5>
                <span><?= isset($user_api_data['uptime']) ? html_escape($user_api_data['uptime']) : 'N/A'; ?></span>
              </div>
            </div>
          </div>

          <!-- PPPOE ID -->
          <div class="col-md-3">
            <div class="info-item-gradient">
              <div class="info-icon">
                <i class="fas fa-id-badge"></i>
              </div>
              <div class="info-data">
                <h5>PPPOE ID:</h5>
                <span><?= isset($user_api_data['name']) ? html_escape($user_api_data['name']) : 'N/A'; ?></span>
              </div>
            </div>
          </div>
          <!-- Total Downloaded -->
          <div class="col-md-3">
            <div class="info-item-gradient">
              <div class="info-icon">
                <i class="fas fa-download"></i>
              </div>
              <div class="info-data">
                <h5>Total Downloaded:</h5>
                <span id="totalDownloaded"><?= isset($total_downloaded) ? html_escape($total_downloaded) : '0 MB'; ?></span>
              </div>
            </div>
          </div>
          <!-- Upload Speed -->
          <div class="col-md-3">
            <div class="info-item-gradient">
              <div class="info-icon">
                <i class="fas fa-arrow-up" style="color: rgb(248, 108, 107);"></i>
              </div>
              <div class="info-data">
                <h5>Upload Speed:</h5>
                <span id="uploadSpeed">0 bps</span>
              </div>
            </div>
          </div>
          <!-- Last Logout -->
        </div>
      </div>
      <div class="panel-body">
        <div class="row">
          <!-- Device Vendor -->
          <div class="col-md-3">
            <div class="info-item-gradient">
              <div class="info-icon">
                <i class="fas fa-microchip"></i>
              </div>
              <div class="info-data">
                <h5>Device:</h5>
                <span>
                  <?php
                  $mac_address = isset($user_api_data['caller-id']) ? $user_api_data['caller-id'] : null;
                  if ($mac_address) {
                    $url = "https://api.macvendors.com/" . urlencode($mac_address);
                    $ch = curl_init();
                    curl_setopt($ch, CURLOPT_URL, $url);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                    $response = curl_exec($ch);
                    curl_close($ch);
                    echo $response ? html_escape($response) : 'Vendor Not Found';
                  } else {
                    echo 'N/A';
                  }
                  ?>
                </span>
              </div>
            </div>
          </div>
          <!-- MAC Address -->
          <div class="col-md-3">
            <div class="info-item-gradient">
              <div class="info-icon">
                <i class="fas fa-network-wired"></i>
              </div>
              <div class="info-data">
                <h5>MAC:</h5>
                <span><?= isset($user_api_data['caller-id']) ? html_escape($user_api_data['caller-id']) : 'N/A'; ?></span>
              </div>
            </div>
          </div>
          <!-- Total Uploaded -->
          <div class="col-md-3">
            <div class="info-item-gradient">
              <div class="info-icon">
                <i class="fas fa-upload"></i>
              </div>
              <div class="info-data">
                <h5>Total Uploaded:</h5>
                <span id="totalUploaded"><?= isset($total_uploaded) ? html_escape($total_uploaded) : '0 MB'; ?></span>
              </div>
            </div>
          </div>

          <!-- Download Speed -->
          <div class="col-md-3">
            <div class="info-item-gradient">
              <div class="info-icon">
                <i class="fas fa-arrow-down" style="color: rgb(32, 168, 216);"></i>
              </div>
              <div class="info-data">
                <h5>Download Speed:</h5>
                <span id="downloadSpeed">0 bps</span>
              </div>
            </div>
          </div>
        </div>
      </div>

      <!-- Device Vendor -->
      <!-- Last Logout -->
      <div class="panel-body">
        <div class="row">
          <div class="col-md-3">
            <div class="info-item-gradient">
              <div class="info-icon">
                <i class="fas fa-sign-out-alt"></i>
              </div>
              <div class="info-data">
                <h5>Last Logout:</h5>

                <span><?= isset($user_data['last_logged_out']) ? html_escape($user_data['last_logged_out']) : 'N/A'; ?></span>

              </div>
            </div>
          </div>
          <div class="col-md-4">
            <div class="info-item-gradient p-3 text-center shadow-sm rounded">
              <div class="info-icon">
                <i class="fas fa-wifi fa-2x text-primary"></i>
              </div>

              <div class="info-data">
                <h5>IP Address</h5>
                <span><?= isset($user_api_data['address']) ? html_escape($user_api_data['address']) : 'N/A'; ?></span>
              </div>

              <div class="mt-3">
                <button id="loadPingResults" class="btn btn-primary px-4 py-2 w-100">
                  Ping
                </button>
                <div id="pingLoadingSpinner" class="loading-spinner mt-2" style="display: none;"></div>
              </div>
            </div>

            <!-- Ping Result Dropdown (Appears Below Main Div) -->
            <div id="pingResultContainer" class="result-box collapse mt-3">
              <h6 class="text-primary fw-bold">Ping Results</h6>
              <div id="pingResults" class="result-content"></div>
              <button id="reloadPing" class="btn btn-outline-secondary mt-3 w-100">
                <i class="fas fa-redo"></i> Check Again
              </button>
            </div>
          </div>
          <!-- OLT DBM Section -->
          <div class="col-md-5">
            <div class="info-item-gradient p-3 text-center shadow-sm rounded">
              <div class="info-icon">
                <i class="fas fa-signal fa-2x text-primary"></i>
              </div>

              <div class="info-data">
                <h5>OLT DBM</h5>
              </div>

              <div class="mt-3">
                <button id="checkOltDbm"
                  data-userid="<?= htmlspecialchars($userdata['id']) ?>"
                  class="btn btn-primary px-4 py-2 w-100">
                  Check DBM
                </button>
                <div id="oltLoadingSpinner" class="loading-spinner mt-2" style="display: none;"></div>
              </div>
            </div>

            <!-- DBM Result Dropdown (Appears Below Main Div) -->
            <div id="oltDbmContainer" class="result-box collapse mt-3">
              <h6 class="text-primary fw-bold">DBM Output</h6>
              <div id="oltDbmValue" class="result-content"></div>
              <button id="reloadCheckOltDbm" class="btn btn-outline-secondary mt-3 w-100">
                <i class="fas fa-redo"></i> Check Again
              </button>
            </div>
          </div>
        </div>
      </div>
      <style>
        .result-box {
          border: 2px solid #ddd;
          text-align: center;
          width: 100%;
          background-color: #f8f9fa;
          display: none;
          border-radius: 12px;
          /* Same as main divs */
          box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }

        /* Result Content */
        .result-content {
          font-size: 14px;
          color: #333;
          background-color: #f8f9fa;
          width: 100%;
          max-height: 200px;
          overflow-y: auto;
          border: 1px solid #ddd;
        }

        /* Circular Loading Spinner */
        .loading-spinner {
          width: 24px;
          height: 24px;
          border: 3px solid #f3f3f3;
          border-top: 3px solid #3498db;
          border-radius: 50%;
          animation: spin 0.8s linear infinite;
        }

        /* Spinner Animation */
        @keyframes spin {
          0% {
            transform: rotate(0deg);
          }

          100% {
            transform: rotate(360deg);
          }
        }
      </style>

      <script>
        $(document).ready(function() {
          // Check DBM
          $('#checkOltDbm').on('click', function() {
            $('#checkOltDbm').hide();
            $('#oltLoadingSpinner').show();
            $('#oltDbmContainer').slideUp();

            var userid = $(this).data('userid');
            $.ajax({
              url: '<?= base_url('client/onudbmcheck/') ?>' + userid,
              method: 'GET',
              dataType: 'json',
              success: function(response) {
                $('#oltLoadingSpinner').hide();
                $('#oltDbmContainer').slideDown();

                if (response.status === "success") {
                  $('#oltDbmValue').html('<div class="result-content">' + response.dbm.replace(/\r\n|\n|\r/g, "<br>") + '</div>');
                } else {
                  $('#oltDbmValue').html('<div class="alert alert-danger">Error fetching DBM data.</div>');
                }
              },
              error: function() {
                $('#oltLoadingSpinner').hide();
                $('#oltDbmContainer').slideDown();
                $('#oltDbmValue').html('<div class="alert alert-danger">Error fetching DBM data.</div>');
              }
            });
          });

          // Reload DBM
          $('#reloadCheckOltDbm').on('click', function() {
            $('#oltDbmContainer').slideUp();
            $('#checkOltDbm').show();
          });

          // Ping Check
          $('#loadPingResults').on('click', function() {
            $('#loadPingResults').hide();
            $('#pingLoadingSpinner').show();
            $('#pingResultContainer').slideUp();

            var clientId = <?= json_encode($user_data['id']); ?>;
            $.ajax({
              url: '<?= site_url('client/fetch_ping/') ?>' + clientId,
              method: 'GET',
              dataType: 'json',
              success: function(response) {
                $('#pingLoadingSpinner').hide();
                $('#pingResultContainer').slideDown();

                if (response.ping_result && response.ping_result.length > 0) {
                  var resultHtml = '<ul>';
                  response.ping_result.forEach(function(ping) {
                    resultHtml += '<li>' + ping + '</li>';
                  });
                  resultHtml += '</ul>';
                  $('#pingResults').html(resultHtml);
                } else {
                  $('#pingResults').html('<div class="alert alert-warning">No results available</div>');
                }
              },
              error: function() {
                $('#pingLoadingSpinner').hide();
                $('#pingResultContainer').slideDown();
                $('#pingResults').html('<div class="alert alert-danger">Error fetching Ping results</div>');
              }
            });
          });

          // Reload Ping
          $('#reloadPing').on('click', function() {
            $('#pingResultContainer').slideUp();
            $('#loadPingResults').show();
          });
        });
      </script>

  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">

  <style>
    .panel-body{
      padding:5px;
      margin: 10px;
    }
    .info-item-gradient {
      display: flex;
      align-items: center;
      padding: 10px;
      border-radius: 8px;
      background: linear-gradient(135deg, #e0e4ff, #f7f9fc);
      box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
      transition: transform 0.3s ease;
    }

    .info-item-gradient:hover {
      transform: scale(1.05);
    }

    .info-icon {
      flex: 0 0 40px;
      display: flex;
      align-items: center;
      justify-content: center;
      color: #ff04f0;
      background-color: #ffe4f7;
      border-radius: 50%;
      padding: 10px;
      margin-right: 15px;
    }

    .info-icon i {
      font-size: 1.5em;
    }

    .info-data {
      display: flex;
      align-items: center;
      font-size: 1em;
      color: #ff04ff;
    }

    .info-data h5 {
      margin: 0;
      margin-right: 5px;
      color: #6b6b6b;
    }

    .info-data span {
      font-weight: normal;
    }
  </style>

    </div>
  </div>

  <div class="col-md-12 mb-lg">
    <div class="panel panel-default modern-panel">
      <div class="panel-heading" style="color: #ff04f0;">
        <h4>Live Traffic Monitoring</h4>
      </div>
      <div class="panel-body">
        <div id="trafficMonitor" style="min-width: 310px; height: 400px; margin: 0 auto;"></div>
      </div>
    </div>
  </div>

  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script src="<?= base_url('assets/js/highcharts/highcharts.js'); ?>"></script>
  <script src="<?= base_url('assets/js/highcharts/themes/hc.dark.js'); ?>"></script>

  <script type="text/javascript">
    var chart;
    var userid = <?= json_encode($user_data['id']); ?>;
    var totalDownloaded = 0;
    var totalUploaded = 0;

    function requestDatta() {
      $.ajax({
        url: '<?= base_url('client/livetraffic/'); ?>' + userid,
        datatype: "json",
        success: function(data) {
          console.log("Data received:", data); 
          var midata = JSON.parse(data);

          if (midata.length > 0) {
            var TX = parseInt(midata[0].data); 
            var RX = parseInt(midata[1].data); 

            totalDownloaded += TX;
            totalUploaded += RX;

            // Display download and upload speeds
            $('#downloadSpeed').text(' ' + formatSpeed(TX));
            $('#uploadSpeed').text(' ' + formatSpeed(RX));

            // Display total downloaded and uploaded data
            $('#totalDownloaded').text('' + formatData(totalDownloaded));
            $('#totalUploaded').text('' + formatData(totalUploaded));

            var x = (new Date()).getTime();
            var shift = chart.series[0].data.length > 19;
            chart.series[0].addPoint([x, TX], true, shift);
            chart.series[1].addPoint([x, RX], true, shift);
          }
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
          console.error("Status: " + textStatus + " request: " + XMLHttpRequest);
          console.error("Error: " + errorThrown);
        }
      });
    }

    function formatSpeed(bytes) {
      var sizes = ['bps', 'kbps', 'Mbps', 'Gbps', 'Tbps'];
      if (bytes === 0) return '0 bps';
      var i = parseInt(Math.floor(Math.log(bytes) / Math.log(1024)));
      return parseFloat((bytes / Math.pow(1024, i)).toFixed(2)) + ' ' + sizes[i];
    }

    function formatData(bytes) {
      var sizes = ['B', 'KB', 'MB', 'GB', 'TB'];
      if (bytes === 0) return '0 B';
      var i = parseInt(Math.floor(Math.log(bytes) / Math.log(1024)));
      return parseFloat((bytes / Math.pow(1024, i)).toFixed(2)) + ' ' + sizes[i];
    }

    $(document).ready(function() {
      $('#loadPingResults').on('click', function() {
        var clientId = <?= json_encode($user_data['id']) ?>;
        $('#pingResults').show().html('<p>Loading ping results...</p>');

        $.ajax({
          url: '<?= site_url('client/fetch_ping/') ?>' + clientId,
          method: 'GET',
          dataType: 'json',
          success: function(response) {
            $('#pingResults').empty();

            if (response.ping_result && response.ping_result.length > 0) {
              var resultHtml = '<h4>Ping Results:</h4><ul>';
              response.ping_result.forEach(function(ping) {
                resultHtml += '<li>' + ping + '</li>';
              });
              resultHtml += '</ul>';
              $('#pingResults').html(resultHtml);
            } else {
              $('#pingResults').html('<p>No ping results available.</p>');
            }
          },
          error: function() {
            $('#pingResults').html('<p>Error loading ping results. Please try again.</p>');
          }
        });
      });

      

      Highcharts.setOptions({
        global: {
          useUTC: false
        }
      });

      chart = new Highcharts.Chart({
        chart: {
          renderTo: 'trafficMonitor',
          type: 'areaspline',
          events: {
            load: function() {
              setInterval(requestDatta, 8000);
            }
          }
        },
        title: {
          text: 'Live Traffic'
        },
        xAxis: {
          type: 'datetime',
          tickPixelInterval: 150,
          maxZoom: 20 * 1000,
        },
        yAxis: {
          title: {
            text: null
          },
          labels: {
            formatter: function() {
              return formatSpeed(this.value);
            }
          },
        },
        series: [{
          name: 'Download',
          data: []
        }, {
          name: 'Upload',
          data: []
        }],
        tooltip: {
          shared: true,
          formatter: function() {
            return '<b>Live Usage Traffic</b><br><b>Time:</b> ' + Highcharts.dateFormat('%H:%M:%S', this.x) + '<br>' +
              this.points.map(point => `<span style="color:${point.series.color}">●</span> <b>${point.series.name}:</b> ${formatSpeed(point.y)}`).join('<br>');
          },
        }
      });
    });
  </script>

  <style>
    .data-box {
      background-color: #f8f9fa;
      padding: 10px;
      border-radius: 5px;
      border: 1px solid #dee2e6;
      margin-top: 10px;
    }

    .status-badge {
      position: absolute;
      top: 10px;
      right: 15px;
      padding: 5px 12px;
      border-radius: 15px;
      color: black;
      font-size: 0.9em;
      font-weight: 700;
      text-transform: uppercase;
    }

    .modern-panel {
      border-radius: 10px;
      box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
    }

    .info-heading {
      flex: 1;
      font-weight: bold;
      color: #6b6b6b;
      margin: 0 auto;
      font-size: 2em;
    }

    .info-data {
      font-size: 1em;
      text-align: center;
      /* Center-aligns text within the element */
      color: #ff04ff;
      margin: 0 auto;
      /* Centers the element itself if it has a width */
      width: fit-content;
      /* Optional: Only as wide as the content */
    }

    .info-item-gradient {
      display: flex;
      align-items: center;
      justify-content: space-between;
      padding: 5px;
      border-radius: 5px;
      background: whitesmoke;
      color: #6b6b6b;
      margin-top: 5px;
    }
  </style>
</div>