<script src="https://code.jquery.com/jquery.js"></script>
<?php if (loggedin_role_id() != 4) { ?>
    <section class="panel-group" id="accordion">
        <div class="panel panel-accordion">
            <div class="panel-heading">
                <h4 class="panel-title">
                    <a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion"
                       href="#client_filter_field"><?php echo translate('Select Grounds For Filter'); ?></a>
                </h4>
            </div>

            <div id="client_filter_field"
                 class="accordion-body collapse <?php echo($this->session->flashdata('active_box') == 1 ? 'in' : ''); ?>">
                <?php echo form_open($this->uri->uri_string()); ?>
                <div class="panel-body">
                    <?php if (in_array(loggedin_role_id(), array(1, 2))) { ?>
                        <div class="col-md-4 mb-lg">
                            <div class="form-group <?= form_error('reseller_subreseller_id') ? 'has-error' : null ?>">
                                <label for="reseller_subreseller_id" class="control-label">
                                    <?= translate('Reseller_list'); ?>
                                    <span class="required"></span>
                                </label>
                                <div class="input-group">
                                    <span class="input-group-addon"><i class="fas fa-users"></i></span>
                                    <select class="form-control" data-plugin-selectTwo data-width="100%"
                                            name="reseller_subreseller_id"
                                            id="reseller_subreseller_id">
                                        <?php /** @var array<array> $nasList */ ?>
                                        <?php if (empty($reseller_subreseller_list)): ?>
                                            <option value=""><?= translate('No Resellers Found'); ?></option>
                                        <?php else: ?>
                                            <option value=""><?= translate('Select A Reseller') ?></option>
                                            <?php foreach ($reseller_subreseller_list as $reseller_subreseller): ?>
                                                <option value="<?= $reseller_subreseller->id ?>" <?= set_select('reseller_subreseller_id', $reseller_subreseller->id) ?>>
                                                    <?= html_escape($reseller_subreseller->name) ?>
                                                </option>
                                            <?php endforeach; ?>
                                        <?php endif; ?>

                                    </select>
                                    <span class="error"><?= form_error('reseller_subreseller_id'); ?></span>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                    <div class="col-md-4 mb-lg">
                        <div class="form-group <?= form_error('package_list_id') ? 'has-error' : null ?>">
                            <label for="package_list_id" class="control-label">
                                <?= translate('package_list'); ?>
                                <span class="required"></span>
                            </label>
                            <div class="input-group">
                                <span class="input-group-addon"><i class="fas fa-list-ul"></i></span>
                                <select class="form-control" data-plugin-selectTwo data-width="100%"
                                        name="package_list_id"
                                        id="package_list_id">
                                    <?php /** @var array<array> $nasList */ ?>
                                    <?php if (empty($package_list)): ?>
                                        <option value=""><?= translate('No Package Found'); ?></option>
                                    <?php else: ?>
                                        <option value=""><?= translate('Select A Package') ?></option>
                                        <?php foreach ($package_list as $package): ?>
                                            <option value="<?= $package->id ?>" <?= set_select('package_list_id', $package->id) ?>>
                                                <?= html_escape($package->name) ?>
                                            </option>
                                        <?php endforeach; ?>
                                    <?php endif; ?>

                                </select>
                                <span class="error"><?= form_error('package_list_id'); ?></span>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4 mb-lg">
                        <div class="form-group">
                            <label class="control-label"><?php echo translate('date'); ?> <span class="required"></span></label>
                            <div class="input-group">
                                <span class="input-group-addon"><i class="fas fa-calendar-check"></i></span>
                                <input type="text" class="form-control daterange" name="daterange"
                                       value="<?php echo set_value('daterange', date("Y/m/1") . ' - ' . date("Y/m/30")); ?>"/>
                            </div>
                        </div>
                    </div>
                </div>
                <footer class="panel-footer">
                    <div class="row">
                        <div class="col-md-offset-10 col-md-2">
                            <button type="submit" name="search" value="1" class="btn btn btn-default btn-block"><i
                                        class="fas fa-filter"></i> <?php echo translate('filter'); ?></button>
                        </div>
                    </div>
                </footer>
                <?php echo form_close(); ?>
            </div>
        </div>
    </section>
<?php } ?>
<section class="panel">
    <div class="tabs-custom">
        <ul class="nav nav-tabs">
            <?php if (get_permission('client', 'is_view')) { ?>
                <li class="<?php echo(!isset($validation_error) ? 'active' : ''); ?>">
                    <a href="#list" data-toggle="tab"><i
                                class="fas fa-list-ul"></i> <?php echo translate('client') . " " . translate('list'); ?>
                    </a>
                </li>
            <?php }
            if (get_permission('client', 'is_add')) { ?>
                <li class="<?php echo(isset($validation_error) ? 'active' : ''); ?>">
                    <a href="#create" data-toggle="tab"><i
                                class="far fa-edit"></i> <?php echo translate('upload') . " " . translate('information'); ?>
                    </a>
                </li>
            <?php } ?>
        </ul>

        <div class="tab-content">
            <div id="list" class="tab-pane <?php echo(!isset($validation_error) ? 'active' : ''); ?>">
                <!--div class="row">
					<div class="col-md-offset-10 col-md-2">
						<div class="form-group mb-sm">
							<select name="selectall" class="form-control" data-plugin-selectTwo data-width="100%" data-minimum-results-for-search="Infinity" onchange="fn_select_all(this.value)">
								<option value=""><?php echo translate('not_selected'); ?></option>
								<option value="1"><?php echo translate('Online'); ?></option>
								<option value="2"><?php echo translate('Offline'); ?></option>
							</select>
						</div>
					</div>
				</div-->
				<div class="row">
					<div class="col-md-12">
						<div class="table-responsive mb-sm mt-xs">
							<table class="table table-bordered table-hover table-condensed" cellspacing="0" width="100%" id="table-export">
									<thead>
									<tr>
										<th>
											<?php echo translate('id'); ?>
										</th>
										<th>
											<?php echo translate('photo'); ?>
										</th>
										<th>
											<?php echo translate('name'); ?>
										</th>

										<th>
											<?php echo translate('email'); ?>
										</th>
										<th>
											<?php echo translate('mobile_no'); ?>
										</th>

										<th>
											<?php echo translate('Admin'); ?>
										</th>
										<th>
											<?php echo translate('User Balance'); ?>
										</th>
										<th>
											<?php echo translate('Package'); ?>
										</th>
										<th>
											<?php echo translate('action'); ?>
										</th>
									</tr>
									</thead>
									<tbody>
									<?php $i = 1;
									foreach ($stafflist as $row): ?>
										<?php $i++; ?>
										<tr>
											<td>
												<?php echo html_escape($row->id); ?>
											</td>
											<td class="center">
												<img class="rounded"
													 src="<?php echo $this->app_lib->get_image_url('staff/' . $row->photo); ?>"
													 width="40" height="40"/>
											</td>
											<td>
												<?php echo html_escape($row->name); ?>
											</td>
											<td>
												<?php echo html_escape($row->email); ?>
											</td>
											<td>
												<?php echo html_escape($row->mobileno); ?>
											</td>

											<td>
												<?php echo html_escape($row->admin_name); ?>
											</td>
											<td>
												<a class="btn btn-default btn-circle icon" href="javascript:void(0);"
												   data-toggle="tooltip" data-original-title="<?php echo translate('Add Payment'); ?>"
												   onclick="addClientPayment('<?= $row->id ?>')">
													<i class="fas fa-money-check-alt" style="color: green;"></i>
												</a>
												<?= html_escape($global_config['currency'] . ' ' . $row->user_balance . ' ' . $global_config['currency_symbol']); ?>
												<?php if ($row->user_balance > 0): ?>
													<button class="btn btn-default btn-circle icon" data-toggle="tooltip"
															data-original-title="<?php echo translate('Deduce Payment'); ?>"
															onclick="deduceClientPayment(<?= $row->id ?>)">
														<i class="fas fa-money-check-alt" style="color: r;"></i>
													</button>
												<?php endif; ?>

											</td>


											<td>
												<a class="btn btn-default btn-circle icon" href="javascript:void(0);"
												   data-toggle="tooltip"
												   data-original-title="<?= translate('Current Package') . ": $row->package_name"; ?>"
												   onclick="getPackages(<?= "$row->id,$row->package_id" ?>)">
													<i class="fas fa-tag" style="color: gold;"></i>
												</a>
											</td>


											<td class="min-w-c">
												<?php
												/* if ($act_role == 3) {
													if (get_permission('doctor_short_bio', 'is_add')) {
														?>
												<a href="<?php echo base_url('employee/add_short_bio/' . $row->id); ?>"
													class="btn btn-circle btn-default icon" data-toggle="tooltip"
													data-original-title="Short Bio">
													<i class="fas fa-book-reader"></i>
												</a>
												<?php }
												}  */ ?>

												<?php if (get_permission('client', 'is_edit')): ?>
													<a href="<?= base_url('client/profile/' . $row->id); ?>"
													   class="btn btn-circle btn-default icon" data-toggle="tooltip"
													   data-original-title="<?= translate('profile'); ?>">
														<i class="far fa-arrow-alt-circle-right"></i>
													</a>
												<?php endif; ?>

												<?php if (get_permission('client', 'is_delete')): ?>
													<?= btn_delete('client/delete/' . $row->id); ?>
												<?php endif; ?>
											</td>
										</tr>
									<?php endforeach; ?>
									</tbody>
								</table>
						</div>
					</div>
			   </div>
            </div>
            <?php if (get_permission('client', 'is_add')) { ?>

                <!-- Add the Download Sample button here -->
                <div class="tab-pane <?php echo(isset($validation_error) ? 'active' : ''); ?>" id="create">
                    <?php //echo form_open_multipart($this->uri->uri_string(), array('class' => 'form-horizontal form-bordered')); ?>
                    <!--------------------- TODO: Download CSV File-------------- -->
                    <div class="form-group">
                        <label class="col-md-3 control-label"><?php echo translate('Download Sample'); ?> <span
                                    class="required">*</span></label>
                        <div class="col-md-8">
                            <a href="https://voice.tolpar.com.bd/contact_center/assets/file/CSV/upload_sample_tts.csv"
                               download>
                                <button class="btn btn-default" id="download_sample_create">
                                    <i class="fas fa-download"
                                       style="color: #FFB534;"></i> <?php echo translate('Download Sample'); ?>
                                </button>
                            </a>
                        </div>
                    </div>
                    <div id="upload_area">
                        <form method="post" id="upload_form" enctype="multipart/form-data">

                            <div class="form-group <?php if (form_error('title')) echo 'has-error'; ?>">
                                <label class="col-md-3 control-label"><?php echo translate('Group') . " " . translate('name'); ?>
                                    <span class="required">*</span></label>
                                <div class="col-md-8">
                                    <input type="text" class="form-control" name="group_name" value="" required/>
                                </div>
                            </div>


                            <div class="form-group <?php if (form_error('photo')) echo 'has-error'; ?>">
                                <label class="col-md-3 control-label"><?php echo translate('select CSV'); ?> <span
                                            class="required">*</span></label>
                                <div class="col-md-8">
                                    <input type="file" name="file" class="dropify" data-height="150"
                                           data-default-file="" id="csv_file"/>
                                    <span class="error"><?php echo form_error('photo'); ?></span>
                                </div>
                            </div>


                            <footer class="panel-footer mt-lg">
                                <div class="row">
                                    <div class="col-md-2 col-md-offset-3">

                                        <button type="submit" class="btn btn-default btn-block" name="upload_file"
                                                id="upload_file" value="Upload">
                                            <i class="fas fa-plus-circle"></i> <?php echo translate('upload'); ?>
                                        </button>
                                    </div>
                                </div>
                            </footer>
                        </form>
                    </div>
                    <?php //echo form_close(); ?>


                    <div class="table-responsive" id="process_area">

                    </div>
                </div>
            <?php } ?>
        </div>
    </div>
</section>




<script>
    $(document).ready(function () {

        $('#upload_form').on('submit', function (event) {

            event.preventDefault();
            $.ajax({
                url: base_url + 'client/csv_upload_preview',
                method: "POST",
                data: new FormData(this),
                dataType: 'json',
                contentType: false,
                cache: false,
                processData: false,
                success: function (data) {
                    if (data.error != '') {
                        $('#message').html('<div class="alert alert-danger">' + data.error + '</div>');
                    } else {
                        $('#process_area').html(data.output);
                        $('#upload_area').css('display', 'none');
                    }
                }
            });

        });

        var total_selection = 0;

        var name = 0;

        var phone = 0;

        var address = 0;

        var email = 0;

        var column_data = [];

        $(document).on('change', '.set_column_data', function () {

            var column_name = $(this).val();

            var column_number = $(this).data('column_number');

            if (column_name in column_data) {
                alert('You have already define ' + column_name + ' column');

                $(this).val('');

                return false;
            }

            if (column_name != '') {
                column_data[column_name] = column_number;
            } else {
                const entries = Object.entries(column_data);

                for (const [key, value] of entries) {
                    if (value == column_number) {
                        delete column_data[key];
                    }
                }
            }

            total_selection = Object.keys(column_data).length;

            if (total_selection >= 2) {
                $('#import').attr('disabled', false);

                name = column_data.name;

                phone = column_data.phone;

                address = column_data.address;

                email = column_data.email;
            } else {
                $('#import').attr('disabled', 'disabled');
            }

        });

        $(document).on('click', '#import', function (event) {

            event.preventDefault();

            $.ajax({
                url: base_url + 'client/csv_insert_data',
                method: "POST",
                data: {
                    name: name,
                    phone: phone,
                    address: address,
                    email: email,
                    group_name: $('input[name="group_name"]').val()
                },
                beforeSend: function () {
                    $('#import').attr('disabled', 'disabled');
                    $('#import').text('Importing...');
                },
                success: function (data) {
                    $('#import').attr('disabled', false);
                    $('#import').text('Import');
                    $('#process_area').css('display', 'none');
                    $('#upload_area').css('display', 'block');
                    $('#upload_form')[0].reset();
                    $('#message').html("<div class='alert alert-success'>" + data + "</div>");

                    window.location.href = base_url + 'contacts';
                    <?php //set_alert('success', translate('data uploaded successfully'));?>
                }
            })

        });

    });
</script>

<!-- add payment / deduce payment -->
<script>
    // get rateProfile details
    function addClientPayment(id) {
        $.ajax({
            url: base_url + 'client/add_payment_ui',
            type: 'POST',
            data: {'id': id},
            dataType: "html",
            success: function (html) {
                $('#quick_add_payment').html(html);
                mfp_modal('#addPaymentModel');
            }
        });
    }

    // deduce payment on user list
    function deduceClientPayment(id) {
        $.ajax({
            url: base_url + 'client/deduce_payment_ui',
            type: 'POST',
            data: {'id': id},
            dataType: 'html',
            success: function (data) {
                $('#quick_deduce_payment').html(data);
                mfp_modal('#deducePaymentModel');
            }
        });
    }
</script>



