<div class="row">

    <div class="col-md-12">
        <section class="panel">

            <?= form_open('client/deduce_payment'); ?>

            <input type="hidden" name="profile_id" value="<?php echo $profile_id; ?>">

            <?php $current_balance = $user_details['user_balance']; ?>

            <div class="panel-body">
                <?php if ($userId != 1): ?>
                    <p>
                        <b>Your Current Balance is
                            <?= $global_config['currency_symbol'] . $current_balance; ?>
                        </b>
                    </p>
                <?php endif; ?>

                <!-- Deduction Amount -->
                <div class="form-group mb-md">
                    <label class="control-label">
                        <?= translate('deduction_amount') ?>
                        <span class="required">*</span>
                    </label>
                    <input type="number" step="0.01" min="0.0" max="<?= $current_balance ?>" class="form-control"
                        name="deduction_money" value="" required />
                </div>

                <div class="form-group mb-md">
                    <label class="control-label">Remarks<span class="required">*</span></label>
                    <textarea class="form-control" rows="3" name="remarks" placeholder="remarks" spellcheck="false"
                        required></textarea>
                </div>

            </div>
            <div class="panel-footer">
                <div class="row">
                    <div class="col-md-12">
                        <button class="btn btn-default pull-right" type="submit">
                            <i class="fas fa-plus-circle"></i>
                            <?php echo translate('deduce'); ?>
                        </button>
                    </div>
                </div>
            </div>
            <?= form_close(); ?>


        </section>
    </div>

</div>


<script>
    $(document).ready(function () {

        // Function to toggle manager field
        function toggleTransactionIDField() {
            var packageType = $('#payment_method').val();
            if (packageType !== 'Cash') {
                $('#transaction_id').parent().show();
                $('#transaction_id').attr('required', true);
            } else {
                $('#transaction_id').parent().hide();
                $('#transaction_id').removeAttr('required');
            }
        }

        // Call the function on page load
        toggleTransactionIDField();

        // Call the function on package type change
        $('#payment_method').change(function () {
            toggleTransactionIDField();
        });
    });
</script>

<script>
    function validateAddMoney() {
        var addMoney = parseFloat(document.getElementsByName("add_money")[0].value);
        var currentBalance = parseFloat("<?php echo $current_balance; ?>");
        var userId = parseInt("<?php echo $userId; ?>");
        if (userId !== 1 && addMoney > currentBalance) {
            document.getElementById("addMoneyError").style.display = "block";
            return false;
        }
        return true;
    }
</script>