<div class="panel">
    <?= form_open('client/add_payment', [], ['profile_id' => $profile_id ?? null]); ?>
    <div class="panel-body">
        <?php
        $current_balance = $admin_balance['user_balance'];
        $client_detail = $this->employee_model->get_staff_details_by_id($profile_id);
        $package = $this->package_model->find($client_detail['package_id']);
        $package_type = $package ? $package->type : '';
        $sale_price = $package ? $package->sale_price : 0;
        $per_day_sale_price = $sale_price / 30;
        $expire_date = $client_detail['expire_date'] ?? 'N/A';
        $remaining_days = 'N/A';
        $total = '0.00';

        if ($expire_date !== 'N/A') {
            $current_date = date('Y-m-d');
            $date_diff = strtotime($expire_date) - strtotime($current_date);
            $days = floor($date_diff / (60 * 60 * 24));
            $remaining_days = $days;
            $total = number_format($per_day_sale_price * abs($days), 2);
        }
        ?>

        <div class="form-group mb-md">
            <label for="add_money" class="control-label">Amount</label>
            <input
                type="number"
                step="0.01"
                class="form-control"
                name="add_money"
                id="add_money"
                placeholder="Enter amount"
                required />
        </div>

        <!-- Payment Method -->
        <div class="form-group mb-md">
            <label class="control-label">Payment Method<span class="required">*</span></label>
            <select class="form-control" data-plugin-selectTwo name="payment_method" id="payment_method" required>
                <?php if (empty($payment_methods)) : ?>
                    <option value=""><?= translate('No Payment Method Found'); ?></option>
                <?php else : ?>
                    <option value=""><?= translate('Select Payment Method') ?></option>
                    <?php foreach ($payment_methods as $payment_method) : ?>
                        <option value="<?= $payment_method['id'] ?>">
                            <?= html_escape($payment_method['name']) ?>
                        </option>
                    <?php endforeach; ?>
                <?php endif; ?>
            </select>
        </div>

        <!-- Transaction ID -->
        <div class="form-group mb-md">
            <label for="transaction_id" class="control-label">Transaction ID<span class="required">*</span></label>
            <input type="text" class="form-control" id="transaction_id" name="transaction_id"
                placeholder="Transaction ID" required />
        </div>

        <div class="form-group mb-md">
            <label class="control-label">Remarks<span class="required">*</span></label>
            <textarea class="form-control" rows="3" name="remarks" placeholder="remarks" spellcheck="false"
                required></textarea>
        </div>

    </div>

    <div class="panel-footer">
        <div class="row">
            <div class="col-md-12">
                <button class="btn btn-default pull-right" type="submit" onclick="return validateAddMoney()">
                    <i class="fas fa-plus-circle"></i>
                    <?= translate('add'); ?>
                </button>
                <p id="addMoneyError" style="display:none; color:red;">
                    You cannot add money greater than your current balance
                </p>
            </div>
        </div>
    </div>
    <?= form_close(); ?>
</div>

<script>
    $(document).ready(function() {

        function validateAddMoney() {
            const addMoney = parseFloat($('#add_money').val());
            const currentBalance = parseFloat("<?= $current_balance; ?>");
            const userId = parseInt("<?= get_loggedin_user_id(); ?>");
            if (userId !== 1 && addMoney > currentBalance) {
                alert("You cannot add more than your current balance.");
                return false;
            }
            return true;
        }

    });
</script>
