<div class="row">
    <div class="col-md-12">
        <section class="panel">
            <?= form_open_multipart($this->uri->uri_string()); ?>
            <div class="panel-heading">
                <h4 class="panel-title"><i
                        class="fas fa-chalkboard-teacher"></i> <?= translate('Client') . " " . translate('create'); ?>
                </h4>
            </div>

            <div class="panel-body">
                <?= validation_errors(); ?>

                <!-- Basic Details -->
                <div class="headers-line mt-md">
                    <i class="fas fa-user-check"></i> <?= translate('basic') . " " . translate('details'); ?>
                </div>

                <div class="row">
                    <div class="col-md-6 mb-sm">

                              <div class="form-group">
                            <label for="idd" class="control-label"><?= translate('Client_id'); ?> <span class="required">*</span></label>
                            <input type="text" class="form-control" name="idd" value="<?= html_escape($next_client_id) ?>" readonly>
                            <span class="error"><?= form_error('idd'); ?></span>
                        </div>
                           </div>
                    <div class="col-md-6 mb-sm">
                        <div class="form-group <?= form_error('name') ? 'has-error' : ''; ?>">
                            <label for="name" class="control-label"><?= translate('Client Name'); ?> <span class="required">*</span></label>
                            <div class="input-group">
                                <span class="input-group-addon"><i class="far fa-user"></i></span>
                                <input class="form-control" name="name" id="name" type="text" value="<?= set_value('name'); ?>"required placeholder="Milon">
                            </div>
                            <span class="error"><?= form_error('name'); ?></span>
                        </div>
                    </div>
               
                </div>
                <!-- 
                <div class="row">
                    <div class="col-md-6 mb-sm">
                        <div class="form-group">
                            <label for="father_name" class="control-label"><?= translate('father_name'); ?></label>
                            <input type="text" class="form-control" name="father_name" id="father_name" value="<?= set_value('father_name'); ?>">
                        </div>
                    </div>
                    <div class="col-md-6 mb-sm">
                        <div class="form-group">
                            <label for="mother_name" class="control-label"><?= translate('mother_name'); ?></label>
                            <input type="text" class="form-control" name="mother_name" id="mother_name" value="<?= set_value('mother_name'); ?>">
                        </div>
                    </div>
                </div>

                <div class="row">

                    <div class="col-md-4 mb-sm">
                        <div class="form-group">
                            <label for="organization" class="control-label"><?= translate('organization_name'); ?></label>
                            <input type="text" class="form-control" name="organization" id="organization" value="<?= set_value('organization'); ?>">
                        </div>
                    </div>
                    <div class="col-md-4 mb-sm">
                        <div class="form-group">
                            <label class="control-label"><?= translate('any_illness'); ?></label>
                            <?= form_dropdown(
                                "any_illness",
                                ["no" => translate('no'), "yes" => translate('yes')],
                                set_value("any_illness"),
                                "class='form-control' data-plugin-selectTwo data-width='100%'"
                            ); ?>
                        </div>
                    </div>
                   
                    
                </div> -->

                <div class="row">

                    <div class="col-md-4 mb-sm">
                        <div class="form-group">
                            <label class="control-label"><?= translate('gender'); ?></label>
                            <?= form_dropdown(
                                "gender",
                                [
                                    "" => translate('select'),
                                    "male" => translate('male'),
                                    "female" => translate('female')
                                ],
                                set_value('gender'),
                                "class='form-control' data-plugin-selectTwo data-width='100%'	data-minimum-results-for-search='Infinity'"
                            ); ?>
                            <span class="error"><?= form_error('gender'); ?></span>
                        </div>
                    </div>


                    <div class="col-md-4 mb-sm">
                        <div class="form-group">
                            <label for="religion" class="control-label"><?= translate('religion'); ?></label>
                            <?= form_dropdown(
                                "religion",
                                ["islam" => translate('islam'), "hinduism" => translate('hinduism'), "christianity" => translate('christianity'), "other" => translate('other')],
                                set_value("religion"),
                                "class='form-control' data-plugin-selectTwo data-width='100%'"
                            ); ?>
                        </div>
                    </div>
                    <!-- <div class="col-md-4 mb-sm">
                        <div class="form-group">
                            <label for="class" class="control-label"><?= translate('class'); ?> <span class="required">*</span></label>
                            <input type="text" class="form-control" name="class" id="class" value="<?= set_value('class'); ?>">
                            <span class="error"><?= form_error('class'); ?></span>
                        </div>
                    </div> -->
                    <div class="col-md-4 mb-sm">
                        <div class="form-group">
                            <label for="nationality" class="control-label"><?= translate('nationality'); ?></label>
                            <select class="form-control" name="nationality" id="nationality" onchange="setDialingCode()" required>
                                <option value="">-- Select Nationality --</option>
                                <option value="Afghan" data-code="+93" <?= set_value('nationality') == 'Afghan' ? 'selected' : '' ?>>Afghan</option>
                                <option value="Albanian" data-code="+355" <?= set_value('nationality') == 'Albanian' ? 'selected' : '' ?>>Albanian</option>
                                <option value="Algerian" data-code="+213" <?= set_value('nationality') == 'Algerian' ? 'selected' : '' ?>>Algerian</option>
                                <option value="American" data-code="+1" <?= set_value('nationality') == 'American' ? 'selected' : '' ?>>American</option>
                                <option value="Argentinian" data-code="+54" <?= set_value('nationality') == 'Argentinian' ? 'selected' : '' ?>>Argentinian</option>
                                <option value="Australian" data-code="+61" <?= set_value('nationality') == 'Australian' ? 'selected' : '' ?>>Australian</option>
                                <option value="Austrian" data-code="+43" <?= set_value('nationality') == 'Austrian' ? 'selected' : '' ?>>Austrian</option>
                                <option value="Bangladeshi" data-code="+88" <?= set_value('nationality') == 'Bangladeshi' ? 'selected' : '' ?>>Bangladeshi</option>
                                <option value="Belgian" data-code="+32" <?= set_value('nationality') == 'Belgian' ? 'selected' : '' ?>>Belgian</option>
                                <option value="Brazilian" data-code="+55" <?= set_value('nationality') == 'Brazilian' ? 'selected' : '' ?>>Brazilian</option>
                                <option value="British" data-code="+44" <?= set_value('nationality') == 'British' ? 'selected' : '' ?>>British</option>
                                <option value="Canadian" data-code="+1" <?= set_value('nationality') == 'Canadian' ? 'selected' : '' ?>>Canadian</option>
                                <option value="Chinese" data-code="+86" <?= set_value('nationality') == 'Chinese' ? 'selected' : '' ?>>Chinese</option>
                                <option value="Danish" data-code="+45" <?= set_value('nationality') == 'Danish' ? 'selected' : '' ?>>Danish</option>
                                <option value="Egyptian" data-code="+20" <?= set_value('nationality') == 'Egyptian' ? 'selected' : '' ?>>Egyptian</option>
                                <option value="Ethiopian" data-code="+251" <?= set_value('nationality') == 'Ethiopian' ? 'selected' : '' ?>>Ethiopian</option>
                                <option value="Finnish" data-code="+358" <?= set_value('nationality') == 'Finnish' ? 'selected' : '' ?>>Finnish</option>
                                <option value="French" data-code="+33" <?= set_value('nationality') == 'French' ? 'selected' : '' ?>>French</option>
                                <option value="German" data-code="+49" <?= set_value('nationality') == 'German' ? 'selected' : '' ?>>German</option>
                                <option value="Greek" data-code="+30" <?= set_value('nationality') == 'Greek' ? 'selected' : '' ?>>Greek</option>
                                <option value="Indian" data-code="+91" <?= set_value('nationality') == 'Indian' ? 'selected' : '' ?>>Indian</option>
                                <option value="Indonesian" data-code="+62" <?= set_value('nationality') == 'Indonesian' ? 'selected' : '' ?>>Indonesian</option>
                                <option value="Iranian" data-code="+98" <?= set_value('nationality') == 'Iranian' ? 'selected' : '' ?>>Iranian</option>
                                <option value="Iraqi" data-code="+964" <?= set_value('nationality') == 'Iraqi' ? 'selected' : '' ?>>Iraqi</option>
                                <option value="Irish" data-code="+353" <?= set_value('nationality') == 'Irish' ? 'selected' : '' ?>>Irish</option>
                                <option value="Italian" data-code="+39" <?= set_value('nationality') == 'Italian' ? 'selected' : '' ?>>Italian</option>
                                <option value="Japanese" data-code="+81" <?= set_value('nationality') == 'Japanese' ? 'selected' : '' ?>>Japanese</option>
                                <option value="Kenyan" data-code="+254" <?= set_value('nationality') == 'Kenyan' ? 'selected' : '' ?>>Kenyan</option>
                                <option value="Malaysian" data-code="+60" <?= set_value('nationality') == 'Malaysian' ? 'selected' : '' ?>>Malaysian</option>
                                <option value="Mexican" data-code="+52" <?= set_value('nationality') == 'Mexican' ? 'selected' : '' ?>>Mexican</option>
                                <option value="Nepalese" data-code="+977" <?= set_value('nationality') == 'Nepalese' ? 'selected' : '' ?>>Nepalese</option>
                                <option value="Nigerian" data-code="+234" <?= set_value('nationality') == 'Nigerian' ? 'selected' : '' ?>>Nigerian</option>
                                <option value="Norwegian" data-code="+47" <?= set_value('nationality') == 'Norwegian' ? 'selected' : '' ?>>Norwegian</option>
                                <option value="Pakistani" data-code="+92" <?= set_value('nationality') == 'Pakistani' ? 'selected' : '' ?>>Pakistani</option>
                                <option value="Philippine" data-code="+63" <?= set_value('nationality') == 'Philippine' ? 'selected' : '' ?>>Philippine</option>
                                <option value="Russian" data-code="+7" <?= set_value('nationality') == 'Russian' ? 'selected' : '' ?>>Russian</option>
                                <option value="Saudi Arabian" data-code="+966" <?= set_value('nationality') == 'Saudi Arabian' ? 'selected' : '' ?>>Saudi Arabian</option>
                                <option value="Singaporean" data-code="+65" <?= set_value('nationality') == 'Singaporean' ? 'selected' : '' ?>>Singaporean</option>
                                <option value="South African" data-code="+27" <?= set_value('nationality') == 'South African' ? 'selected' : '' ?>>South African</option>
                                <option value="South Korean" data-code="+82" <?= set_value('nationality') == 'South Korean' ? 'selected' : '' ?>>South Korean</option>
                                <option value="Spanish" data-code="+34" <?= set_value('nationality') == 'Spanish' ? 'selected' : '' ?>>Spanish</option>
                                <option value="Sri Lankan" data-code="+94" <?= set_value('nationality') == 'Sri Lankan' ? 'selected' : '' ?>>Sri Lankan</option>
                                <option value="Swedish" data-code="+46" <?= set_value('nationality') == 'Swedish' ? 'selected' : '' ?>>Swedish</option>
                                <option value="Swiss" data-code="+41" <?= set_value('nationality') == 'Swiss' ? 'selected' : '' ?>>Swiss</option>
                                <option value="Thai" data-code="+66" <?= set_value('nationality') == 'Thai' ? 'selected' : '' ?>>Thai</option>
                                <option value="Turkish" data-code="+90" <?= set_value('nationality') == 'Turkish' ? 'selected' : '' ?>>Turkish</option>
                                <option value="Ukrainian" data-code="+380" <?= set_value('nationality') == 'Ukrainian' ? 'selected' : '' ?>>Ukrainian</option>
                                <option value="United Arab Emirates" data-code="+971" <?= set_value('nationality') == 'United Arab Emirates' ? 'selected' : '' ?>>United Arab Emirates</option>
                                <option value="Vietnamese" data-code="+84" <?= set_value('nationality') == 'Vietnamese' ? 'selected' : '' ?>>Vietnamese</option>
                                <option value="Zimbabwean" data-code="+263" <?= set_value('nationality') == 'Zimbabwean' ? 'selected' : '' ?>>Zimbabwean</option>
                            </select>
                        </div>
                    </div>


                    <!-- Hidden input to store dial code so it submits with form -->
                    <input type="hidden" name="dial_code" id="dial_code" value="<?= set_value('dial_code', '+XXX'); ?>">

                    <script>
                        function setDialingCode() {
                            const nationalitySelect = document.getElementById("nationality");
                            const selectedOption = nationalitySelect.options[nationalitySelect.selectedIndex];
                            const code = selectedOption.getAttribute("data-code") || "+XXX";
                            document.getElementById("mobile-code").innerText = code;
                            document.getElementById("dial_code").value = code; // Update hidden input
                        }

                        // Set dialing code on page load if nationality is preselected
                        document.addEventListener("DOMContentLoaded", setDialingCode);
                    </script>

                </div>

                <div class="row">
                         <div class="col-sm-4 mb-sm">
                            <div class="form-group">
                                <label for="client_type" class="control-label"><?= translate('Client_type'); ?>
                                    <span class="required">*</span></label>
                                <?= form_dropdown(
                                    "client_type",
                                    [
                                        "" => translate('select'),
                                        "common " => translate('common'),
                                        "orphans " => translate('orphans'),
                                        "incapacitated " => translate('incapacitated')

                                    ],
                                    set_value('client_type'),
                                    "id='client_type' class='form-control' data-plugin-selectTwo data-width='100%' data-minimum-results-for-search='Infinity'"
                                ); ?>
                            </div>
                        </div>

                    <div class="col-md-4 mb-sm">
                        <div class="form-group <?= form_error('mobile_no') ? 'has-error' : '' ?>">
                            <label for="mobile_no" class="control-label">
                                <?= translate('mobile_number'); ?> <span class="required">*</span>
                            </label>
                            <div class="input-group">
                                <span class="input-group-addon"><i class="fas fa-phone-volume"></i></span>
                                <span class="input-group-addon" id="mobile-code">+XXX</span>
                                <input class="form-control" name="mobile_no" id="mobile_no" type="text" value="<?= set_value('mobile_no'); ?>"  required placeholder="+8801XXXXXXXXX">
                            </div>
                            <span class="error"><?= form_error('mobile_no'); ?></span>
                        </div>
                    </div>

                    <div class="col-md-4 mb-sm">
                        <div class="form-group <?= form_error('email') ? 'has-error' : '' ?>">
                            <label for="email" class="control-label"><?= translate('e-mail'); ?> <span class="required">*</span></label>
                            <div class="input-group">
                                <span class="input-group-addon"><i class="far fa-envelope-open"></i></span>
                                <input type="email" class="form-control" name="email" id="email" value="<?= set_value('email'); ?>"  required placeholder="example@gmail.com">
                            </div>
                            <span class="error"><?= form_error('email'); ?></span>
                        </div>
                    </div>
                </div>

                <!-- <div class="row">
                    <div class="col-md-12 mb-sm">
                        <div class="form-group">
                            <label for="address" class="control-label"><?= translate('address'); ?></label>
                            <textarea class="form-control" rows="3" name="address" id="address" placeholder="<?= translate('address'); ?>"><?= set_value('address'); ?></textarea>
                        </div>
                    </div>
                </div> -->

                <div class="row mb-md">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="input-file-now"><?= translate('profile_picture'); ?></label>
                            <input type="file" name="user_photo" class="dropify" data-allowed-file-extensions="jpg png" data-height="120" />
                        </div>
                    </div>
                </div>

                <!-- login details -->
                <section>
                    <div class="headers-line">
                        <i class="fas fa-user-lock"></i> <?= translate('login_details'); ?>
                    </div>

                    <div class="row mb-lg">
                        <div class="col-md-6 mb-sm">
                            <div class="form-group <?= form_error('username') ? 'has-error' : '' ?>">
                                <label for="username" class="control-label">
                                    <?= translate('username'); ?>
                                    <span class="required">*</span>
                                </label>
                                <div class="input-group">
                                    <span class="input-group-addon"><i class="fas fa-user-lock"></i></span>
                                    <input
                                        type="text"
                                        class="form-control"
                                        name="username" id="username"
                                        value="<?= set_value('username'); ?>" />
                                </div>
                                <span class="error"><?= form_error('username'); ?></span>
                            </div>
                        </div>
                        <div class="col-md-3 mb-sm">
                            <div class="form-group <?php if (form_error('password')) echo 'has-error'; ?>">
                                <label for="password" class="control-label"><?= translate('password'); ?> <span
                                        class="required">*</span></label>
                                <div class="input-group">
                                    <span class="input-group-addon"><i class="fas fa-unlock-alt"></i></span>
                                    <input type="password" class="form-control" name="password" id="password"
                                        value="<?= set_value('password'); ?>" />
                                </div>
                                <span class="error"><?= form_error('password'); ?></span>
                            </div>
                        </div>
                        <div class="col-md-3 mb-sm">
                            <div class="form-group <?= form_error('retype_password') ? 'has-error' : '' ?>">
                                <label for="retype_password" class="control-label">
                                    <?= translate('retype_password'); ?>
                                    <span class="required">*</span></label>
                                <div class="input-group">
                                    <span class="input-group-addon"><i class="fas fa-unlock-alt"></i></span>
                                    <input type="password"
                                        class="form-control"
                                        name="retype_password" id="retype_password"
                                        value="<?= set_value('retype_password'); ?>" />
                                </div>
                                <span class="error"><?= form_error('retype_password'); ?></span>
                            </div>
                        </div>
                    </div>
                </section>
                <!-- Network & Product Information -->
                <?php if (loggedin_role_id() != 2): ?>
                    <section>
                        <div class="headers-line">
                            <i class="fas fa-wifi"></i> <?= translate('Network & Product Information'); ?>
                        </div>
                        <div class="row">

                            <?php if (!in_array(loggedin_role_id(), array(3, 4))) { ?>
                                <div class="col-md-3 mb-lg">
                                    <div class="form-group <?= form_error('reseller_subreseller_id') ? 'has-error' : null ?>">
                                        <label for="reseller_subreseller_id" class="control-label">
                                            <?php
                                            if (loggedin_role_id() != 2 && loggedin_role_id() != 4) {
                                                echo translate('Branch_list');
                                            } elseif (loggedin_role_id() == 2) {
                                                echo translate('Sub_Branch_list');
                                            }
                                            ?>
                                        </label>
                                        <div class="input-group">
                                            <span class="input-group-addon"><i class="fas fa-users"></i></span>
                                            <select class="form-control" data-plugin-selectTwo data-width="100%"
                                                name="reseller_subreseller_id"
                                                id="reseller_subreseller_id">
                                                <?php /** @var array<array> $nasList */ ?>
                                                <?php if (empty($reseller_subreseller_list)): ?>
                                                    <option value=""><?= translate('No Branch Found'); ?></option>
                                                <?php else: ?>
                                                    <option value=""><?= translate('Select') ?></option>
                                                    <?php foreach ($reseller_subreseller_list as $reseller_subreseller): ?>
                                                        <option value="<?= $reseller_subreseller->id ?>" <?= set_select('reseller_subreseller_id', $reseller_subreseller->id) ?>>
                                                            <?= html_escape($reseller_subreseller->name) ?>
                                                        </option>
                                                    <?php endforeach; ?>
                                                <?php endif; ?>
                                            </select>
                                            <span class="error"><?= form_error('reseller_subreseller_id'); ?></span>
                                        </div>
                                    </div>
                                </div>
                            <?php } ?>

                        </div>
                    </section>
                <?php endif; ?>


                <!-- Service Information -->
                <section>
                    <div class="headers-line">
                        <i class="fas fa-toolbox"></i> <?= translate('Service Information'); ?>
                    </div>

                    <div class="row">

                        <!-- package -->
                        <!-- <div class="col-sm-6 mb-sm">
                            <div class="form-group">
                                <label for="package_id" class="control-label">
                                    <?= translate('package') ?>
                                    <span class="required">*</span>
                                </label>
                                <select name="package_id" id="package_id" class='form-control' data-plugin-selectTwo
                                    data-width='100%' data-minimum-results-for-search='Infinity'>
                                    <option value=""><?= translate('select') ?></option>
                                    <?php if (!empty($packages)): ?>
                                        <?php foreach ($packages as $package): ?>
                                            <option value="<?= $package->id ?>" <?= set_select('package_id', $package->id) ?>><?= $package->name ?></option>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </select>
                            </div>
                        </div> -->

                        <!-- client_type -->
                   
                        <div class="col-sm-6 mb-sm">
                            <div class="form-group <?= form_error('server_username') ? 'has-error' : '' ?>">
                                <label for="server_username" class="control-label">
                                    <?= translate('server_username'); ?>
                                    <span class="required">*</span>
                                </label>
                                <input id="server_username" type="text" class="form-control" name="server_username"
                                    value="<?= set_value('server_username'); ?>">
                                <span class="error"><?= form_error('server_username'); ?></span>
                            </div>
                        </div>

                        <div class="col-sm-6 mb-sm">
                            <div class="form-group <?= form_error('server_password') ? 'has-error' : '' ?>">
                                <label for="server_password" class="control-label">
                                    <?= translate('server_password'); ?>
                                    <span class="required">*</span>
                                </label>
                                <input
                                    type="password"
                                    class="form-control"
                                    name="server_password" id="server_password"
                                    value="<?= set_value('server_password'); ?>">
                                <span class="error"><?= form_error('server_password'); ?></span>
                            </div>
                        </div>


                    </div>







                </section>


            </div>
            <footer class="panel-footer">
                <div class="row">
                    <div class="col-md-offset-10 col-md-2">
                        <button type="submit" name="save" value="1" class="btn btn btn-default btn-block"><i
                                class="fas fa-plus-circle"></i> <?= translate('save'); ?></button>
                    </div>
                </div>
            </footer>
            <?= form_close(); ?>
        </section>
    </div>
</div>