<section class="panel">
    <div class="tabs-custom">
        <ul class="nav nav-tabs">
            <li class="<?= (empty(validation_errors()) && (($action ?? null) != 'edit')) ? 'active' : null ?>">
                <a
                    <?php if (($action ?? null) == 'edit') : ?>
                        href="<?= base_url('billing_profile'); ?>"
                    <?php else: ?>
                        href="#list" data-toggle="tab"
                    <?php endif; ?>
                >
                    <i class="fas fa-list-ul"></i>
                    <?= translate('Billing Profiles') ?>
                </a>
            </li>
            <li class="<?= (!empty(validation_errors()) || (($action ?? null) == 'edit')) ? 'active' : null ?>">
                <a href="#create" data-toggle="tab">
                    <i class="far fa-edit"></i>
                    <?php if (($action ?? null) == 'edit'): ?>
                        <?= translate('Edit Billing Profile') ?>
                    <?php else: ?>
                        <?= translate('Add Billing Profile') ?>
                    <?php endif; ?>
                </a>
            </li>
        </ul>
        <div class="tab-content">

            <!-- Billing Profile List -->
            <div id="list"
                 class="tab-pane <?= (empty(validation_errors()) && (($action ?? null) != 'edit')) ? 'active' : null ?>">
                <div class="mb-md">
                    <table class="table table-bordered table-hover table-condensed table_default">
                        <thead>
                        <tr>
                            <th><?= translate('sl'); ?></th>
                            <th><?= translate('ID'); ?></th>
                            <th><?= translate('Name') ?></th>
                            <th><?= translate('Due Date') ?></th>
                            <th><?= translate('Assign To') ?></th>
                            <th><?= translate('Auto Bill') ?></th>
                            <th><?= translate('Send Email Notification') ?></th>
                            <th><?= translate('Auto Hold') ?></th>
                            <th><?= translate('created_at') ?></th>
                            <th><?= translate('updated_at') ?></th>
                            <th><?= translate('action') ?></th>
                        </tr>
                        </thead>
                        <tbody>
						
                        <?php if (!empty($billingProfiles)) : ?>
                            <?php foreach ($billingProfiles as $index => $billingProfile): ?>
                                <tr>
                                    <td><?= $index + 1 ?></td>

                                    <td><?= $billingProfile->id ?></td>
                                    <td><?= html_escape($billingProfile->profile_name) ?></td>
                                    <td><?= html_escape($billingProfile->billing_due_date) ?></td>
                                    <td><?= html_escape($billingProfile->staff_name) ?></td>
                                    <td><?= $billingProfile->auto_bill ? 'Yes' : 'No' ?></td>
                                    <td><?= $billingProfile->send_email ? 'Yes' : 'No' ?></td>
                                    <td><?= $billingProfile->auto_hold ? 'Yes' : 'No' ?></td>
                                    <td><?= date('Y-m-d h:i a', strtotime($billingProfile->created_at)) ?></td>
                                    <td><?= date('Y-m-d h:i a', strtotime($billingProfile->updated_at)) ?></td>

                                    <td>
                                        <?php if (get_permission('billing_profile', 'is_edit')): ?>
                                            <a href="<?php echo base_url('billing_profile/edit/' . $billingProfile->id); ?>"
                                               class="btn btn-circle icon btn-default" data-toggle="tooltip"
                                               data-original-title="<?php echo translate('edit'); ?>">
                                                <i class="fas fa-pen-nib"></i>
                                            </a>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Billing Profile Create -->
            <div id="create"
                 class="tab-pane <?= (!empty(validation_errors()) || (($action ?? null) == 'edit')) ? 'active' : null ?>">
                <?= form_open($this->uri->uri_string(), ['class' => 'form-horizontal']); ?>

                <div class="panel-body">

                    <!-- Profile Name  -->
                    <div class="form-group <?= form_error('profile_name') ? 'has-error' : null ?>">
                        <label for="profile_name" class="control-label col-sm-3">
                            <?= translate('profile_name'); ?>
                            <span class="required">*</span>
                        </label>
                        <div class="col-sm-6">
                            <input type="text" class="form-control"
                                   name="profile_name" id="profile_name"
                                   value="<?= set_value('profile_name', $billing_profile->profile_name ?? null) ?>"
                                   minlength="3" maxlength="255" required>
                            <span class="error"><?= form_error('profile_name'); ?></span>
                        </div>
                    </div>

                    <!-- Due day of month -->
                    <div class="form-group <?= form_error('billing_due_date') ? 'has-error' : null ?>">
                        <label for="billing_due_date" class="control-label col-sm-3">
                            <?= translate('billing_due_date'); ?>
                            <span class="required">*</span>
                        </label>
                        <div class="col-sm-6">
                            <input type="number" class="form-control"
                                   name="billing_due_date" id="billing_due_date"
                                   value="<?= set_value('billing_due_date', $billing_profile->billing_due_date ?? null) ?>"
                                   min="1" max="31" required
                            >
                            <span class="error"><?= form_error('billing_due_date'); ?></span>
                        </div>
                    </div>
		
					<!-- manager -->
                    <div class="form-group <?= form_error('assign_to') ? 'has-error' : null ?>">
                        <label for="assign_to" class="control-label col-sm-3">
                            <?= translate('Assign To'); ?>
                            <span class="required">*</span>
                        </label>
                        <div class="col-sm-6">
                            <select class="form-control" data-plugin-selectTwo name="assign_to" id="assign_to"
                                    required>
                                <?php /** @var array<array> $nasList */ ?>
                                <?php if (empty($employees)): ?>
                                    <option><?= translate('No Admin Found'); ?></option>
                                <?php else: ?>
                                    <option><?= translate('Select A Admin') ?></option>
                                    <?php foreach ($employees as $employee): ?>
                                        <?php $nas = (object)$employee ?>
                                        <option value="<?= $employee->id ?>" <?= set_select('assign_to', $employee->id) ?>>
                                            <?= html_escape($employee->name) ?>
                                        </option>
                                    <?php endforeach; ?>
                                <?php endif; ?>

                            </select>
                            <span class="error"><?= form_error('assign_to'); ?></span>
                        </div>
                    </div>
					
                    <!-- Auto Bill -->
                    <div class="form-group <?= form_error('auto_bill') ? 'has-error' : null ?>">
                        <label for="auto_bill" class="control-label col-sm-3">
                            <?= translate('auto_bill?'); ?>
                            <span class="required">*</span>
                        </label>
                        <div class="col-sm-6">
                            <select class="form-control" name="auto_bill" id="auto_bill" required>
                                <option value="1" <?= (set_select('auto_bill', 1) == 'selected')
                                    ? 'selected' : (($billing_profile->auto_bill ?? null) === '1')
                                        ? 'selected' : null ?>>
                                    Yes
                                </option>
                                <option value="0" <?= (set_select('auto_bill', 0) != '')
                                    ? 'selected' : (($billing_profile->auto_bill ?? null) === '0')
                                        ? 'selected' : null ?>>
                                    No
                                </option>
                            </select>
                            <span class="error"><?= form_error('auto_bill'); ?></span>
                        </div>
                    </div>

                    <!-- Send Email notification? -->
                    <div class="form-group <?= form_error('send_email') ? 'has-error' : null ?>">
                        <label for="send_email" class="control-label col-sm-3">
                            <?= translate('send_email_notification?'); ?>
                            <span class="required">*</span>
                        </label>
                        <div class="col-sm-6">
                            <select class="form-control" name="send_email" id="send_email">
                                <option value="0" <?= (set_select('send_email', 0) != '')
                                    ? 'selected' : (($billing_profile->send_email ?? null) === '0')
                                        ? 'selected' : null ?>>
                                    No
                                </option>
                                <option value="1" <?= (set_select('send_email', 1) != '')
                                    ? 'selected' : (($billing_profile->send_email ?? null) === '1')
                                        ? 'selected' : null ?>>
                                    Yes
                                </option>
                            </select>
                            <span class="error"><?= form_error('send_email'); ?></span>
                        </div>
                    </div>

                    <!-- auto hold? -->
                    <div class="form-group <?= form_error('auto_hold') ? 'has-error' : null ?>">
                        <label for="auto_hold" class="control-label col-sm-3">
                            <?= translate('auto_hold?'); ?>
                            <span class="required">*</span>
                        </label>
                        <div class="col-sm-6">
                            <select class="form-control" name="auto_hold" id="auto_hold">
                                <option value="1" <?= (set_select('auto_hold', 1) != '')
                                    ? 'selected' : (($billing_profile->auto_hold ?? null) === '1')
                                        ? 'selected' : null ?>>
                                    Yes
                                </option>
                                <option value="0" <?= (set_select('auto_hold', 0) != '')
                                    ? 'selected' : (($billing_profile->auto_hold ?? null) === '0')
                                        ? 'selected' : null ?>>
                                    No
                                </option>
                            </select>
                            <span class="error"><?= form_error('auto_hold'); ?></span>
                        </div>
                    </div>

                </div>

                <footer class="panel-footer">
                    <div class="row">
                        <div class="col-md-offset-10 col-md-2">
                            <button type="submit" class="btn btn btn-default btn-block">
                                <i class="fas fa-plus-circle"></i>
                                <?php if (($action ?? null) == 'edit'): ?>
                                    <?= translate('update') ?>
                                <?php else: ?>
                                    <?= translate('save') ?>
                                <?php endif; ?>
                            </button>
                        </div>
                    </div>
                </footer>
                <?= form_close(); ?>
            </div>
        </div>
    </div>
</section>