<?php
$status = $billing_data['status'];
$currency = $global_config['currency'];
$currency_symbol = $global_config['currency_symbol'];
$total = number_format($billing_data['total'], 2, '.', '');
$total_discount = number_format($billing_data['discount'], 2, '.', '');
$tax_amount = number_format($billing_data['tax_amount'], 2, '.', '');
$paid = number_format($billing_data['paid'], 2, '.', '');
$due_amount = number_format($billing_data['due'], 2, '.', '');
$net_amount = number_format($billing_data['net_amount'], 2, '.', '');
$active_tab = $this->session->flashdata('active_tab');
?>
<section class="panel">
    <div class="tabs-custom">
        <ul class="nav nav-tabs">
            <li class="<?=(empty($active_tab) || $active_tab == 1 ? 'active' : ''); ?>">
                <a href="#invoice" data-toggle="tab"><i
                            class="far fa-credit-card"></i> <?= translate('invoice'); ?></a>
            </li>
            <?php if ($paid > 1 && get_permission('billing_data_payment', 'is_view')): ?>
                <li class="<?=($active_tab == 2 ? 'active' : ''); ?>">
                    <a href="#payment_history" data-toggle="tab"><i
                                class="fas fa-dollar-sign"></i> <?= translate('payment_history'); ?></a>
                </li>
            <?php endif;
            if ($status != 3 && get_permission('billing_data_payment', 'is_add')): ?>
                <li class="<?=($active_tab == 3 ? 'active' : ''); ?>">
                    <a href="#add_payment" data-toggle="tab"><i
                                class="far fa-money-bill-alt"></i> <?= translate('add_payment'); ?></a>
                </li>
            <?php endif; ?>
        </ul>
        <div class="tab-content">
            <div id="invoice" class="tab-pane <?=(empty($active_tab) || $active_tab == 1 ? 'active' : ''); ?>">
                <div id="bill_print">
                    <div class="invoice">
                        <header class="clearfix">
                            <div class="row">
                                <div class="col-xs-6">
                                    <div class="ib">
                                        <img src="<?= base_url('uploads/app_image/printing-logo.png'); ?>"
                                             alt="Img"/>
                                    </div>
                                </div>
                                <div class="col-xs-6 text-right">
                                    <h4 class="mt-none mb-none text-dark">Bill No
                                        #<?= html_escape($billing_data['bill_no']); ?></h4>
                                    <p class="mb-none">
                                        <span class="text-dark"><?= translate('payment') . " " . translate('status'); ?> : </span>
                                        <span class="value">
											<?php
                                            $payment_a = array(
                                                '1' => translate('unpaid'),
                                                '2' => translate('partly_paid'),
                                                '3' => translate('total_paid')
                                            );
                                            echo($payment_a[$status]);
                                            ?>
										</span>
                                    </p>
                                    <p class="mb-none">
                                        <span class="text-dark"><?= translate('date'); ?> : </span>
										<span class="value"><?= _d($billing_data['date']); ?></span>
                                    </p>
									<p class="mb-none">
                                        <span class="text-dark"><?= translate('due date'); ?> : </span>
										<span class="value"><?= _d($billing_data['due_date']); ?></span>
                                    </p>
                                </div>
                            </div>
                        </header>
                        <div class="bill-info">
                            <div class="row">
                                <div class="col-xs-6">
                                    <div class="bill-data">
                                        <p class="h5 mb-xs text-dark text-weight-semibold"><?= translate('Client'); ?>
                                            :</p>
                                        <address>
                                            <?php
                                            echo html_escape($billing_data['p_name']) . '<br>';
                                            echo translate('mobile_no') . ' : ' . $billing_data['p_mobileno'] . '<br>';
                                            echo html_escape($billing_data['p_address']);
                                            ?>
                                        </address>
                                    </div>
                                </div>
                                <div class="col-xs-6">
                                    <div class="bill-data text-right">
                                        <p class="h5 mb-xs text-dark text-weight-semibold"><?= translate('from'); ?>
                                            :</p>
                                        <address>
                                            <?php
                                            echo html_escape($global_config['institute_name']) . "<br/>";
                                            echo html_escape($global_config['address']) . "<br/>";
                                            echo html_escape($global_config['mobileno']) . "<br/>";
                                            echo html_escape($global_config['institute_email']) . "<br/>";
                                            ?>
                                        </address>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="table-responsive">
                            <table class="table invoice-items table-hover tbr-top mb-none">
                                <thead>
                                <tr class="text-dark">
                                    <th id="cell-id" class="text-weight-semibold">#</th>
                                    <th id="cell-desc"
                                        class="text-weight-semibold"><?= translate("category"); ?></th>
                                    <th id="cell-item"
                                        class="text-weight-semibold"><?= translate("product") . "/" . translate("package"); ?></th>
                                    <th id="cell-price"
                                        class="text-weight-semibold"><?= translate("price"); ?></th>
                                    <th id="cell-qty"
                                        class="text-weight-semibold"><?= translate("discount"); ?></th>
                                    <th id="cell-total"
                                        class="text-center text-weight-semibold"><?= translate("total"); ?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php
                                $count = 1;
                                foreach ($bill_details as $row) {
                                    $price = $row['price'];
                                    $discount = $row['discount'];
                                    ?>
                                    <tr>
                                        <td><?= $count++; ?></td>
                                        <td><?= strtoupper(html_escape($row['category_name'])); ?></td>
                                        <td><?= html_escape($row['package_name'] ?? $row['product_name']); ?></td>
                                        <td><?= html_escape($currency_symbol . $price); ?></td>
                                        <td><?= html_escape($currency_symbol . $discount); ?></td>
                                        <td class="text-center"><?= html_escape($currency_symbol . ($price - $discount)); ?></td>
                                    </tr>
                                <?php } ?>
                                </tbody>
                            </table>
                        </div>
                        <div class="invoice-summary text-right mt-lg">
                            <div class="row">
                                <div class="col-lg-5 pull-right">
                                    <ul class="amounts">
                                        <li><?= translate('sub') . " " . translate('total'); ?>
                                            (<?= html_escape($currency_symbol); ?>)
                                            : <?= html_escape($total); ?></li>
                                        <li><?= translate('discount'); ?>
                                            (<?= html_escape($currency_symbol); ?>)
                                            : <?= html_escape($total_discount); ?></li>
                                        <li><?= translate('tax'); ?>
                                            (<?= html_escape($currency_symbol); ?>)
                                            : <?= html_escape($tax_amount); ?></li>
                                        <?php if ($status == 3) { ?>
                                            <li>
                                                <strong><?= translate('net_payable'); ?>
                                                    (<?= html_escape($currency_symbol); ?>) : </strong>
                                                <?php
                                                $f = new NumberFormatter("en", NumberFormatter::SPELLOUT);
                                                echo html_escape($net_amount) . " </br>( " . ucwords($f->format($net_amount)) . " $currency )";
                                                ?>
                                            </li>
                                        <?php } else { ?>
                                            <li><?= translate('net_payable'); ?>
                                                (<?= html_escape($currency_symbol); ?>)
                                                : <?= html_escape($net_amount); ?></li>
                                            <li><?= translate('paid'); ?>
                                                (<?= html_escape($currency_symbol); ?>)
                                                : <?= html_escape($paid); ?></li>
                                            <li>
                                                <strong><?= translate('due'); ?>
                                                    (<?= html_escape($currency_symbol); ?>) : </strong>
                                                <?php
                                                $f = new NumberFormatter("en", NumberFormatter::SPELLOUT);
                                                echo html_escape($due_amount) . " </br>( " . ucwords($f->format($due_amount)) . " $currency )";
                                                ?>
                                            </li>
                                        <?php } ?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="row mt-xxlg">
                            <div class="col-xs-6">
                                <div class="text-left">
                                    <?= translate('prepared_by') . " - " . get_type_name_by_id('staff', $billing_data['prepared_by']); ?>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="auth-signatory">
                                    <?= translate('authorised_by'); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="text-right mr-lg hidden-print">
                        <button onClick="fn_printElem('bill_print')" class="btn btn-default ml-sm"><i
                                    class="fas fa-print"></i> <?= translate('print'); ?></button>
                    </div>
                </div>
            </div>
            <?php if ($paid > 1 && get_permission('billing_data_payment', 'is_view')): ?>
                <div class="tab-pane <?=($active_tab == 2 ? 'active' : ''); ?>" id="payment_history">
                    <div id="payment_print">
                        <div class="invoice">
                            <header class="clearfix">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="ib">
                                            <img src="<?= base_url('uploads/app_image/printing-logo.png'); ?>"
                                                 alt="techtune Img"/>
                                        </div>
                                    </div>
                                    <div class="col-md-6 text-right">
                                        <h4 class="mt-none mb-none text-dark">Bill No
                                            #<?= html_escape($billing_data['bill_no']); ?></h4>
                                        <p class="mb-none">
                                            <span class="text-dark"><?= translate('payment') . " " . translate('status'); ?> : </span>
                                            <span class="value">
											<?php
                                            $payment_a = array(
                                                '1' => translate('unpaid'),
                                                '2' => translate('partly_paid'),
                                                '3' => translate('total_paid')
                                            );
                                            echo($payment_a[$status]);
                                            ?>
										</span>
                                        </p>
                                        <p class="mb-none">
                                            <span class="text-dark"><?= translate('date'); ?> : </span> <span
                                                    class="value"><?= _d($billing_data['created_at']); ?></span>
                                        </p>
										<p class="mb-none">
                                        <span class="text-dark"><?= translate('due date'); ?> : </span>
										<span class="value"><?= _d($billing_data['due_date']); ?></span>
                                    </p>
                                    </div>
                                </div>
                            </header>
                            <div class="bill-info">
                                <div class="row">
                                    <div class="col-xs-6">
                                        <div class="bill-data">
                                            <p class="h5 mb-xs text-dark text-weight-semibold"><?= translate("Client"); ?>
                                                :</p>
                                            <address>
                                                <?php
                                                echo html_escape($billing_data['p_name']) . '<br>';
                                                echo translate('mobile_no') . ' : ' . $billing_data['p_mobileno'] . '<br>';
                                                echo html_escape($billing_data['p_address']);
                                                ?>
                                            </address>
                                        </div>
                                    </div>
                                    <div class="col-xs-6">
                                        <div class="bill-data text-right">
                                            <p class="h5 mb-xs text-dark text-weight-semibold"><?= translate("from"); ?>
                                                :</p>
                                            <address>
                                                <?php
                                                echo html_escape($global_config['institute_name']) . "<br/>";
                                                echo html_escape($global_config['address']) . "<br/>";
                                                echo html_escape($global_config['mobileno']) . "<br/>";
                                                echo html_escape($global_config['institute_email']) . "<br/>";
                                                ?>
                                            </address>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="table-responsive">
                                <table class="table invoice-items table-hover tbr-top mb-none">
                                    <thead>
                                    <tr class="text-dark">
                                        <th id="cell-id" class="text-weight-semibold">#</th>
                                        <th id="cell-item"
                                            class="text-weight-semibold"><?= translate("collect_by"); ?></th>
                                        <th id="cell-price"
                                            class="text-weight-semibold"><?= translate("pay_via"); ?></th>
                                        
                                        <th id="cell-qty"
                                            class="text-weight-semibold"><?= translate("paid_on"); ?></th>
                                        <th id="cell-total"
                                            class="text-center text-weight-semibold"><?= translate("amount"); ?></th>
										<th id="cell-desc"
                                            class="text-weight-semibold"><?= translate("remarks"); ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php
                                    $count = 1;
                                    foreach ($paymentHistory as $payment) {
                                        ?>
                                        <tr>
                                            <td><?= $count++; ?></td>
                                            <td class="text-weight-semibold text-dark"><?= html_escape($payment['collect_by']); ?></td>
                                            <td><?= html_escape($payment['pay_via']); ?></td>
                                            
                                            <td><?= html_escape(_d($payment['datetime'])); ?></td>
                                            <td class="text-center"><?= html_escape($currency_symbol . $payment['amount']); ?></td>
											<td><?= html_escape($payment['remarks']); ?></td>
                                        </tr>
                                    <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                            <div class="invoice-summary text-right author">
                                <div class="row">
                                    <div class="col-md-7 authorised">
                                        <div class="auth-signatory-sm">
                                            <?= translate('authorised_by'); ?>
                                        </div>
                                    </div>
                                    <div class="col-md-5 pull-right">
                                        <ul class="amounts">
                                            <li><?= translate('sub') . " " . translate('total'); ?>
                                                (<?= html_escape($currency_symbol); ?>)
                                                : <?= html_escape($total); ?></li>
                                            <li><?= translate('discount'); ?>
                                                (<?= html_escape($currency_symbol); ?>)
                                                : <?= html_escape($total_discount); ?></li>
                                            <li><?= translate('tax'); ?>
                                                (<?= html_escape($currency_symbol); ?>)
                                                : <?= html_escape($tax_amount); ?></li>
                                            <li><?= translate('net_payable'); ?>
                                                (<?= html_escape($currency_symbol); ?>)
                                                : <?= html_escape($net_amount); ?></li>
                                            <li><?= translate('paid'); ?>
                                                (<?= html_escape($currency_symbol); ?>)
                                                : <?= html_escape($paid); ?></li>
                                            <li>
                                                <strong><?= translate('due'); ?>
                                                    (<?= html_escape($currency_symbol); ?>) : </strong>
                                                <?php
                                                $f = new NumberFormatter("en", NumberFormatter::SPELLOUT);
                                                echo html_escape($due_amount) . ' </br>( ' . ucwords($f->format($due_amount)) . " $currency )";
                                                ?>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="text-right mr-lg hidden-print">
                            <button onClick="fn_printElem('payment_print')" class="btn btn-default"><i
                                        class="fas fa-print"></i> <?= translate('print'); ?></button>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
            <?php if ($status != 3 && get_permission('bill_payment', 'is_add')): ?>
                <!-- due collection form -->
                <div id="add_payment" class="tab-pane <?=($active_tab == 3 ? 'active' : ''); ?>">
                    <?= form_open(base_url('billing/bill_payment'), array('class' => 'form-horizontal form-bordered')); ?>
					 <input type="hidden" name="bill_id" value="<?= html_escape($billing_data['id']); ?>">
                    <input type="hidden" name="user_id" value="<?= html_escape($billing_data['user_id']); ?>">
                    <input type="hidden" name="assign_to" value="<?= html_escape($billing_data['assign_to']); ?>">
                    <div class="form-group">
                        <label class="col-md-3 control-label"><?= translate('paid_on'); ?> <span
                                    class="required">*</span></label>
                        <div class="col-md-6">
                            <input type="text" class="form-control" data-plugin-datepicker
                                   data-plugin-options='{"todayHighlight" : true}' name="paid_date"
                                   value="<?= date('Y-m-d'); ?>"/>
                            <span class="error"><?= form_error('paid_on'); ?></span>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-md-3 control-label"><?= translate('amount'); ?> <span class="required">*</span></label>
                        <div class="col-md-6">
                            <input type="number" class="form-control" name="payment_amount"
                                   value="<?= set_value('payment_amount', $due_amount); ?>"
                                   placeholder="<?= translate('enter_payment_amount'); ?>"/>
                            <span class="error"><?= form_error('payment_amount'); ?></span>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-md-3 control-label"><?= translate('pay_via'); ?> <span
                                    class="required">*</span></label>
                        <div class="col-md-6">
                            <?php
                            echo form_dropdown("pay_via", $payvia_list, set_value('pay_via'), "class='form-control' data-plugin-selectTwo data-width='100%'");
                            ?>
                            <span class="error"><?= form_error('pay_via'); ?></span>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-md-3 control-label"><?= translate('remarks'); ?></label>
                        <div class="col-md-6 mb-md">
                            <textarea name="remarks" rows="2" class="form-control"
                                      placeholder="<?= translate('write_your_remarks'); ?>"></textarea>
                        </div>
                    </div>
                    <footer class="panel-footer">
                        <div class="row">
                            <div class="col-md-offset-3 col-md-3">
                                <button class="btn btn-default"><?= translate('payment'); ?></button>
                            </div>
                        </div>
                    </footer>
                    <?= form_close(); ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</section>