<?php $currency_symbol = $global_config['currency_symbol']; ?>
<section class="panel">
    <header class="panel-heading">
        <h4 class="panel-title"> <?= translate('select_ground'); ?></h4>
    </header>
    <?= form_open(current_url(), ['method' => 'GET']); ?>
    <div class="panel-body">
        <div class="col-md-offset-3 col-md-6 mb-lg">
            <div class="form-group">
                <label class="control-label"><?= translate('date'); ?> <span class="required">*</span></label>
                <div class="input-group">
                    <span class="input-group-addon"><i class="fas fa-calendar-check"></i></span>
                    <input type="text" class="form-control daterange" name="daterange"
                           value="<?= set_value('daterange', date("Y/m/d") . ' - ' . date("Y/m/d")); ?>"
                           required/>
                </div>
            </div>
        </div>
    </div>
    <footer class="panel-footer">
        <div class="row">
            <div class="col-md-offset-10 col-md-2">
                <button type="submit" name="search" value="1" class="btn btn btn-default btn-block"><i
                            class="fas fa-filter"></i> <?= translate('filter'); ?></button>
            </div>
        </div>
    </footer>
    <?= form_close(); ?>
</section>
<section class="panel">
    <header class="panel-heading">
        <h4 class="panel-title"><i
                    class="fas fa-list-ol"></i> <?= translate('bill') . " " . translate('list'); ?>
        </h4>
    </header>
    <div class="panel-body">
        <div class="export_title">Bill Summary</div>
        <table class="table table-bordered table-hover table-condensed" cellspacing="0" width="100%" id="table-export">
            <thead>
            <tr>
                <th><?= translate('sl'); ?></th>
                <th><?= translate('bill_no'); ?></th>
                <th><?= translate('client') . " " . translate('name'); ?></th>
                <th><?= translate('Assign') . " " . translate('to'); ?></th>
                <th><?= translate('due') . " " . translate('date'); ?></th>
                <th><?= translate('payment') . " " . translate('status'); ?></th>
                <th><?= translate('net') . " " . translate('payable'); ?></th>
                <th><?= translate('paid'); ?></th>
                <th><?= translate('due'); ?></th>
                <th><?= translate('bill date'); ?></th>
                <th class="min-w-sm"><?= translate('action'); ?></th>
            </tr>
            </thead>
            <tbody>
            <?php $count = 1; ?>
            <?php if (!empty($bills)): ?>
                <?php foreach ($bills as $bill): ?>
                    <tr>
                        <td><?= $count++; ?></td>
                        <td><?= html_escape($bill['bill_no']); ?></td>
                        <td><?= html_escape($bill['staff_name'] . " - " . $bill['staff_id']); ?></td>
                        <td><?= html_escape($bill['assigned_name']); ?></td>
                        <td><?= html_escape(_d($bill['due_date'])); ?></td>
                        <td>
                            <?php
                            $labelMode = "";
                            $status = $bill['status'];
                            if ($status == 1) {
                                $status = translate('unpaid');
                                $labelMode = 'label-danger-custom';
                            } elseif ($status == 2) {
                                $status = translate('partly_paid');
                                $labelMode = 'label-info-custom';
                            } elseif ($status == 3 || $bill['total_due'] == 0) {
                                $status = translate('total_paid');
                                $labelMode = 'label-success-custom';
                            }
                            echo "<span class='label " . $labelMode . "'>" . $status . "</span>";
                            ?>
                        </td>
                        <td><?= html_escape($currency_symbol . number_format($bill['net_amount'], 2, '.', '')); ?></td>
                        <td><?= html_escape($currency_symbol . number_format($bill['paid'], 2, '.', '')); ?></td>
                        <td><?= html_escape($currency_symbol . number_format($bill['due'], 2, '.', '')); ?></td>
                        <td><?= html_escape(_d($bill['date'])); ?></td>
                        <td class="min-w-c">
                            <a href="<?= base_url('billing/invoice/' . html_escape($bill['id']) . "/" . html_escape($bill['hash'])); ?>"
                               class="btn btn-circle btn-default"> <i class="fas fa-eye"></i>
                                <?= translate('invoice'); ?>
                            </a>

                            <?php if (get_permission('billing', 'is_delete')): ?>
                                <?= btn_delete('billing/bill_delete/' . html_escape($bill['id'])); ?>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php endif; ?>
            </tbody>
        </table>
    </div>
</section>

