<script src="https://code.jquery.com/jquery.js"></script>
<?php $currency_symbol = $global_config['currency_symbol']; ?>
<?php if (loggedin_role_id() != ROLE_CUSTOMER_ID) : ?>
    <section class="panel-group" id="accordion">
        <div class="panel panel-accordion">
            <div class="panel-heading">
                <h4 class="panel-title">
                    <a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion"
                        href="#client_filter_field"><?php echo translate('Select Grounds For Filter'); ?></a>
                </h4>
            </div>

            <div id="client_filter_field"
                class="accordion-body collapse <?= $this->session->flashdata('active_box') == 1 ? 'in' : '' ?>">
                <?= form_open(current_url()); ?>
                <div class="panel-body">
                    <!-- daterange -->
                    <div class="col-md-3 mb-lg">
                        <div class="form-group">
                            <label class="control-label"><?php echo translate('date'); ?> <span class="required"></span></label>
                            <div class="input-group">
                                <span class="input-group-addon"><i class="fas fa-calendar-check"></i></span>
                                <input type="text" class="form-control daterange" name="daterange" id="daterange"
                                    value="<?= set_value('daterange', date("Y/m/1") . ' - ' . date("Y/m/d")); ?>" />
                            </div>
                        </div>
                    </div>

                    <div class="col-md-3 mb-lg">
                        <div class="form-group ">
                            <label for="payment_status" class="control-label">
                                <?= translate('payment_status') ?>
                            </label>
                            <div class="input-group">
                                <span class="input-group-addon"><i class="fas fa-users"></i></span>
                                <select class="form-control" data-plugin-selectTwo data-width="100%"
                                    name="payment_status"
                                    id="payment_status">
                                    <?php /** @var array<array> $nasList */ ?>
                                    <?php if (empty($payment_status)): ?>
                                        <option value=""><?= translate('No payment status found'); ?></option>
                                    <?php else: ?>
                                        <option value=""><?= translate('Select a payment status') ?></option>
                                        <?php foreach ($payment_status as $key => $value): ?>
                                            <option value="<?= $key ?>" <?= set_select('payment_status', $key) ?>>
                                                <?= html_escape($value) ?>
                                            </option>
                                        <?php endforeach; ?>
                                    <?php endif; ?>

                                </select>
                                <span class="error"><?= form_error('reseller_subreseller_id'); ?></span>
                            </div>
                        </div>
                    </div>

                    <!-- reseller sebreseller -->
                    <?php if (in_array(loggedin_role_id(), [ROLE_ADMIN_ID, ROLE_RESELLER_ID])) : ?>
                        <div class="col-md-3 mb-lg">
                            <div class="form-group <?= form_error('reseller_subreseller_id') ? 'has-error' : null ?>">
                                <label for="reseller_subreseller_id" class="control-label">
                                    <?php
                                    if (loggedin_role_id() == 1) {
                                        echo translate('Reseller_list');
                                    } elseif (loggedin_role_id() == 2) {
                                        echo translate('Sub_Reseller_list');
                                    }
                                    ?>
                                    <span class="required"></span>
                                </label>
                                <div class="input-group">
                                    <span class="input-group-addon"><i class="fas fa-users"></i></span>
                                    <select class="form-control" data-plugin-selectTwo data-width="100%"
                                        name="reseller_subreseller_id"
                                        id="reseller_subreseller_id">
                                        <?php /** @var array<array> $nasList */ ?>
                                        <?php if (empty($reseller_subreseller_list)): ?>
                                            <option value=""><?= translate('No Resellers Found'); ?></option>
                                        <?php else: ?>
                                            <option value=""><?= translate('Select A Reseller') ?></option>
                                            <?php foreach ($reseller_subreseller_list as $reseller_subreseller): ?>
                                                <option value="<?= $reseller_subreseller->id ?>" <?= set_select('reseller_subreseller_id', $reseller_subreseller->id) ?>>
                                                    <?= html_escape($reseller_subreseller->name) ?>
                                                </option>
                                            <?php endforeach; ?>
                                        <?php endif; ?>

                                    </select>
                                    <span class="error"><?= form_error('reseller_subreseller_id'); ?></span>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    <div class="col-md-3 mb-lg">
                        <div class="form-group ">

                            <label for="zone_list" class="control-label">
                                <?= translate('zone_list') ?>
                            </label>
                            <div class="input-group">
                                <span class="input-group-addon"><i class="fas fa-map-marker-alt"></i></span>
                                <select class="form-control" data-plugin-selectTwo data-width="100%"
                                    name="zone_id"
                                    id="zone_id">
                                    <?php /** @var array<array> $nasList */ ?>
                                    <?php if (empty($zones_list)): ?>
                                        <option value=""><?= translate('No Zone Found'); ?></option>
                                    <?php else: ?>
                                        <option value=""><?= translate('Select A Zone') ?></option>
                                        <?php foreach ($zones_list as $zones_list): ?>
                                            <option value="<?= $zones_list->id ?>" <?= set_select('zones_list', $zones_list->id) ?>>
                                                <?= html_escape($zones_list->name) ?>
                                            </option>
                                        <?php endforeach; ?>
                                    <?php endif; ?>

                                </select>
                                <span class="error"><?= form_error('zone_id'); ?></span>
                            </div>
                        </div>
                    </div>
               
                    <footer class="panel-footer">
                        <div class="row">
                            <div class="col-md-offset-10 col-md-2">
                                <button type="button" name="btn-filter" id="btn-filter" value="1"
                                    class="btn btn btn-default btn-block"><i
                                        class="fas fa-filter"></i> <?php echo translate('filter'); ?></button>
                            </div>
                        </div>
                    </footer>
                    <?= form_close(); ?>
                </div>
            </div>
    </section>
<?php endif ?>

<section class="panel">
    <header class="panel-heading">
        <h4 class="panel-title"><i
                class="fas fa-list-ol"></i> <?= translate('bill') . " " . translate('list'); ?>
        </h4>
    </header>
    <div class="panel-body">
        <div class="row">
            <div class="col-md-12">
                <div class="table-responsive mb-sm mt-xs">
                    <?php $this->datatables->generate('dt_authors'); ?>
                </div>
            </div>
        </div>
    </div>
</section>

<script>
    $("#btn-filter").click(() => erTable_dt_authors.ajax.reload());
</script>
<!-- Jquery Datatables JS -->
<script src="<?php echo base_url('assets/vendor/datatables/media/js/jquery.dataTables.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/vendor/datatables/media/js/dataTables.bootstrap.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/vendor/datatables/extras/TableTools/Buttons-1.4.2/js/dataTables.buttons.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/vendor/datatables/extras/TableTools/Buttons-1.4.2/js/buttons.bootstrap.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/vendor/datatables/extras/TableTools/Buttons-1.4.2/js/buttons.html5.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/vendor/datatables/extras/TableTools/Buttons-1.4.2/js/buttons.print.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/vendor/datatables/extras/TableTools/Buttons-1.4.2/js/buttons.colVis.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/vendor/datatables/extras/TableTools/JSZip-2.5.0/jszip.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/vendor/datatables/extras/TableTools/pdfmake-0.1.32/pdfmake.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/vendor/datatables/extras/TableTools/pdfmake-0.1.32/vfs_fonts.js'); ?>"></script>
<?php $this->datatables->jquery('dt_authors'); ?>