<div class="row">

    <!-- bill Category Create/Edit -->
    <div class="col-md-5">
        <section class="panel">
            <header class="panel-heading">
                <h4 class="panel-title">
                    <i class="far fa-edit"></i>
                    <?php if (isset($billCategory)): ?>
                        <?= translate('Edit Bill Category') ?>
                    <?php else: ?>
                        <?= translate('Create Bill Category') ?>
                    <?php endif; ?>
                </h4>
            </header>
            <?= form_open(current_url()); ?>
            <div class="panel-body">

                <!-- Category Name  -->
                <div class="form-group">
                    <label for="name" class="control-label">
                        <?= translate('Name') ?>
                        <span class="required">*</span>
                    </label>
                    <input type="text" class="form-control" id="name" name="name"
                           value="<?= isset($billCategory) ? $billCategory->name : '' ?>" required/>
                    <span class="text-danger"><?= form_error('name') ?></span>
                </div>

            </div>
            <footer class="panel-footer">
                <div class="row">
                    <div class="col-md-12">
                        <?php if (isset($billCategory)):?>
                        <a href="<?= base_url('bill_category') ?>" class="btn btn-default pull-left">
                            <i class="fas fa-arrow-left"></i>
                            <?= translate('Back') ?>
                        </a>
                        <?php endif;?>
                        <button type="submit" class="btn btn-default pull-right">
                            <i class="fas fa-plus-circle"></i>
                            <?= isset($billCategory) ? translate('Update') : translate('Save') ?>
                        </button>
                    </div>
                </div>
            </footer>
            <?= form_close(); ?>
        </section>
    </div>

    <!-- bill Category List -->
    <div class="col-md-7">
        <section class="panel">
            <header class="panel-heading">
                <h4 class="panel-title"><i class="fas fa-list-ul"></i> <?= translate('bill Categories'); ?>
                </h4>
            </header>
            <div class="panel-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-hover table-condensed mb-none">
                        <thead>
                        <tr>
                            <th><?= translate('sl') ?></th>
                            <th><?= translate('name') ?></th>
                            <th><?= translate('action') ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php if (!empty($billCategories)) : ?>
                            <?php foreach ($billCategories as $index => $category) : ?>
                                <tr>
                                    <td><?= $index + 1 ?></td>
                                    <td><?= $category->name ?></td>
                                    <td>
                                        <a href="<?= base_url('bill_category/edit/' . $category->id) ?>"
                                           class="btn btn-xs btn-primary">
                                            <i class="far fa-edit"></i>
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </section>
    </div>
</div>