<!doctype html>
<html lang="en">

<head>
    <!-- Required meta tags -->

    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="keywords" content="">
    <meta name="author" content="techtune">
    <meta name="description" content="">
    <title><?php echo translate('login'); ?></title>
    <link rel="shortcut icon" href="<?php echo base_url('uploads/app_image/logo.png'); ?>">


    <link href="https://fonts.googleapis.com/css?family=Roboto:300,400&display=swap" rel="stylesheet">

    <link rel="stylesheet" href="<?php echo base_url('assets/login/fonts/icomoon/style.css'); ?>">

    <link rel="stylesheet" href="<?php echo base_url('assets/login/css/owl.carousel.min.css'); ?>">

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="<?php echo base_url('assets/login/css/bootstrap.min.css'); ?>">

    <!-- Sweetalert js/css -->
    <link rel="stylesheet" href="<?php echo base_url('assets/vendor/sweetalert/sweetalert-custom.css'); ?>">
    <script src="<?php echo base_url('assets/vendor/sweetalert/sweetalert.min.js'); ?>"></script>

    <!-- Style -->
    <link rel="stylesheet" href="css/style.css">

    <!-- Web Fonts  -->
    <link rel="stylesheet" href="<?php echo base_url('assets/vendor/bootstrap/css/bootstrap.css'); ?>">
    <link rel="stylesheet" href="<?php echo base_url('assets/vendor/font-awesome/css/all.min.css'); ?>">

    <script type="text/javascript">
        var base_url = '<?php echo base_url() ?>';
    </script>


    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">

</head>

<body>

    <div class="auth-main">
        <div class="content">

            <div class="container">

                <div class="wrapper">

                    <div class="logo">
                        <img src="<?php echo base_url('uploads/app_image/login.png'); ?>" alt="">
                    </div>
                    <div class="text-center mt-4 name">
                        <h3><?php echo html_escape($global_config['institute_name']); ?></h3>
                    </div>

                    <?php echo form_open($this->uri->uri_string()); ?>
                    <div class="form-group <?php if (form_error('username')) echo 'has-error'; ?>">
                        <label for="username">Username</label>
                        <div class="input-group input-group-icon">
                            <span class="input-group-addon">
                                <span class="icon">
                                    <i class="fas fa-user" style="color:rgb(90,86,235);"></i>
                                </span>
                            </span>
                            <input type="text" class="form-control" name="username" id="username" value="<?php echo set_value('username'); ?>" placeholder="<?php echo translate('username'); ?>" />
                        </div>
                        <span class="error"><?php echo form_error('username'); ?></span>
                    </div>
                    <div class="form-group <?php if (form_error('password')) echo 'has-error'; ?>">
                        <label for="password">Password</label>
                        <div class="input-group input-group-icon">
                            <span class="input-group-addon">
                                <span class="icon"><i class="fas fa-unlock-alt" style="color: rgb(90,86,235);"></i></span>
                            </span>
                            <input type="password" class="form-control input-rounded" name="password" value="" id="password" placeholder="<?php echo translate('password'); ?>" />
                        </div>
                        <span class="error"><?php echo form_error('password'); ?></span>
                    </div>
                    <div class="d-flex mb-5 align-items-center">
                        <label class="i-checks"><input type="checkbox" name="remember" id="remember"><i></i> <?php echo translate('remember me'); ?></label>
                        <div class="control__indicator"></div>
                        </label>
                        <span class="ml-auto"><a href="<?php echo base_url('authentication/forgot'); ?>" class="forgot-pass"><?php echo translate('Forgot Password?'); ?></a></span>
                    </div>
                    <div class="form-group">
                        <button type="submit" id="btn_submit" class="btn btn-block btn-primary">
                            <?php echo translate('log in'); ?> <i class="fa fa-sign-in"></i>
                        </button>
                    </div>
                    <!-- Bottom Curve -->

                    <?php echo form_close(); ?>
                
                </div>

            </div>
        </div>

    </div>



    <style>
        body {
            background: linear-gradient(135deg,rgb(224, 231, 247),rgb(208, 222, 242));
            min-height: 100vh;
            margin: 0;
            display: flex;
            align-items: center;
            justify-content: center;
            font-family: 'Segoe UI', sans-serif;
        }

        .auth-main {
            width: 100%;
        }

        .custom-top-curve,
        .custom-bottom-curve {
            width: 100%;
            overflow: hidden;
            line-height: 0;
        }

        .custom-top-curve svg,
        .custom-bottom-curve svg {
            display: block;
            width: 100%;
            height: 120px;
        }

        .wrapper {
            max-width: 420px;
            width: 100%;
            padding: 40px 30px;
            margin: 80px auto;
            background: #ffffff;
            border-radius: 16px;
            box-shadow: 0 8px 25px rgba(0, 128, 0, 0.15);
            transition: transform 0.3s ease;
        }


        .logo {
            width: 80px;
            margin: 0 auto 20px;
        }

        .logo img {
            width: 100%;
            height: 66px;
            object-fit: cover;
            border-radius: 5%;
            border: 3px solid #a4a1ff;
            box-shadow: 0 0 10px rgba(102, 187, 106, 0.4);
        }

        .wrapper .name {
            text-align: center;
            font-size: 1.6rem;
            font-weight: bold;
            color: #5a56eb;
            margin-bottom: 30px;
        }

        .wrapper .form-field {
            margin-bottom: 20px;
            border: 1px solidrgb(200, 201, 230);
            border-radius: 12px;
            display: flex;
            align-items: center;
            padding-left: 12px;
            background: #f9fefb;
        }

        .wrapper .form-field input {
            flex: 1;
            padding: 10px 15px;
            border: none;
            background: transparent;
            outline: none;
            color: #333;
            font-size: 1rem;
        }

        .wrapper .form-field .fas {
            color: #5a56eb;
        }

        .wrapper .btn {
            width: 100px;
            /* Set button width */
            height: 40px;
            background-color: #5a56eb;
            color: #fff;
            border: none;
            border-radius: 25px;
            box-shadow: 0 4px 12px rgba(67, 89, 160, 0.4);
            cursor: pointer;
            transition: background-color 0.3s ease;

            display: block;
            /* Makes centering possible */
            margin: 0 auto;
            /* Center horizontally */
            text-align: center;
        }

        .wrapper .btn:hover {
            background-color: #5a56eb;
        }

        .wrapper a {
            display: block;
            margin-top: 15px;
            text-align: center;
            color: #5a56eb;
            text-decoration: none;
            font-size: 0.9rem;
        }

        .wrapper a:hover {
            text-decoration: underline;
        }

        @media (max-width: 400px) {
            .wrapper {
                margin: 40px 15px;
                padding: 30px 20px;
            }
        }
    </style>
    <script src="<?php echo base_url('assets/login/js/jquery-3.3.1.min.js'); ?>"></script>
    <script src="<?php echo base_url('assets/login/js/popper.min.js'); ?>"></script>
    <script src="<?php echo base_url('assets/login/js/bootstrap.min.js'); ?>"></script>
    <script src="<?php echo base_url('assets/login/css/js/main.js'); ?>"></script>

    <?php
    $alertclass = "";
    if ($this->session->flashdata('alert-message-success')) {
        $alertclass = "success";
    } else if ($this->session->flashdata('alert-message-error')) {
        $alertclass = "error";
    } else if ($this->session->flashdata('alert-message-info')) {
        $alertclass = "info";
    }
    if ($alertclass != ''):
        $alert_message = $this->session->flashdata('alert-message-' . $alertclass);
    ?>
        <script type="text/javascript">
            swal({
                toast: true,
                position: 'top-end',
                type: '<?php echo $alertclass; ?>',
                title: '<?php echo $alert_message; ?>',
                confirmButtonClass: 'btn btn-default',
                buttonsStyling: false,
                timer: 8000
            })
        </script>
    <?php endif; ?>

</body>

</html>