<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Zone_model extends Base_Model
{
    protected $returnType = 'object';
    protected $useTimestamps = true;
    protected $useSoftDelete = true;

    protected $allowedFields = [
        'name',
        'manager_id',
    ];

    public function findAll()
    {
        return $this->db->select('zones.*, staff.name as manager_name')
            ->join('staff', 'staff.id = zones.manager_id', 'left')
            ->from('zones')
            ->where('zones.deleted_at', null)
            ->order_by('zones.id', 'desc')
            ->get()->result();
    }
	public function get_zone_list_individual($RoleID='' ,$userID='')
    {
		$this->db->select('zones.*, staff.name as manager_name');
        $this->db->from('zones');
        $this->db->join('staff', 'staff.id = zones.manager_id', 'left');
		///For Reseller zones
		if (in_array($RoleID, array(2, 3, 4)) && isset($userID) && !empty($userID) && $userID!=1) {
            $this->db->where('zones.manager_id', $userID);
		}
		///For All zones
		if (!in_array($RoleID, array(2, 3, 4)) && isset($userID) && !empty($userID) && $userID!=1) {
            $this->db->where('zones.manager_id', $userID);
		}
        return $this->db->get()->result();
    }

    public function get_zone_list_individual_array($RoleID='' ,$userID='')
    {
        $this->db->select('zones.*, staff.name as manager_name');
        $this->db->from('zones');
        $this->db->join('staff', 'staff.id = zones.manager_id', 'left');
        ///For Reseller zones
        if (in_array($RoleID, array(2, 3, 4)) && isset($userID) && !empty($userID) && $userID!=1) {
            $this->db->where('zones.manager_id', $userID);
        }
        ///For All zones
        if (!in_array($RoleID, array(2, 3, 4)) && isset($userID) && !empty($userID) && $userID!=1) {
            $this->db->where('zones.manager_id', $userID);
        }
        return $this->db->get()->result_array();
    }

    public function whereManagerId(int $id)
    {
        if (in_array(loggedin_role_id(), [ROLE_RESELLER_ID, ROLE_SUBRESELLER_ID])){
            $this->db->where('manager_id', $id);
        }
        return $this;
    }
}