<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Voice_model extends MY_Model
{
    public function __construct()
    {
        parent::__construct();
    }
	
	 public function get_contact_list($user_id, $contact_id='')
    {
        $this->db->select('*');
        $this->db->from('contact_list');
		if ($user_id!=1) {
			$this->db->where('assigned_to', $user_id);
		}
		
		if (isset($contact_id) && !empty($contact_id)) {
            $this->db->where('id', $contact_id);
		}
		
        return $this->db->get()->result_array();
    }
	
	public function get_schedule_campaign_list($user_id, $campaign_id='')
    {
        $this->db->select('vb_schedule_play.*,staff.name as staff_name');
        $this->db->from('vb_schedule_play');
		$this->db->join('staff', 'vb_schedule_play.assigned_to = staff.id', 'left');
		
		if ($user_id!=1) {
			$this->db->where('vb_schedule_play.assigned_to', $user_id);
		}
		if (isset($campaign_id) && !empty($campaign_id)) {
            $this->db->where('vb_schedule_play.id', $campaign_id);
		}
		 $this->db->order_by('vb_schedule_play.id', 'DESC');
        return $this->db->get()->result_array();
    }
	
	public function get_campaign_config( $campaign_id='')
    {
        $this->db->select('*');
        $this->db->from('campaign_config');
		if (isset($campaign_id) && !empty($campaign_id)) {
            $this->db->where('campaign_id', $campaign_id);
		}
        return $this->db->get()->result_array();
    }
	
	
	public function get_quick_call_list($user_id, $qc_id='')
    {
        $this->db->select('*');
        $this->db->from('vb_quick_play');
		$this->db->where('assigned_to', $user_id);
		if (isset($qc_id) && !empty($qc_id)) {
            $this->db->where('id', $qc_id);
		}
		$this->db->order_by('id', 'DESC');
        return $this->db->get()->result_array();
    }
	
	public function contact_call_groups($user_id)
    {
        $this->db->select('group_name');
        $this->db->from('contact_list');
		if ($user_id!=1) {
			$this->db->where('assigned_to', $user_id);
		}
		
		$this->db->group_by('group_name');
        return $this->db->get()->result_array();
    }
	
	public function get_contact_count_by_group()
    {
        $this->db->select('group_name, count(*) as contact_count');
        $this->db->from('contact_list');
		$this->db->group_by('group_name');
        return $this->db->get()->result_array();
    }
	
	
	
	
	
	public function update_contact($data)
	{
		$insert_data = array(
            'last_modified' => $data['last_modified'],
            'assigned_to' => $data['user_id'],
            'name' => $data['name'],
			'phone' => $data['phone'],
			'email' => $data['email'],
			'address' => $data['address'],
			'group_name' => $data['group_name']
        );
		
		$this->db->where('id', $data['contact_id']);
        $this->db->update('contact_list', $insert_data);
		return true;
	}
	
	
	public function save_schedule_campaign($data)
	{
        if ($data['user_id']==1){
            $assigned_customer = $data['assigned_customer'];
        }
        else{
            $assigned_customer = $data['user_id'];
        }

		$insert_data = array(
            'date_time' => $data['datetime'],
            'assigned_to' => $assigned_customer,
            'name' => $data['campaign_name'],
			'call_group' => $data['group_list'],
			'trunk_id' => $data['trunk_id'],
			'caller_id' => $data['caller_id'],
			'campaign_type' => $data['campaign_type'],
			'fixed_channels' => $data['fixed_channels'],
			'date' => $data['schedule_date'],
			'start_time' => $data['start_time'],
			'end_time' => $data['end_time'],
			'status' => $data['status'],
			'remarks' => $data['remarks']
        );
		
		
		$update_data = array(
            'name' => $data['campaign_name'],
			'trunk_id' => $data['trunk_id'],
			'caller_id' => $data['caller_id'],
			'campaign_type' => $data['campaign_type'],
			'fixed_channels' => $data['fixed_channels'],
			'date' => $data['schedule_date'],
			'start_time' => $data['start_time'],
			'end_time' => $data['end_time'],
			'status' => $data['status'],
			'remarks' => $data['remarks']
        );
		
		
		if (isset($data['campaign_id']) && !empty($data['campaign_id'])) {
            $this->db->where('id', $data['campaign_id']);
            $this->db->update('vb_schedule_play', $update_data);
        } else {
            $this->db->insert('vb_schedule_play', $insert_data);
            return $this->db->insert_id();
        }
	}
	
	
	public function update_vb_schedule_status($campaign_id,$data_remarks = '')
	{
		$insert_data = array(
			'status' => 'Active',
			'remarks' => $data_remarks
			
        );
		
		$this->db->where('id', $campaign_id);
        $this->db->update('vb_schedule_play', $insert_data);
		return true;
	}
	
	
	
	
public function save_campaign_data($camp_data, $data_id)
{
    $l1_type = $camp_data['firstDropdown'];
    if ($l1_type == 'transfer_call') {
        $l1_value = $camp_data['layer_1_transfer'];
    } elseif ($l1_type == 'tts_play') {
        $l1_value = $camp_data['layer_1_tts'];
    } elseif ($l1_type == 'audio_play') {
        $l1_value = $camp_data['layer_1_voice'];
    } elseif ($l1_type == 'press1') {
        $l1_value = 'press1';
		
		$questions = array();
		
		////////////questions//////////////
		
		for ($i = 1; $i <= 10; $i++) {
			$key = "qsn_{$i}_key";
			$value = "qsn_{$i}_value";
			$sound = "qsn_{$i}_sound";
			$tts = "qsn_{$i}_tts";

			// Check if qsn_x_key is not 'na' before adding to the new array
			if (isset($camp_data[$key]) && $camp_data[$key] !== 'na') {
				$destination = ($camp_data[$key] === 'tts') ? $camp_data[$tts] : $camp_data[$sound];
				
				
				if($camp_data[$key]=='audio'){
					$destination_value = preg_replace('/\.[^.]+$/', "", $destination);
					
					$questions[] = array(
					"qsn_key" => $camp_data[$key],
					"qsn_value" => $destination_value
					);
					
				}
				else{
					
					$questions[] = array(
					"qsn_key" => $camp_data[$key],
					"qsn_value" => $destination
					);
					
				}

			}
		}	
		
		////////////questions//////////////

        // for machine
        $for_machine_key = isset($camp_data['layer_2_machine_key']) ? $camp_data['layer_2_machine_key'] : '';
        $for_machine_value = '';

        if ($for_machine_key == 'audio_play') {
            $for_machine_value = isset($camp_data['layer_2_machine_value_sound']) ? $camp_data['layer_2_machine_value_sound'] : '';
        } elseif ($for_machine_key == 'tts_play') {
            $for_machine_value = isset($camp_data['layer_2_machine_value_tts']) ? $camp_data['layer_2_machine_value_tts'] : '';
        } elseif ($for_machine_key == 'transfer_to') {
            $for_machine_value = isset($camp_data['layer_2_machine_value']) ? $camp_data['layer_2_machine_value'] : '';
        }

        // for human
        $for_human_key = isset($camp_data['layer_2_human_key']) ? $camp_data['layer_2_human_key'] : '';
        $for_human_value = '';

        if ($for_human_key == 'audio_play') {
            $for_human_value = isset($camp_data['layer_2_human_value_sound']) ? $camp_data['layer_2_human_value_sound'] : '';
        } elseif ($for_human_key == 'tts_play') {
            $for_human_value = isset($camp_data['layer_2_human_value_tts']) ? $camp_data['layer_2_human_value_tts'] : '';
        } elseif ($for_human_key == 'transfer_to') {
            $for_human_value = isset($camp_data['layer_2_human_value']) ? $camp_data['layer_2_human_value'] : '';
        }
    }
	elseif ($l1_type == 'advanced_campaign') {
		$l1_value = 'advanced_campaign';
		
		
		
		$stt_questions = array();
		
		////////////stt_questions//////////////
		
		for ($i = 1; $i <= 10; $i++) {
			$key = "advanced_action_{$i}_key";
			$value = "advanced_action_{$i}_value";
			$sound = "advanced_action_{$i}_sound";
			$tts = "advanced_action_{$i}_tts";

			// Check if qsn_x_key is not 'na' before adding to the new array
			if (isset($camp_data[$key]) && $camp_data[$key] !== 'na') {
				$destination = ($camp_data[$key] === 'tts') ? $camp_data[$tts] : $camp_data[$sound];

				if($camp_data[$key]=='audio'){
					$destination_value = preg_replace('/\.[^.]+$/', "", $destination);
					
					$stt_questions[] = array(
					"advanced_action_key" => $camp_data[$key],
					"advanced_action_value" => $destination_value
					);
					
				}
				else{
					
					$stt_questions[] = array(
					"advanced_action_key" => $camp_data[$key],
					"advanced_action_value" => $destination
					);
					
				}
				
				
			}
		}	
		
		////////////stt_questions//////////////
		
		
		
		
		$for_advanced_stt_key = isset($camp_data['advanced_stt_key']) ? $camp_data['advanced_stt_key'] : '';
        $for_advanced_stt_value = '';
		
		if ($for_advanced_stt_key == 'audio_play') {
            $for_advanced_stt_value = isset($camp_data['advanced_stt_value_sound']) ? $camp_data['advanced_stt_value_sound'] : '';
        } elseif ($for_advanced_stt_key == 'tts_play') {
            $for_advanced_stt_value = isset($camp_data['advanced_stt_value_tts']) ? $camp_data['advanced_stt_value_tts'] : '';
        }
	}

    $insert_data = array(
        'date_time' => date('Y-m-d H:i:s'),
        'campaign_id' => $camp_data['id'],
        'l1_type' => $l1_type,
        'l1_value' => $l1_value,
        'layer_2_machine_key' => $for_machine_key,
        'layer_2_machine_value' => $for_machine_value,
        'layer_2_human_key' => $for_human_key,
        'layer_2_human_value' => $for_human_value,
        'advanced_stt_key' => $for_advanced_stt_key,
        'advanced_stt_value' => $for_advanced_stt_value,
		'camp_press1_data' => json_encode($questions),
		'camp_stt_data' => json_encode($stt_questions)
    );

    for ($i = 0; $i <= 9; $i++) {
        $pressKey = "press_" . $i . "_key";
        $pressValue = "press_" . $i . "_value";

        $insert_data[$pressKey] = isset($camp_data[$pressKey]) ? $camp_data[$pressKey] : '';

        if ($camp_data[$pressKey] == 'transfer_to') {
            $valueKey = "press_" . $i . "_value";
            $insert_data[$pressValue] = isset($camp_data[$valueKey]) ? $camp_data[$valueKey] : '';
        } elseif ($camp_data[$pressKey] == 'tts') {
            $insert_data[$pressValue] = isset($camp_data["press_" . $i . "_tts"]) ? $camp_data["press_" . $i . "_tts"] : '';
        } elseif ($camp_data[$pressKey] == 'audio') {
            $insert_data[$pressValue] = isset($camp_data["press_" . $i . "_sound"]) ? $camp_data["press_" . $i . "_sound"] : '';
        } else {
            $insert_data[$pressValue] = ''; // Default value if none of the conditions match
        }
    }

    $check_campaign_config_available = $this->check_campaign_config($data_id);

    if ($check_campaign_config_available == 1) {
        $this->db->where('campaign_id', $data_id);
        $this->db->update('campaign_config', $insert_data);
    } else {
        $this->db->insert('campaign_config', $insert_data);
        return $this->db->insert_id();
    }
}

	
	
	public function check_campaign_config($data_id)
	{
		$this->db->select('*');
		$this->db->from('campaign_config');
		$this->db->where('campaign_id', $data_id);
		
		$result = $this->db->get();

		// Check if there are any rows in the result set
		if ($result->num_rows() > 0) {
			return 1; // Data exists
		} else {
			return 0; // Data does not exist
		}
	}

	
	
	public function save_quick_play($data)
	{
		$play_type = $data['firstDropdown'];
		if ($play_type=='sound'){$play=$data['soundFile'] ?? '';}
		else {$play=$data['ttsFile'] ?? '';}
		
		
		$insert_data = array(
            'date_time' => $data['datetime'],
            'assigned_to' => $data['user_id'],
            'call_to' => $data['call_to'],
			'caller_id' => $data['caller_id'],
			'trunk_id' => $data['trunk'],
			'play_type' => $play_type,
			'play' => $play,
			'status' => $data['status']
        );
		
		if (isset($data['qc_id']) && !empty($data['qc_id'])) {
            $this->db->where('id', $data['qc_id']);
            $this->db->update('vb_quick_play', $insert_data);
        } else {
            $this->db->insert('vb_quick_play', $insert_data);
            return $this->db->insert_id();
        }
	}
	
	
	public function get_trunk_list($user_id='',$admin_id='')
    {
        $this->db->select('vb_trunks.*,staff.name as staff_name');
        $this->db->from('vb_trunks');
		$this->db->join('staff', 'vb_trunks.assign_to = staff.id', 'left');
		if (isset($admin_id) && !empty($admin_id) && $user_id!=1) {
			$this->db->where('vb_trunks.assign_to', $admin_id);
		}
        return $this->db->get()->result_array();
    }

	public function get_callerid_list($callerid_id='',$userID='',$admin_id='')
    {
        $this->db->select('vb_callerid.*,vb_trunks.trunk_name,vb_trunks.assign_to as trunk_assign');
        $this->db->from('vb_callerid');
		$this->db->join('vb_trunks', 'vb_callerid.trunk_id = vb_trunks.id', 'left');
		
		if (isset($admin_id) && !empty($admin_id) && $userID!=1) {
			$this->db->where('vb_trunks.assign_to', $admin_id);
			$this->db->or_where('vb_callerid.assign_to', $userID);
		}
		
		
		if (isset($callerid_id) && !empty($callerid_id)) {
            $this->db->where('vb_callerid.id', $callerid_id);
		}
        return $this->db->get()->result_array();
    }
	
	
	
	public function get_tts_list($user_id, $tts_id='')
    {
        $this->db->select('vb_tts.*,staff.name as staff_name');
		$this->db->from('vb_tts');
		$this->db->join('staff', 'vb_tts.assign_to = staff.id', 'left');
		if (isset($user_id) && !empty($user_id) && $user_id!=1) {
			$this->db->where('staff.assign_to', $user_id);
			$this->db->or_where('vb_tts.assign_to', $user_id);
		}
		if (isset($tts_id) && !empty($tts_id)) {
            $this->db->where('vb_tts.id', $tts_id);
		}
        return $this->db->get()->result_array();
    }
		
	public function get_sound_list($user_id, $tts_id='')
    {
        $this->db->select('vb_sounds.*,staff.name as staff_name');
        $this->db->from('vb_sounds');
		$this->db->join('staff', 'vb_sounds.assign_to = staff.id', 'left');
		if (isset($user_id) && !empty($user_id) && $user_id!=1) {
			$this->db->where('staff.assign_to', $user_id);
			$this->db->or_where('vb_sounds.assign_to', $user_id);
		}
		if (isset($tts_id) && !empty($tts_id)) {
            $this->db->where('vb_sounds.id', $tts_id);
		}
        return $this->db->get()->result_array();
    }
	
	public function get_tts_name($tts_text)
    {
        $this->db->select('tts_name');
        $this->db->from('vb_tts');
        $this->db->where('tts_text', $tts_text);
        $result = $this->db->get()->row_array();

        return !empty($result['tts_name']) ? $result['tts_name'] : '';
    }

    public function get_sound_name($sound_id)
    {
        $this->db->select('sound_name');
        $this->db->from('vb_sounds');
        $this->db->where('id', $sound_id);
        $result = $this->db->get()->row_array();

        return !empty($result['sound_name']) ? $result['sound_name'] : '';
    }
	
	
	public function save_callerid($data)
	{
		$insert_data = array(
            'date_time' => $data['date_time'],
            'caller_id' => $data['caller_id'],
            'trunk_id' => $data['trunk'],
            'channels' => $data['channels'],
			'status' => $data['status'],
			'assign_to' => $data['user_id']
        );
		
		$update_data = array(
            'date_time' => $data['date_time'],
            'caller_id' => $data['caller_id'],
            'channels' => $data['channels'],
			'status' => $data['status'],
			'assign_to' => $data['user_id']
        );
		
		if (isset($data['callerid_id']) && !empty($data['callerid_id'])) {
            $this->db->where('id', $data['callerid_id']);
            $this->db->update('vb_callerid', $update_data);
        } else {
            $this->db->insert('vb_callerid', $insert_data);
            return $this->db->insert_id();
        }
	}
	
	
	
	public function save_trunk($data)
	{
		$insert_data = array(
            'date_time' => $data['date_time'],
            'trunk_name' => $data['trunk_name'],
            'trunk_clid_name' => $data['trunk_clid_name'],
            'trunk_type' => $data['trunk_type'],
            'trunk_channel_limit' => $data['trunk_channel_limit'],
			'status' => $data['status'],
			'assign_to' => $data['assigned_admin']
        );
		
		$update_data = array(
            'date_time' => $data['date_time'],
            'trunk_name' => $data['trunk_name'],
            'trunk_clid_name' => $data['trunk_clid_name'],
            'trunk_type' => $data['trunk_type'],
            'trunk_channel_limit' => $data['trunk_channel_limit'],
			'status' => $data['status']
        );
		
		if (isset($data['trunk_id']) && !empty($data['trunk_id'])) {
            $this->db->where('id', $data['trunk_id']);
            $this->db->update('vb_trunks', $update_data);
        } else {
            $this->db->insert('vb_trunks', $insert_data);
            return $this->db->insert_id();
        }
	}
	
	
	public function save_tts($data)
	{
		$insert_data = array(
            'date_time' => $data['date_time'],
            'tts_name' => $data['tts_name'],
            'tts_text' => preg_replace('/[^a-zA-Z0-9\s]+/', '', $data['tts_text']),
			'status' => $data['status'],
			'assign_to' => $data['user_id']
        );
		
		if (isset($data['tts_id']) && !empty($data['tts_id'])) {
            $this->db->where('id', $data['tts_id']);
            $this->db->update('vb_tts', $insert_data);
        } else {
            $this->db->insert('vb_tts', $insert_data);
            return $this->db->insert_id();
        }
	}
	
	
	public function save_sound($data)
	{
		$insert_data = array(
            'date_time' => $data['date_time'],
            'sound_name' => $data['sound_name'],
			'status' => $data['status'],
			'assign_to' => $data['user_id'],
			'file_name' => $this->upload_audio(),
        );
		
		if (isset($data['sound_id']) && !empty($data['sound_id'])) {
            $this->db->where('id', $data['sound_id']);
            $this->db->update('vb_sounds', $insert_data);
        } else {
            $this->db->insert('vb_sounds', $insert_data);
            return $this->db->insert_id();
        }
	}
	
	
	public function upload_audio()
	{
		$prev_audio = $this->input->post('old_audio');
		$audio = $_FILES['audio']['name'];
		$return_audio = '';
		if ($audio != '') {
			$destination = './uploads/audio/'; // Set the destination directory for audio files
			$extension = pathinfo($audio, PATHINFO_EXTENSION);

			// Define the allowed audio file extensions
			$allowed_extensions = array('wav'); // You can add more as needed

			if (in_array(strtolower($extension), $allowed_extensions)) {
				$audio_path = 'audio-' . time() . '.' . $extension;
				move_uploaded_file($_FILES['audio']['tmp_name'], $destination . $audio_path);

				// Need to unlink the previous audio file
				if ($prev_audio != '') {
					if (file_exists($destination . $prev_audio)) {
						@unlink($destination . $prev_audio);
					}
				}
				$return_audio = $audio_path;
			} else {
				// Handle invalid audio format
				return 'error'; // You can return an error message or handle it as needed
			}
		} else {
			$return_audio = $prev_audio;
		}
		return $return_audio;
	}
}
