<?php defined('BASEPATH') or exit('No direct script access allowed');

/**
 * Class Client_support_model
 *
 * @property CI_DB_query_builder|CI_DB_mysqli_driver $db
 */
class Support_chat_model extends Base_model
{
    protected $table = 'support_chat';
    protected $returnType = 'object';

    protected $useTimestamps = true;

    protected $useSoftDelete = true;
    protected $allowedFields = [
        'client_support_id',
        'message',
        'sender_id',
    ];

    /**
     * @return array[]|object[]
     */
    public function findAll(): array
    {
        $this->prepareSelectQuery();
        return $this->db->get($this->table)->result();
    }

    /**
     * @param int|null $id
     * @return array|mixed|object|null
     */
    public function find(int $id = null)
    {
        $this->prepareSelectQuery();
        return $this->db->get_where($this->table, ['client_support.id' => $id])->row();
    }

    private function prepareSelectQuery()
    {
        $this->db->select('support_chat.*, staff.name as sender_name');
        $this->db->join('staff', 'staff.id = support_chat.sender_id', 'left');
    }
}