<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Sms_model extends Base_Model
{
    protected $returnType = 'object';
    protected $useTimestamps = true;
    protected $useSoftDelete = true;

    protected $allowedFields = [
        'name',
        'manager_id',
        'user_id',
        'sms_text',
        'status',
        'creator_id',
        'assign_to',
        'remarks'
    ];

    // Save SMS log into the database
    public function save_sms_log($data)
    {
        $creator = $this->employee_model->find(get_loggedin_user_id());

        if (isset($data['id']) && !empty($data['id'])) {
            $update_data = array(
                'sms_text' => $data['sms_text'],
                'status' => 'Submitted',
                'update_by' => $creator->id,
                'assign_to' => $data['assign_to'],
                'remarks' => $data['remarks']
            );

            $this->db->where('id', $data['id']);
            $this->db->update('sms_logs', $update_data);
        } else {
            $insert_data = array(
                'user_id' => $data['user_id'],
                'sms_text' => $data['sms_text'],
                'status' => 'Pending',
                'creator_id' => $creator->id,
                'creation_by' => $creator->name,
                'assign_to' => $data['assign_to'],
                'remarks' => $data['remarks']
            );

            $this->db->insert('sms_logs', $insert_data);
            return $this->db->insert_id();
        }
    }

    // Retrieve phone numbers based on zone
    public function get_phone_numbers_by_zone($zone_id)
    {
        // Replace 'correct_clients_table' with the actual table name
        return $this->db->select('phone_number')
                        ->from('staff') // Update to correct table name
                        ->join('zones', 'staff.zone_id = zones.id') // Update to correct table name
                        ->where('zones.id', $zone_id)
                        ->get()
                        ->result_array();
    }

    // Retrieve phone numbers based on OLT ID and zone
    public function get_phone_numbers_by_olt($olt_id, $zone_id)
    {
        // Replace 'clients_table' with the actual table name that contains client phone numbers
        return $this->db->select('phone_number')
                        ->from('staff') // Update to the correct table name
                        ->join('olts', 'staff.olt_id = olts.id') // Update to the correct table name
                        ->join('zones', 'olts.zone_id = zones.id') // Ensure OLTs are linked to zones
                        ->where('olts.id', $olt_id)
                        ->where('zones.id', $zone_id)
                        ->get()
                        ->result_array();
    }

    // Retrieve all zones with manager names
    public function findAllZones()
    {
        return $this->db->select('zones.*, staff.name as manager_name')
            ->join('staff', 'staff.id = zones.manager_id', 'left')
            ->from('zones')
            ->where('zones.deleted_at', null)
            ->order_by('zones.id', 'desc')
            ->get()
            ->result();
    }

    // Retrieve zones based on user role and ID
    public function get_zone_list_individual($RoleID='', $userID='')
    {
        $this->db->select('zones.*, staff.name as manager_name');
        $this->db->from('zones');
        $this->db->join('staff', 'staff.id = zones.manager_id', 'left');

        if (in_array($RoleID, [2, 3, 4]) && !empty($userID) && $userID != 1) {
            $this->db->where('zones.manager_id', $userID);
        } elseif (!in_array($RoleID, [2, 3, 4]) && !empty($userID) && $userID != 1) {
            $this->db->where('zones.manager_id', $userID);
        }

        return $this->db->get()->result();
    }

    // Send SMS to OLTs in a zone
    public function send_sms_to_olts($olt_ids, $message)
    {
        $creator = $this->employee_model->find(get_loggedin_user_id());

        foreach ($olt_ids as $olt) {
            // Retrieve staff information associated with the OLT
            $staff_info = $this->get_staff_info_by_olt($olt->id);

            // Iterate over the staff info and send SMS
            foreach ($staff_info as $info) {
                // Send the SMS (using any SMS sending service)
                $sms_sent = $this->send_sms($info->mobileno, $message);

                // Prepare the SMS log data
                $sms_data = array(
                    'user_id' => $info->id,
                    'sms_text' => $message,
                    'status' => 'Pending',
                    'creator_id' => $creator->id,
                    'creation_by' => $creator->name,
                    'assign_to' => $info->assign_to,
                    'remarks' => 'Web'
                );

                // Save the SMS log in the sms_logs table
                $this->save_sms_log($sms_data);
            }
        }
    }

    // Filter by manager ID
    public function whereManagerId(int $id)
    {
        if (in_array(loggedin_role_id(), [ROLE_RESELLER_ID, ROLE_SUBRESELLER_ID])) {
            $this->db->where('manager_id', $id);
        }
        return $this;
    }

    // Mock function to simulate SMS sending
    private function send_sms($phone_number, $message)
    {
        // Logic to send SMS using an SMS gateway or API goes here
        // For now, we'll just mock this function
        log_message('info', "SMS sent to {$phone_number}: {$message}");
    }
    
    // Retrieve all OLTs in a zone with manager names
    public function find_olts_by_zone($zone_id)
    {
        return $this->db->select('olts.*, staff.name as manager_name')
            ->join('staff', 'staff.id = olts.manager_id', 'left')
            ->from('olts')
            ->where('olts.zone_id', $zone_id)
            ->where('olts.deleted_at', null)
            ->order_by('olts.id', 'desc')
            ->get()
            ->result();
    }

    // Retrieve staff information by OLT ID
    public function get_staff_info_by_olt($olt_id)
    {
        return $this->db->select('staff.id, staff.name, staff.mobileno, staff.assign_to')
            ->from('staff')
            ->join('olts', 'olts.manager_id = staff.id', 'inner')
            ->where('olts.id', $olt_id)
            ->get()
            ->result();
    }
}
