<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Rules_model extends CI_Model
{
    protected $table = 'rules';

    public function __construct()
    {
        parent::__construct();
    }

    public function insert_rule($data)
    {
        $this->db->insert($this->table, $data);
        return $this->db->insert_id();
    }
    public function get_rule_logs()
    {
        $userID = get_loggedin_user_id();
        $roleID = loggedin_role_id();

        // Get assign_to ID first if role is manager
        $assignToID = null;
        if ($roleID == 4) {
            $manager = $this->db->select('assign_to')->where('id', $userID)->get('staff')->row_array();
            if ($manager && isset($manager['assign_to'])) {
                $assignToID = $manager['assign_to'];
            }
        }

        // Begin building main query
        $this->db->select('
        r.id, r.rules_number, r.description, r.created_at,
        s.name AS created_by_name, lc.role AS creator_role
    ')
            ->from('rules r')
            ->join('staff s', 'r.created_by = s.id', 'left')
            ->join('login_credential lc', 's.id = lc.user_id', 'left')
            ->order_by('r.id', 'DESC');

        if ($roleID == 2) {
            // Admin or Manager: see their own logs + admin logs
            $this->db->group_start()
                ->where('r.created_by', $userID)
                ->or_where('lc.role', 1)
                ->group_end();
        } elseif ($roleID == 4) {
            // Manager: see rules created by clients assigned to them
            if ($assignToID) {
                $this->db->where('r.created_by', $assignToID);
            } else {
                // Force no results
                $this->db->where('r.created_by', 0);
            }
        }

        return $this->db->get()->result();
    }



    public function delete_rule($id)
    {
        $this->db->where('id', $id);
        return $this->db->delete($this->table);
    }
}
