<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Rate_profile_model extends MY_Model
{
    public function __construct()
    {
        parent::__construct();
    }
	
	public function save_voice_rateprofile($data)
	{
		$insert_data = array(
            'name' => $data['name'],
            'prefix' => $data['prefix'],
            'bill_type' => $data['bill_type'],
            'rate' => $data['rate'],
            'pulse' => $data['pulse'],
            'max_duration' => $data['max_duration'],
            'assign_to' => $data['user_id'],
            'type' => $data['type']
        );
		
		if (isset($data['id']) && !empty($data['id'])) {
            $this->db->where('id', $data['id']);
            $this->db->update('rate_profile', $insert_data);
        } else {
            $this->db->insert('rate_profile', $insert_data);
            return $this->db->insert_id();
        }
	}
	
	
	public function save_rateprofile($data)
	{
		$insert_data = array(
            'name' => $data['name'],
            'prefix' => $data['prefix'],
            'rate' => $data['rate'],
            'pulse' => $data['pulse'],
			'assign_to' => $data['user_id'],
            'type' => $data['type']
        );
		
		if (isset($data['id']) && !empty($data['id'])) {
            $this->db->where('id', $data['id']);
            $this->db->update('rate_profile', $insert_data);
        } else {
            $this->db->insert('rate_profile', $insert_data);
            return $this->db->insert_id();
        }
	}
	
	
	public function update_rate_profile_in_staff($data)
	{
		$update_data = array(
            'voice_rate' => $data['voice_rate'],
            'sms_rate' => $data['sms_rate'],
            'email_rate' => $data['email_rate']
        );
		
		if (isset($data['profile_id']) && !empty($data['profile_id'])) {
            $this->db->where('id', $data['profile_id']);
            $this->db->update('staff', $update_data);
        } else {
			
        }
	}

	public function get_rate_profile_list($id='',$type='',$userID='')
    {
        $this->db->select('rate_profile.*,staff.name as staff_name');
        $this->db->from('rate_profile');
		$this->db->join('staff', 'rate_profile.assign_to = staff.id', 'left');
		if (isset($type) && !empty($type)) {
            $this->db->where('rate_profile.type', $type);
		}
		if (isset($id) && !empty($id)) {
            $this->db->where('rate_profile.id', $id);
		}
		if (isset($userID) && !empty($userID) && $userID!=1) {
            $this->db->where('rate_profile.assign_to', $userID);
		}
        return $this->db->get()->result_array();
    }	
}
