<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Package_model extends Base_Model
{
    protected $returnType = 'object';
    protected $useTimestamps = true;
    protected $useSoftDelete = true;

    protected $allowedFields = [
        'name',
        'type',
        'billing_profile_id',
        'nas_id',
        'nas_package',
        'privacy',
        'manager_id',
        'retail_price',
        'food_item',
        'sale_price',
        'breakfast_cost',
        'lunch_cost',
        'dinner_cost',
    ];
    public function get_product_list($product_ids = [])
    {
        $this->db->select('name');
        $this->db->from('product');

        if (!empty($product_ids)) {
            $this->db->where_in('name', $product_ids);
        }

        return $this->db->get()->result_array();
    }

    public function get($id)
    {
        return $this->db->where('id', $id)->get('staff')->row_array();
    }

    public function findAll()
    {
        $this->db->select('packages.*,billing_profiles.profile_name as billing_profile_name, staff.name as manager_name');
        $this->db->from('packages');
        $this->db->join('billing_profiles', 'billing_profiles.id = packages.billing_profile_id', 'left');
        $this->db->join('staff', 'staff.id = packages.manager_id', 'INNER');
        return $this->db->get()->result();
    }
public function findAll_filtered($RoleID = '', $userID = '')
{
    $this->db->select('
        packages.*, 
        billing_profiles.profile_name AS billing_profile_name, 
        staff.name AS manager_name, 
        staff.merchant_no AS manager_merchant_no,
        nas_router.name AS nas_name
    ');
    $this->db->from('packages');
    $this->db->join('billing_profiles', 'billing_profiles.id = packages.billing_profile_id', 'left');
    $this->db->join('nas_router', 'nas_router.id = packages.nas_id', 'left');
    $this->db->join('staff', 'staff.id = packages.manager_id', 'INNER');

    // Only user ID 1 can see all packages, others see packages where manager_id = userID
    if ($userID != 1 && !empty($userID)) {
        $this->db->where('packages.manager_id', $userID);
    }

    return $this->db->get()->result();
}

    public function get_package_list_individual($RoleID = '', $userID = '')
    {
        $this->db->select('packages.*');
        $this->db->from('packages');

        // RoleID 2 or 3: show packages managed by user
        if (in_array($RoleID, [2, 3]) && !empty($userID) && $userID != 1) {
            $this->db->where('packages.manager_id', $userID);
        }

        // RoleID 4: join with staff and use assign_to to find packages
        elseif ($RoleID == 4 && !empty($userID)) {
            // First, get assign_to from staff table
            $this->db->reset_query(); // Just to be safe and clear previous query parts
            $this->db->select('assign_to');
            $this->db->from('staff');
            $this->db->where('id', $userID);
            $staff = $this->db->get()->row();

            if ($staff && !empty($staff->assign_to)) {
                // Now get packages where manager_id matches assign_to
                $this->db->select('packages.*');
                $this->db->from('packages');
                $this->db->where('packages.manager_id', $staff->assign_to);
                return $this->db->get()->result();
            } else {
                return []; // No assign_to found
            }
        }

        return $this->db->get()->result();
    }


    public function get_package_list($id = '', $userID = '')
    {
        $this->db->select('packages.*,staff.name as staff_name');
        $this->db->from('packages');
        $this->db->join('staff', 'packages.manager_id = staff.id', 'left');
        if (isset($id) && !empty($id)) {
            $this->db->where('packages.id', $id);
        }
        if (isset($userID) && !empty($userID) && $userID != 1) {
            $this->db->where('packages.manager_id', $userID);
        }
        return $this->db->get()->result();
    }

    public function get_package_details_by_id($id = '')
    {
        $this->db->select('packages.*');
        $this->db->from('packages');
        $this->db->where('packages.id', $id);
        return $this->db->get()->row_array();
    }

    public function whereManagerId(int $id)
    {
        if (in_array(loggedin_role_id(), [ROLE_RESELLER_ID, ROLE_SUBRESELLER_ID])) {
            $this->db->where('manager_id', $id);
        }
        return $this;
    }
}
