<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Olt_model extends Base_Model
{
    protected $returnType = 'object';
    protected $useTimestamps = true;
    protected $useSoftDelete = true;

    protected $allowedFields = [
        'name',
     
        'manager_id',
      
    ];

    /**
     * Get all OLTs with their managers
     *
     * @return object
     */
    public function findAll()
    {
        return $this->db->select('olts.*, staff.name as manager_name')
            ->join('staff', 'staff.id = olts.manager_id', 'left')
            ->from('olts')
            ->where('olts.deleted_at', null)
            ->order_by('olts.id', 'desc')
            ->get()->result();
    }

    /**
     * Get OLTs for a specific user or role
     *
     * @param string $RoleID
     * @param string $userID
     * @return object
     */
    public function get_olt_list_individual($RoleID = '', $userID = '')
    {
        $this->db->select('olts.*, staff.name as manager_name');
        $this->db->from('olts');
        $this->db->join('staff', 'staff.id = olts.manager_id', 'left');
    
        // If RoleID 2, show OLTs where manager_id = userID
        if ($RoleID == 3) {
            $this->db->where('olts.manager_id', $userID);
        }
    
        return $this->db->get()->result();
    }
    
    
    
    /**
     * Get OLTs for a specific user or role as array
     *
     * @param string $RoleID
     * @param string $userID
     * @return array
     */
    public function get_olt_list_individual_array($RoleID = '', $userID = '')
    {
        $this->db->select('olts.*, staff.name as manager_name');
        $this->db->from('olts');
        $this->db->join('staff', 'staff.id = olts.manager_id', 'left');

        // For specific user zones
        if (in_array($RoleID, [2, 3, 4]) && isset($userID) && !empty($userID) && $userID != 1) {
            $this->db->where('olts.manager_id', $userID);
        }
        // For all zones
        if (!in_array($RoleID, [2, 3, 4]) && isset($userID) && !empty($userID) && $userID != 1) {
            $this->db->where('olts.manager_id', $userID);
        }

        return $this->db->get()->result_array();
    }

    /**
     * Filter by manager ID
     *
     * @param int $id
     * @return $this
     */
    public function whereManagerId(int $id)
    {
        if (in_array(loggedin_role_id(), [ROLE_RESELLER_ID, ROLE_SUBRESELLER_ID])) {
            $this->db->where('manager_id', $id);
        }
        return $this;
    }
	////OLT BY ID
	public function getOltbyid(int $id)
    {
        $this->db->select('olts.*');
        $this->db->from('olts');
		$this->db->where('olts.id', $id);
        return $this->db->get()->result_array();
    }
}
