<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Nas_model extends MY_Model
{
    public function __construct()
    {
        parent::__construct();
    }
    public function nas_save($data)
    {
        $insert_nas = array(
            'idd' => $data['idd'],

            'package_id' => $data['package_id'],
            'package_name' => $data['package_name'],
            'student_name' => $data['student_name'],
            'manager_name' => $data['manager_name'],
            'breakfast_cost' => $data['breakfast_cost'],
            'lunch_cost' => $data['lunch_cost'],
            'dinner_cost' => $data['dinner_cost'],
            'total_breakfast' => $data['total_breakfast'],
            'total_lunch' => $data['total_lunch'],
            'total_dinner' => $data['total_dinner'],
            'total_amount' => $data['total_amount'],
            'selected_dates' => $data['selected_dates'],
            'selected_breakfast' => $data['selected_breakfast'],
            'selected_lunch' => $data['selected_lunch'],
            'selected_dinner' => $data['selected_dinner'],
            'assign_to' => get_loggedin_user_id()

        );

        if (isset($data['id']) && !empty($data['id'])) {
            $this->db->where('id', $data['id']);
            $this->db->update('nas_router', $insert_nas);
        } else {
            $this->db->insert('nas_router', $insert_nas);
            return $this->db->insert_id();
        }
    }

    public function get_students_by_manager($userID)
    {
        $builder = $this->db->select('s.id, s.name, s.assign_to')
            ->from('staff s')
            ->join('login_credential l', 'l.user_id = s.id', 'left')
            ->where('l.role', 4);
        if ($userID != 1) {
            $builder->group_start()
                ->where('s.id', $userID)
                ->or_where('s.assign_to', $userID)
                ->group_end();
        }

        return $builder->get()->result();
    }
    public function get($id)
    {
        return $this->db->where('id', $id)->get('staff')->row_array();
    }

    public function save_nas_profile($data)
    {
        $insert_data = array(
            'nas_id' => $data['nas_id'],
            'name' => $data['ppp_profile']
        );

        if (isset($data['id']) && !empty($data['id'])) {
            $this->db->where('id', $data['id']);
            $this->db->update('nas_profile', $insert_data);
        } else {
            $this->db->insert('nas_profile', $insert_data);
            return $this->db->insert_id();
        }
    }
    public function get_zone_list_individual($RoleID = '', $userID = '')
    {
        $this->db->select('zones.*, staff.name as manager_name');
        $this->db->from('zones');
        $this->db->join('staff', 'staff.id = zones.manager_id', 'left');

        if (!($RoleID == 1 && $userID == 1)) {
            $this->db->where('zones.manager_id', $userID);
        }

        return $this->db->get()->result();
    }
    public function get_nas_list_by_manager($RoleID = '', $userID = '', $packageID = '', $startDate = '', $endDate = '', $student_id = '')
    {
        if (!empty($userID) && in_array($RoleID, [2, 3])) {
            $assigned_ids = array_column(
                $this->db->select('id')->from('staff')->where('assign_to', $userID)->get()->result_array(),
                'id'
            );
            $assigned_ids[] = $userID;
            $this->db->where_in('nas_router.assign_to', $assigned_ids);
        } elseif (!empty($userID) && $userID != 1) {
            $this->db->where('nas_router.assign_to', $userID);
        }
    
        $this->db->select("
            nas_router.idd,
            GROUP_CONCAT(DATE_FORMAT(nas_router.selected_dates, '%Y-%m-%d') ORDER BY nas_router.selected_dates ASC) AS selected_dates,
            GROUP_CONCAT(nas_router.selected_breakfast ORDER BY nas_router.selected_dates ASC) AS selected_breakfast,
            GROUP_CONCAT(nas_router.selected_lunch ORDER BY nas_router.selected_dates ASC) AS selected_lunch,
            GROUP_CONCAT(nas_router.selected_dinner ORDER BY nas_router.selected_dates ASC) AS selected_dinner,
            SUM(nas_router.selected_breakfast) AS selected_total_breakfast,
            SUM(nas_router.selected_lunch) AS selected_total_lunch,
            SUM(nas_router.selected_dinner) AS selected_total_dinner,
            SUM(nas_router.selected_breakfast + nas_router.selected_lunch + nas_router.selected_dinner) AS total_meal_count,
            MAX(nas_router.student_name) AS student_name,
            SUM(nas_router.total_amount) AS total_amount,
            MAX(nas_router.breakfast_cost) AS breakfast_cost,
            MAX(nas_router.lunch_cost) AS lunch_cost,
            MAX(nas_router.dinner_cost) AS dinner_cost,
            MAX(nas_router.payment_status) AS payment_status,
            MAX(nas_router.assign_to) AS assign_to,
            MAX(nas_router.package_id) AS package_id,
            MAX(nas_router.id) AS id,
            GROUP_CONCAT(nas_router.package_name) AS package_name,
    
            -- Retrieve branch name and merchant_no from staff table for the branch (using the second join)
            branch_staff.name AS branch_name,
            branch_staff.merchant_no AS branch_merchant_no
        ");
    
        $this->db->from('nas_router');
        $this->db->join('packages', 'packages.id = nas_router.package_id', 'left'); // Correct join
    
        // Join with staff table to get the student's staff details (student_staff)
        $this->db->join('staff AS student_staff', 'student_staff.id = nas_router.assign_to', 'left');
    
        // Join again with the staff table (aliased as branch_staff) to get the branch's details (using student_staff.assign_to)
        $this->db->join('staff AS branch_staff', 'branch_staff.id = student_staff.assign_to', 'left');
    
        // Apply filters if provided
        if (!empty($packageID)) {
            $this->db->where('nas_router.package_id', $packageID);
        }
        if (!empty($student_id)) {
            $this->db->where('nas_router.idd', $student_id);
        }
        if (!empty($startDate) && !empty($endDate)) {
            $this->db->where('nas_router.created_at >=', $startDate);
            $this->db->where('nas_router.created_at <=', $endDate);
        }
    
        $this->db->group_by('nas_router.idd');
        return $this->db->get()->result_array();
    }
    

    public function get_nas_list($RoleID = '', $userID = '', $packageID = '', $startDate = '', $endDate = '', $student_id = '')
    {
        $this->db->select('nas_router.*');
        $this->db->from('nas_router');

        if (!empty($userID) && in_array($RoleID, [2, 3])) {
            $this->db->reset_query();
            $this->db->select('id');
            $this->db->from('staff');
            $this->db->where('assign_to', $userID);
            $staffs = $this->db->get()->result_array();

            $assigned_ids = array_column($staffs, 'id');
            $assigned_ids[] = $userID; // Include self

            $this->db->select('nas_router.*');
            $this->db->from('nas_router');
            $this->db->where_in('nas_router.assign_to', $assigned_ids);
        } elseif (!empty($userID) && $userID != 1) {
            $this->db->where('nas_router.assign_to', $userID);
        }

        if (!empty($packageID)) {
            $this->db->where('nas_router.package_id', $packageID);
        }

        if (!empty($student_id)) {
            $this->db->where('nas_router.idd', $student_id);
        }

        if (!empty($startDate) && !empty($endDate)) {
            $this->db->where('nas_router.created_at >=', $startDate);
            $this->db->where('nas_router.created_at <=', $endDate);
        }

        $this->db->order_by('nas_router.id', 'DESC');

        return $this->db->get()->result_array();
    }
    public function get_refund_list($RoleID = '', $userID = '')
    {
        $this->db->select('refund.*');
        $this->db->from('refund');

        if (!empty($userID) && in_array($RoleID, [2, 3])) {
            // Get staff IDs assigned to this user
            $this->db->reset_query();
            $this->db->select('id');
            $this->db->from('staff');
            $this->db->where('assign_to', $userID);
            $staffs = $this->db->get()->result_array();

            $assigned_ids = array_column($staffs, 'id');
            $assigned_ids[] = $userID; // include self

            $this->db->select('refund.*');
            $this->db->from('refund');
            $this->db->where_in('refund.refunded_by', $assigned_ids);
        } elseif (!empty($userID) && $userID != 1) {
            $this->db->where('refund.refunded_by', $userID);
        }

        $this->db->order_by('refund.id', 'DESC');

        return $this->db->get()->result_array();
    }


    public function get_nas_details_by_id($id = '')
    {
        $this->db->select('*');
        $this->db->from('nas_router');
        $this->db->where('id', $id);
        $query = $this->db->get();
        return $query->row_array();
    }

    public function get_product_list()
    {
        $this->db->select('product.*,product_category.name as category_name,p_unit.name as p_unit_name,s_unit.name as s_unit_name');
        $this->db->from('product');
        $this->db->join('product_category', 'product_category.id = product.category_id', 'left');
        $this->db->join('product_unit as p_unit', 'p_unit.id = product.purchase_unit_id', 'left');
        $this->db->join('product_unit as s_unit', 's_unit.id = product.sales_unit_id', 'left');
        $this->db->order_by('product.id', 'ASC');
        return $this->db->get()->result_array();
    }
    public function get_all_students()
    {
        $this->db->select('id, name');
        $this->db->from('staff');
        $query = $this->db->get();

        $students = [];
        foreach ($query->result_array() as $row) {
            $students[$row['id']] = $row['name'];
        }

        return $students;
    }

    public function get_purchase_list()
    {
        $sql = "SELECT meal_bill.*,supplier.name as supplier_name,staff.name as biller_name FROM meal_bill LEFT JOIN supplier ON supplier.id = meal_bill.supplier_id LEFT JOIN staff ON staff.id = meal_bill.prepared_by ORDER BY meal_bill.id ASC";
        $query = $this->db->query($sql);
        return $query->result_array();
    }

    public function get_invoice($id)
    {
        $this->db->select('meal_bill.*,supplier.name as supplier_name,supplier.address as supplier_address,supplier.company_name as supplier_company_name,supplier.mobileno as supplier_mobileno,staff.name as biller_name');
        $this->db->from('meal_bill');
        $this->db->join('supplier', 'supplier.id = meal_bill.supplier_id', 'left');
        $this->db->join('staff', 'staff.id = meal_bill.prepared_by', 'left');
        $this->db->where('meal_bill.id', $id);
        return $this->db->get()->row_array();
    }



    public function save_purchase($data)
    {
        $arrayInvoice = array(
            'supplier_id' => $data['supplier_id'],
            'bill_no' => $data['bill_no'],
            'buyer_name' => $data['buyer_name'],
            'buyer_identity' => $data['buyer_identity'],
            'buyer_mobile' => $data['buyer_mobile'],
            'remarks' => $data['remarks'],
            'total' => $data['grand_total'],
            'discount' => $data['total_discount'],
            'due' => $data['net_grand_total'],
            'paid' => 0,
            'payment_status' => 1,
            'purchase_status' => $data['purchase_status'],
            'hash' => app_generate_hash(),
            'date' => date('Y-m-d', strtotime($data['date'])),
            'prepared_by' => get_loggedin_user_id(),
            'modifier_id' => get_loggedin_user_id(),
        );
        $this->db->insert('meal_bill', $arrayInvoice);
        $meal_bill_id = $this->db->insert_id();

        $arrayData = array();
        $purchases = $data['purchases'];
        foreach ($purchases as $key => $value) {
            $arrayproduct = array(
                'meal_bill_id' => $meal_bill_id,
                'product_id' => $value['product'],
                'unit_price' => $value['unit_price'],
                'discount' => $value['discount'],
                'quantity' => $value['quantity'],
                'sub_total' => $value['sub_total'],
            );
            $arrayData[] = $arrayproduct;
        }
        $this->db->insert_batch('meal_bill_details', $arrayData);
    }

    public function save_payment($data)
    {
        $status = true;
        $payment_status = 1;
        $attach_orig_name = "";
        $attach_file_name = "";
        $meal_bill_id = $data['meal_bill_id'];
        $payment_amount = $data['payment_amount'];
        $paid_date = $data['paid_date'];

        if (isset($_FILES['attach_document']['name']) && !empty($_FILES['attach_document']['name'])) {
            $config['upload_path'] = './uploads/attachments/inventory_payment/';
            $config['allowed_types'] = 'gif|jpg|png|pdf|docx|csv|txt';
            $config['max_size'] = '2048';
            $config['encrypt_name'] = true;
            $this->upload->initialize($config);
            if ($this->upload->do_upload("attach_document")) {
                $attach_orig_name = $this->upload->data('orig_name');
                $attach_file_name = $this->upload->data('file_name');
            } else {
                $error = $this->upload->display_errors();
                return ['status' => false, 'msg' => $error];
            }
        }

        if ($status == true) {
            $array_history = array(
                'meal_bill_id' => $meal_bill_id,
                'payment_by' => get_loggedin_user_id(),
                'amount' => $payment_amount,
                'pay_via' => $this->input->post('pay_via'),
                'remarks' => $this->input->post('remarks'),
                'attach_orig_name' => $attach_orig_name,
                'attach_file_name' => $attach_file_name,
                'coll_type' => 1,
                'paid_on' => date("Y-m-d", strtotime($paid_date)),
            );
            $this->db->insert('meal_payment_history', $array_history);
            if ($data['getbill']['due'] <= $payment_amount) {
                $payment_status = 3;
            } else {
                $payment_status = 2;
            }
            $sql = "UPDATE meal_bill SET payment_status = " . $payment_status . ", paid = paid + " . $payment_amount . ", due = due - " . $payment_amount . " WHERE id = " . $this->db->escape($meal_bill_id);
            $this->db->query($sql);
            return ['status' => true, 'msg' => ''];
        }
    }
    public function get_purchase_report($supplier_id = '', $payment_status = '', $start = '', $end = '')
    {
        $this->db->select('meal_bill.*,IFNULL(SUM(meal_bill.total - meal_bill.discount),0) as net_payable,supplier.name as supplier_name');
        $this->db->from('meal_bill');
        $this->db->join('supplier', 'supplier.id = meal_bill.supplier_id', 'left');
        if ($supplier_id != 'all') {
            $this->db->where('meal_bill.supplier_id', $supplier_id);
        }

        if ($payment_status != 'all') {
            $this->db->where('meal_bill.payment_status', $payment_status);
        }

        $this->db->where('meal_bill.date >=', $start);
        $this->db->where('meal_bill.date <=', $end);
        $this->db->group_by('meal_bill.id');
        $this->db->order_by('meal_bill.id', 'ASC');
        return $this->db->get()->result_array();
    }

    public function get_purchase_payment_report($supplier_id = '', $start = '', $end = '')
    {
        $this->db->select('meal_payment_history.*,meal_bill.bill_no,meal_bill.id as bill_id,meal_bill.hash,supplier.name as supplier_name,payment_method.name as paidvia');
        $this->db->from('meal_payment_history');
        $this->db->join('meal_bill', 'meal_bill.id = meal_payment_history.meal_bill', 'inner');
        $this->db->join('payment_method', 'payment_method.id = meal_payment_history.pay_via', 'left');
        $this->db->join('supplier', 'supplier.id = meal_bill.supplier_id', 'left');
        if ($supplier_id != 'all') {
            $this->db->where('meal_bill.supplier_id', $supplier_id);
        }

        $this->db->where('meal_payment_history.paid_on >=', $start);
        $this->db->where('meal_payment_history.paid_on <=', $end);
        $this->db->order_by('meal_payment_history.id', 'DESC');
        return $this->db->get()->result_array();
    }
}
