<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Logs_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
    }

    public function get_payment_logs_filter($start, $end)
    {
        $this->db->select('*');
        $this->db->from('payment_logs');
        if ($start && $end) {
            $this->db->where('date >=', $start);
            $this->db->where('date <=', $end);
        }
        $query = $this->db->get();
        return $query->result_array();
    }

    public function payment_method_list()
    {
        $this->db->select('*');
        $this->db->from('payment_method');
        $query = $this->db->get();
        return $query->result_array();
    }

    public function save_payment_method($data)
    {
        if (isset($data['id']) && $data['id'] != '') {
            $this->db->where('id', $data['id']);
            $this->db->update('payment_method', $data);
            return $data['id'];
        } else {
            $this->db->insert('payment_method', $data);
            return $this->db->insert_id();
        }
    }

    public function get_client_payment_logs_filter($RoleID, $search_userID, $start, $end)
    {
        $this->db->select('*');
        $this->db->from('client_payment_logs');
        $this->db->where('role_id', $RoleID);
        $this->db->where('user_id', $search_userID);
        if ($start && $end) {
            $this->db->where('date >=', $start);
            $this->db->where('date <=', $end);
        }
        $query = $this->db->get();
        return $query->result_array();
    }

    public function get_recharge_logs_filter($RoleID, $search_userID, $start, $end)
    {
        $this->db->select('*');
        $this->db->from('recharge_logs');
        $this->db->where('role_id', $RoleID);
        $this->db->where('user_id', $search_userID);
        if ($start && $end) {
            $this->db->where('date >=', $start);
            $this->db->where('date <=', $end);
        }
        $query = $this->db->get();
        return $query->result_array();
    }

    public function get_all_user_names()
    {
        $this->db->select('id, username');
        $this->db->from('users');
        $query = $this->db->get();
        return $query->result_array();
    }

    public function get_only_client_list($param1, $userID, $param2)
    {
        // Add your logic to fetch client list based on parameters
        $this->db->select('id, client_name');
        $this->db->from('clients');
        $this->db->where('user_id', $userID);
        $query = $this->db->get();
        return $query->result_array();
    }


    // GET Reseller and Sub reseller ALL DETAILS
    public function get_reseller_subreseller_list($role_id, $userID, $active = 1)
    {

        $this->db->select('staff.id,staff.name,staff.merchant_no');
        $this->db->from('staff');
        $this->db->join('login_credential', 'login_credential.user_id = staff.id', 'inner');
        if (isset($userID) && !empty($userID) && $userID == 1) {
            $this->db->where_in('login_credential.role', array(2, 3));
        }
        if (isset($userID) && !empty($userID) && $userID != 1 && in_array($role_id, array(2, 3))) {
            $this->db->where('staff.assign_to', $userID);
            $this->db->where_in('login_credential.role', array(3));
        }
        if (isset($userID) && !empty($userID) && $userID != 1 && isset($role_id) && !empty($role_id) && !in_array($role_id, array(1, 2, 3, 4))) {
            $this->db->where('staff.assign_to', 1);
            $this->db->where_in('login_credential.role', array(2, 3));
        }
        $this->db->order_by('staff.id', 'ASC');
        return $this->db->get()->result();
    }
    // New methods for zone SMS functionality

    public function get_phone_numbers_by_zone($zone)
    {
        $this->db->select('phone_number');
        $this->db->from('user_zones');
        $this->db->join('users', 'user_zones.user_id = users.id');
        $this->db->where('zone', $zone);
        $query = $this->db->get();
        return $query->result_array();
    }

    public function send_sms_to_zone($zone, $message)
    {
        // Get the phone numbers for the specified zone
        $recipients = $this->get_phone_numbers_by_zone($zone);

        foreach ($recipients as $recipient) {
            // Call your SMS sending function here
            $this->send_sms($recipient['phone_number'], $message);
        }
    }

    private function send_sms($phone_number, $message)
    {
        // Your SMS API integration code here
        // Example: 
        // $this->sms_api->send_sms($phone_number, $message);
    }
    	// get statement report function
	public function get_statement_report($account_id='', $type='', $start='', $end='')
	{
		$this->db->select('transactions.*');
		$this->db->from('transactions');
		$this->db->where('transactions.account_id', $account_id);
		$this->db->where('transactions.date >=', $start);
		$this->db->where('transactions.date <=', $end);
		if ($type != 'all') {
			$this->db->where('transactions.type', $type);
		}
		$this->db->order_by('transactions.id', 'ASC');
		return $this->db->get()->result_array();
	}

    public function get_income_expense_repots($RoleID, $userID, $start = null, $end = null)
    {
        $loggedID = get_loggedin_user_id();
        $this->_db->select('payment_logs.*,payment_method.name as payment_method,login_credential.role as role_id, roles.id as role,s2_admin.name as payment_for,s1_admin.name as payment_from');
        $this->_db->from('payment_logs');
        $this->_db->join('login_credential', 'login_credential.user_id = payment_logs.payment_for and login_credential.role != 4', 'inner');
        $this->_db->join('roles', 'roles.id = login_credential.role', 'left');
        $this->_db->join('staff as s2_admin', 'payment_logs.payment_for = s2_admin.id', 'left');
        $this->_db->join('staff as s1_admin', 'payment_logs.payment_from = s1_admin.id', 'left');
        $this->_db->join('payment_method', 'payment_method.id = payment_logs.payment_method', 'left');
        if (isset($userID) && !empty($userID) && $userID != 1 && isset($RoleID) && !empty($RoleID) && !in_array($RoleID, array(2, 3, 4))) {
            $this->_db->where('payment_logs.manager_id', $loggedID);
            if ($loggedID != $userID) {
                $this->_db->where('payment_logs.payment_for', $userID);
            }
        } else {
            $this->_db->where('payment_logs.manager_id', $loggedID);
            if ($loggedID != $userID) {
                $this->_db->where('payment_logs.payment_for', $userID);
            }
        }
        if (!is_null($start) && !is_null($end)) {
            $this->_db->where('DATE(datetime) >=', $start);
            $this->_db->where('DATE(datetime) <=', $end.' 23:59:59');
        }
		return $this->db->get()->result_array();
    }

	// get account balance sheet report
	public function get_balance_sheet()
	{
		$this->db->select('transactions.*,IFNULL(SUM(transactions.dr), 0) as total_dr,IFNULL(SUM(transactions.cr),0) as total_cr,accounts.name as ac_name,accounts.balance as fbalance');
		$this->db->from('accounts');
		$this->db->join('transactions', 'transactions.account_id = accounts.id', 'left');
		$this->db->group_by('transactions.account_id');
		$this->db->order_by('accounts.balance', 'DESC');
		return $this->db->get()->result_array();
	}
    	// get income vs expense report
	public function get_incomevsexpense($start='', $end='')
	{
		$sql = "SELECT transactions.*, voucher_head.name as v_head, IFNULL(SUM(transactions.dr), 0) as total_dr, IFNULL(SUM(transactions.cr), 0) as total_cr FROM voucher_head LEFT JOIN transactions ON transactions.voucher_head_id = voucher_head.id WHERE transactions.date >= " . $this->db->escape($start) . " AND transactions.date <= " . $this->db->escape($end) . " GROUP BY transactions.voucher_head_id ORDER BY transactions.id ASC";
		return $this->db->query($sql)->result_array();
	}

    	// get transitions repots
	public function get_transitions_repots($start='', $end='')
	{
		$sql = "SELECT transactions.*, accounts.name as ac_name, voucher_head.name as v_head, payment_method.name as via_name FROM transactions LEFT JOIN accounts ON accounts.id = transactions.account_id LEFT JOIN voucher_head ON voucher_head.id = transactions.voucher_head_id LEFT JOIN payment_method ON payment_method.id = transactions.pay_via WHERE transactions.date >= " . $this->db->escape($start) . " AND transactions.date <= " . $this->db->escape($end) . " ORDER BY transactions.id ASC";
		return $this->db->query($sql)->result_array();
	}

}
