<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Help_model extends CI_Model
{
    protected $table = 'help_lines';

    public function __construct()
    {
        parent::__construct();
    }

    // Insert a new help line
    public function insert_help_line($data)
    {
        $this->db->insert($this->table, $data);
        return $this->db->insert_id();
    }

    // Fetch logs for all help lines
    public function get_help_line_logs($userID = null, $filterType = null)
    {
        $this->db->select('hl.id, hl.phone_number, hl.description, hl.created_at, s.name AS created_by_name')
            ->from('help_lines hl')
            ->join('staff s', 'hl.created_by = s.id', 'left')
            ->order_by('hl.id', 'DESC');
    
        if ($filterType === 'self') {
            // Role 2: Only own logs
            $this->db->where('hl.created_by', $userID);
        } elseif ($filterType === 'manager') {
            // Role 4: Only logs created by assigned manager
            $this->db->where('hl.created_by = (
                SELECT assign_to FROM staff WHERE id = ' . $this->db->escape($userID) . '
            )');
        }
        // Role 1 (Admin): no filter
    
        $query = $this->db->get();
        return $query->result();
    }
    
    
    
}
