<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Frontend_model extends MY_Model
{
    public function __construct()
    {
        parent::__construct();
    }

    public function save_faq($data)
    {
        $faq_data = array(
            'title' => $data['title'],
            'description' => $data['description'],
        );
        if (isset($data['faq_id']) && !empty($data['faq_id'])) {
            $this->db->where('id', $data['faq_id']);
            $this->db->update('front_cms_faq_list', $faq_data);
        } else {
            $this->db->insert('front_cms_faq_list', $faq_data);
        }
    }

    public function save_slider($data)
    {
        $elements_data = array(
            'position' => $data['position'],
            'button_text1' => $data['button_text_1'],
            'button_url1' => $data['button_url_1'],
            'button_text2' => $data['button_text_2'],
            'button_url2' => $data['button_url_2'],
            'image' => $this->upload_image(),
        );

        $slider_data = array(
            'title' => $data['title'],
            'description' => $data['description'],
            'item_type' => 'slider',
            'elements' => json_encode($elements_data),
        );
        if (isset($data['slider_id']) && !empty($data['slider_id'])) {
            $this->db->where('id', $data['slider_id']);
            $this->db->update('front_cms_home', $slider_data);
        } else {
            $this->db->insert('front_cms_home', $slider_data);
        }
    }

    public function save_menus($data)
    {
        $title = $data['title'];
        $slug = strtolower(str_replace(' ', '-', $title));
        $publish = isset($data['publish']) ? 1 : 0;
        $new_tab = isset($data['new_tab']) ? 1 : 0;
        $external_url = isset($data['external_url']) ? 1 : 0;
        $menu_data = array(
            'title' => $title,
            'alias' => $slug,
            'ordering' => $data['position'],
            'open_new_tab' => $new_tab,
            'ext_url' => $external_url,
            'ext_url_address' => $data['external_link'],
            'publish' => $publish,
            'system' => 0,
        );
        if (isset($data['menu_id']) && !empty($data['menu_id'])) {
            $isSystem = $this->db->get_where('front_cms_menu', array('id' => $data['menu_id']))->row()->system;
            if ($isSystem == 1) {
                unset($menu_data['alias']);
                unset($menu_data['ext_url']);
                unset($menu_data['ext_url_address']);
                unset($menu_data['system']);
            }
            $this->db->where('id', $data['menu_id']);
            $this->db->update('front_cms_menu', $menu_data);
        } else {
            $this->db->insert('front_cms_menu', $menu_data);
        }
    }

    public function save_features($data)
    {
        $elements_data = array(
            'button_text' => $data['button_text'],
            'button_url' => $data['button_url'],
            'icon' => $data['icon'],
        );

        $slider_data = array(
            'title' => $data['title'],
            'item_type' => 'features',
            'description' => $data['description'],
            'elements' => json_encode($elements_data),
        );
        if (isset($data['features_id']) && !empty($data['features_id'])) {
            $this->db->where('id', $data['features_id']);
            $this->db->update('front_cms_home', $slider_data);
        } else {
            $this->db->insert('front_cms_home', $slider_data);
        }
    }

    // testimonial save and update function
    public function save_testimonial($data)
    {
        $insert_testimonial = array(
            'patient_name' => $data['patient_name'],
            'surname' => $data['surname'],
            'description' => $data['description'],
            'rank' => $data['rank'],
            'image' => $this->upload_image(),
            'created_by' => get_loggedin_user_id(),
        );

        if (isset($data['testimonial_id']) && !empty($data['testimonial_id'])) {
            $this->db->where('id', $data['testimonial_id']);
            $this->db->update('front_cms_testimonial', $insert_testimonial);
        } else {
            $this->db->insert('front_cms_testimonial', $insert_testimonial);
        }
    }

    public function save_services($data)
    {
        $services_data = array(
            'title' => $data['title'],
            'description' => $data['description'],
            'icon' => $data['icon'],
        );
        if (isset($data['services_id']) && !empty($data['services_id'])) {
            $this->db->where('id', $data['services_id']);
            $this->db->update('front_cms_services_list', $services_data);
        } else {
            $this->db->insert('front_cms_services_list', $services_data);
        }
    }
  
    
    public function save_team($data)
    {
        $elements_data = array(
            'title' => $data['title'],
            'designation' => $data['designation'],
            'description' => $data['description'],
            'image' => $this->upload_img(),
        );

        $team_data = array(
            'title' => $data['title'],
            'description' => $data['description'],
            'designation' => $data['designation'],
            'item_type' => 'team',
            'elements' => json_encode($elements_data),
        );
        if (isset($data['team_id']) && !empty($data['team_id'])) {
            $this->db->where('id', $data['team_id']);
            $this->db->update('front_cms_team_list', $team_data);
        } else {
            $this->db->insert('front_cms_team_list', $team_data);
        }
    }

    public function upload_img()
    {
        $prev_image = $this->input->post('old_photo');
        $image = $_FILES['photo']['name'];
        $return_image = '';
        if ($image != '') {
            $destination = './uploads/frontend/team/';
            $extension = pathinfo($image, PATHINFO_EXTENSION);
            $image_path = 'team-member-' . time() . '.' . $extension;
            move_uploaded_file($_FILES['photo']['tmp_name'], $destination . $image_path);

            // need to unlink previous slider
            if ($prev_image != '') {
                if (file_exists($destination . $prev_image)) {
                    @unlink($destination . $prev_image);
                }
            }
            $return_image = $image_path;
        } else {
            $return_image = $prev_image;
        }
        return $return_image;
    }
    public function save_client($data)
    {
        $elements_data = array(
            'image' => $this->upload_client_img(),
        );

        $client_data = array(
            'item_type' => 'client',
            'elements' => json_encode($elements_data),
        );
        if (isset($data['client_id']) && !empty($data['client_id'])) {
            $this->db->where('id', $data['client_id']);
            $this->db->update('front_cms_client_list', $client_data);
        } else {
            $this->db->insert('front_cms_client_list', $client_data);
        }
    }

    public function upload_client_img()
    {
        $prev_image = $this->input->post('old_photo');
        $image = $_FILES['photo']['name'];
        $return_image = '';
        if ($image != '') {
            $destination = './uploads/frontend/client/';
            $extension = pathinfo($image, PATHINFO_EXTENSION);
            $image_path = 'client-member-' . time() . '.' . $extension;
            move_uploaded_file($_FILES['photo']['tmp_name'], $destination . $image_path);

            // need to unlink previous slider
            if ($prev_image != '') {
                if (file_exists($destination . $prev_image)) {
                    @unlink($destination . $prev_image);
                }
            }
            $return_image = $image_path;
        } else {
            $return_image = $prev_image;
        }
        return $return_image;
    }


    public function save_payment($data)
    {
        $elements_data = array(
            'title' => $data['title'],
            'image' => $this->upload_pay(),
        );

        $payment_data = array(
            'title' => $data['title'],
            'item_type' => 'payment',
            'elements' => json_encode($elements_data),
        );
        if (isset($data['payment_id']) && !empty($data['payment_id'])) {
            $this->db->where('id', $data['payment_id']);
            $this->db->update('front_cms_payment_list', $payment_data);
        } else {
            $this->db->insert('front_cms_payment_list', $payment_data);
        }
    }

    public function upload_pay()
    {
        $prev_image = $this->input->post('old_photo');
        $image = $_FILES['photo']['name'];
        $return_image = '';
        if ($image != '') {
            $destination = './uploads/frontend/payment/';
            $extension = pathinfo($image, PATHINFO_EXTENSION);
            $image_path = 'team-member-' . time() . '.' . $extension;
            move_uploaded_file($_FILES['photo']['tmp_name'], $destination . $image_path);

            // need to unlink previous slider
            if ($prev_image != '') {
                if (file_exists($destination . $prev_image)) {
                    @unlink($destination . $prev_image);
                }
            }
            $return_image = $image_path;
        } else {
            $return_image = $prev_image;
        }
        return $return_image;
    }
    // upload home slider image
    public function upload_image()
    {
        $prev_image = $this->input->post('old_photo');
        $image = $_FILES['photo']['name'];
        $return_image = '';
        if ($image != '') {
            $destination = './uploads/frontend/slider/';
            $extension = pathinfo($image, PATHINFO_EXTENSION);
            $image_path = 'home-slider-' . time() . '.' . $extension;
            move_uploaded_file($_FILES['photo']['tmp_name'], $destination . $image_path);

            // need to unlink previous slider
            if ($prev_image != '') {
                if (file_exists($destination . $prev_image)) {
                    @unlink($destination . $prev_image);
                }
            }
            $return_image = $image_path;
        } else {
            $return_image = $prev_image;
        }
        return $return_image;
    }

}
