<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Expense_model extends MY_Model
{
    public function __construct()
    {
        parent::__construct();
    }

    // appointment data save and update function
public function nas_save($data)
{
    $get_loggedin_user_id = get_loggedin_user_id();

    // Prepare data to insert/update
    $insert_nas = array(
        'company_name'   => $data['company_name'],
        'product_list'   => $data['product_list'],
        'address'        => $data['address'],
        'price'          => $data['price'],
        'date'           => $data['date'],
        'quantity'       => $data['quantity'],
        'unit'           => $data['unit'],
        'prepared_by'    => $get_loggedin_user_id,
        'updated_at'     => $data['updated_at'],
        'updated_by'     => $get_loggedin_user_id,
        'expense_by'     => isset($data['expense_by']) ? $data['expense_by'] : null,
    );

    // Check if this is an update or an insert
    if (isset($data['id']) && !empty($data['id'])) {
        // Update record
        $this->db->where('id', $data['id']);
        $this->db->update('supplier', $insert_nas);
    } else {
        // ✅ Add created_at only for new record
        $insert_nas['created_at'] = date('Y-m-d H:i:s');

        $this->db->insert('supplier', $insert_nas);
        return $this->db->insert_id();  // Return inserted ID
    }
}

    public function save_nas_profile($data)
    {
        $insert_data = array(
            'nas_id' => $data['nas_id'],
            'name' => $data['ppp_profile']
        );

        if (isset($data['id']) && !empty($data['id'])) {
            $this->db->where('id', $data['id']);
            $this->db->update('nas_profile', $insert_data);
        } else {
            $this->db->insert('nas_profile', $insert_data);
            return $this->db->insert_id();
        }
    }

    public function get_nas_profile_list()
    {
        $this->db->select('nas_profile.*,nas_router.name as nas_name');
        $this->db->from('nas_profile');
        $this->db->join('nas_router', 'nas_profile.nas_id = nas_router.id', 'left');
        return $this->db->get()->result_array();
    }
    public function get_nas_list($RoleID = '', $userID = '')
    {
        $this->db->select('nas_router.*');
        $this->db->from('nas_router');

        ///For Reseller NAS
        if (in_array($RoleID, array(2, 3, 4)) && isset($userID) && !empty($userID) && $userID != 1) {
            $this->db->where('nas_router.assign_to', $userID);
        }
        ///For All NAS
        if (!in_array($RoleID, array(2, 3, 4)) && isset($userID) && !empty($userID) && $userID != 1) {
            $this->db->where('nas_router.assign_to', $userID);
        }
        $this->db->order_by('nas_router.id', 'DESC');
        return $this->db->get()->result_array();
    }
    public function get_expences_details_by_id($id)
    {
        return $this->db->where('id', $id)->get('supplier')->row_array();
    }

    //    public function whereAssignTo($assign_to = null)
    //    {
    //        if (in_array(loggedin_role_id(), [ROLE_RESELLER_ID, ROLE_SUBRESELLER_ID])){
    //            $this->db->where('nas_router.assign_to', $assign_to);
    //        }
    //        return $this;
    //    }
    public function get_nas_details_by_id($id = '')
    {
        $this->db->select('*');
        $this->db->from('nas_router');
        $this->db->where('id', $id);
        $query = $this->db->get();
        return $query->row_array();
    }

    public function get_nas_id_by_package($id = '')
    {
        $this->db->select('nas_id');
        $this->db->from('packages');
        $this->db->where('id', $id);
        $query = $this->db->get();
        $result = $query->row_array();

        return $result['nas_id'] ?? null; // Return nas_id or null if not found
    }
    public function get_count_result($based_on, $id)
    {
        if ($based_on == 'reseller') {
            $this->db->where('assign_to', $id);
        }
        if ($based_on == 'zone') {
            $this->db->where('zone_id', $id);
        }
        if ($based_on == 'olt') {
            $this->db->where('olt_id', $id);
        }
        $this->db->from('staff');
        return $this->db->count_all_results();
    }
    public function get_count_nas_client_status($status, $id)
    {
        if ($status == 'Active') {
            $this->db->where('nas_id', $id);
            $this->db->where('status', 'Active');
        } else {
            $this->db->where('nas_id', $id);
            $this->db->where('status !=', 'Active');
        }
        $this->db->from('staff');
        return $this->db->count_all_results();
    }
}
