<?php
defined('BASEPATH') or exit('No direct script access allowed');

/**
 * @property CI_DB_query_builder $db
 */
class Employee_model extends MY_Model
{
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Insert or update employee data
     */

    public function save(array $data): int
    {
        // Determine assign_to (your existing logic)
        if (!empty($data["assigned_admin"])) {
            $assign_to = $data["assigned_admin"];
        } elseif (!empty($data["assign_to"])) {
            $assign_to = $data["assign_to"];
        } elseif (!empty($data["reseller_subreseller_id"])) {
            $assign_to = $data["reseller_subreseller_id"];
        } else {
            $assign_to = $data["user_id"];
        }

        // Get dial code and mobile number
        $dial_code = isset($data['dial_code']) ? trim($data['dial_code']) : '';
        $mobile_no = isset($data['mobile_no']) ? trim($data['mobile_no']) : '';


        // Combine dial code and mobile number
        $full_mobile_no = $dial_code . $mobile_no;

        $insert_data1 = [
            'assign_to' => $assign_to,

            // Basic Information
            'name' => $data["name"],
            'father_name' => $data["father_name"] ?? null,
            'mother_name' => $data["mother_name"] ?? null,
            'organization' => $data["organization"] ?? null,
            'any_illness' => $data["any_illness"] ?? null,
            'religion' => $data["religion"] ?? null,
            'class' => $data["class"] ?? null,
            'nationality' => $data["nationality"] ?? null,
            'gender' => $data["gender"] ?? null,
            'birthday' => $data["birthday"] ?? null,
            'age' => $data["age"] ?? null,
            'marital_status' => $data["marital_status"] ?? null,
            'trade_licence_number' => $data["trade_licence_number"] ?? null,
            'payment_account' => $data["payment_account"] ?? null,

            // Store combined mobile number
            'mobileno' => $full_mobile_no,

            'email' => $data["email"],
            'address' => $data["address"] ?? null,
            'photo' => $this->app_lib->upload_image('staff'),

            // New Fields
            'position' => $data["position"] ?? null,
            'department' => $data["department"] ?? null,
            'designation' => $data["designation"] ?? null,
            'server_username' => $data["username"],
            'merchant_no' => $data["merchant_no"],




            // Emergency Contact Information
            'guardian' => $data["guardian"] ?? null,
            'relationship' => $data["relationship"] ?? null,
            'guardian_mobile_no' => $data["guardian_mobile_no"] ?? null,
        ];

        // Optional Fields
        if (!empty($data["nid_no"])) $insert_data1['nid_no'] = $data["nid_no"];

        // Network & Product Information
        if (!empty($data["nas_id"])) $insert_data1['nas_id'] = $data["nas_id"];
        if (!empty($data["zone_id"])) $insert_data1['zone_id'] = $data["zone_id"];
        if (!empty($data["olt_id"])) $insert_data1['olt_id'] = $data["olt_id"];
        if (!empty($data["onu_type"])) $insert_data1['onu_type'] = $data["onu_type"];
        if (!empty($data["box"])) $insert_data1['box'] = $data["box"];
        if (!empty($data["onu_serial"])) $insert_data1['onu_serial'] = $data["onu_serial"];
        if (!empty($data["connection_type"])) $insert_data1['connection_type'] = $data["connection_type"];
        if (!empty($data["cable_requirement"])) $insert_data1['cable_requirement'] = $data["cable_requirement"];
        if (!empty($data["fiber_code"])) $insert_data1['fiber_code'] = $data["fiber_code"];
        if (!empty($data["number_of_core"])) $insert_data1['number_of_core'] = $data["number_of_core"];
        if (!empty($data["core_color"])) $insert_data1['core_color'] = $data["core_color"];

        // Server Information
        if (!empty($data["client_type"])) $insert_data1['client_type'] = $data["client_type"];
        if (!empty($data["package_id"])) $insert_data1['package_id'] = $data["package_id"];

        if (!empty($data["expire_date"])) $insert_data1['expire_date'] = $data["expire_date"];
        if (!empty($data["reference_by"])) $insert_data1['reference_by'] = $data["reference_by"];

        // Conditionally add 'idd' if it's not empty or zero
        if (!empty($data["idd"]) && $data["idd"] !== '0') {
            $insert_data1['idd'] = $data["idd"];
        }

        // Login Credential Information
        $insert_data2 = [
            'role' => $data["user_role"],
        ];

        if (!empty($data["username"])) {
            $insert_data2['username'] = $data["username"];
        }

        if (!isset($data['staff_id']) || empty($data['staff_id'])) {
            // Insert new
            $insert_data1['created_by'] = get_loggedin_user_id();
            $insert_data1['staff_id'] = substr(app_generate_hash(), 3, 7);

            $this->db->insert('staff', $insert_data1);
            $staff_id = $this->db->insert_id();

            $insert_data2['active'] = 1;
            $insert_data2['user_id'] = $staff_id;
            $insert_data2['password'] = $this->app_lib->pass_hashed($data["password"]);
            $this->db->insert('login_credential', $insert_data2);

            $insert_data3 = [
                'staff_id' => $staff_id,
                'amount' => 0,
            ];
            $this->db->insert('staff_balance', $insert_data3);
        } else {
            // Update existing
            if (isset($insert_data1['idd'])) {
                $existing_idd = $this->db->select('idd')->from('staff')
                    ->where('id', $data['staff_id'])
                    ->get()->row('idd');

                if ($existing_idd == $insert_data1['idd']) {
                    unset($insert_data1['idd']);
                }
            }

            // Before update, make sure these fields are set if provided
if (isset($data["server_username"])) {
    $insert_data1['server_username'] = $data["server_username"];
}

            $this->db->where('id', $data['staff_id']);
            $this->db->update('staff', $insert_data1);

            $this->db->where('user_id', $data['staff_id']);
            $this->db->where('role !=', 0);
            if (!empty($data["password"])) {
                $insert_data2['password'] = $this->app_lib->pass_hashed($data["password"]);
            }
            $this->db->update('login_credential', $insert_data2);

            $staff_id = $data['staff_id'];
        }

        return $staff_id;
    }



    public function get_client_count_by_status($status)
    {
        if (!in_array($status, [0, 1])) {
            return 0;
        }

        $this->db->where('online', $status);
        $count = $this->db->count_all_results('staff');
        return $count;
    }
    public function update_staff($user_id, $data)
    {
        $this->db->where('id', $user_id);
        return $this->db->update('staff', $data); // Update the staff table with provided data
    }


    public function get_employee_login($user_id)
    {
        $this->db->select('*');
        $this->db->from('login_credential');
        $this->db->where('user_id', $user_id);
        $this->db->limit(1);
        $query = $this->db->get();

        if ($query->num_rows() == 1) {
            return $query->row();
        }
        return false;
    }

    public function update_expired_time($staff_id, $expired_time)
    {
        $this->db->where('id', $staff_id);
        $update_main = $this->db->update('staff', ['expired_time' => $expired_time]);

        if ($update_main) {
            $this->db->where('assign_to', $staff_id);
            $this->db->update('staff', ['expired_time' => $expired_time]);

            return true;
        }

        return false; // Indicate failure
    }


    public function assignTo(int $assignedToId): Employee_model
    {
        $this->db->where('staff.assign_to', $assignedToId);
        return $this;
    }

    // GET Customer ALL DETAILS With role_id = 3
    public function get_customer_list($role_id = 3, $active = 1)
    {
        $this->db->select('staff.id,staff.staff_id,staff.name,staff.mobileno,staff.server_username');
        $this->db->from('staff');
        $this->db->join('login_credential', 'login_credential.user_id = staff.id and login_credential.role != "7"', 'inner');
        $this->db->join('roles', 'roles.id = login_credential.role', 'left');
        $this->db->join('staff_designation', 'staff_designation.id = staff.designation', 'left');
        $this->db->join('staff_department', 'staff_department.id = staff.department', 'left');
        $this->db->where('login_credential.role', $role_id);
        $this->db->where('login_credential.active', $active);
        $this->db->order_by('staff.id', 'ASC');
        $this->db->order_by('roles.id', 'DESC');
        return $this->db->get()->result();
    }

    public function get_customer_list_api($role_id = 3, $active = 1)
    {
        $this->db->select('staff.id,staff.staff_id,staff.name,staff.mobileno,staff.server_username');
        $this->db->from('staff');
        $this->db->join('login_credential', 'login_credential.user_id = staff.id and login_credential.role != "7"', 'inner');
        $this->db->join('roles', 'roles.id = login_credential.role', 'left');
        $this->db->join('staff_designation', 'staff_designation.id = staff.designation', 'left');
        $this->db->join('staff_department', 'staff_department.id = staff.department', 'left');
        $this->db->where('login_credential.role', $role_id);
        $this->db->where('login_credential.active', $active);
        $this->db->order_by('staff.id', 'ASC');
        $this->db->order_by('roles.id', 'DESC');
        return $this->db->get()->result();
    }




    /* // GET STAFF ALL DETAILS
    public function get_employee_list($role_id, $active = 1)
    {
        $this->db->select('staff.*, staff_designation.name as designation_name, staff_department.name as department_name, login_credential.role as role_id, roles.name as role, assigned_admin_user.name as assigned_admin_name, s2_admin.name as admin_name');
        $this->db->from('staff');
        $this->db->join('login_credential', 'login_credential.user_id = staff.id and login_credential.role != "7"', 'inner');
        $this->db->join('roles', 'roles.id = login_credential.role', 'left');
        $this->db->join('staff_designation', 'staff_designation.id = staff.designation', 'left');
        $this->db->join('staff_department', 'staff_department.id = staff.department', 'left');
        $this->db->join('staff as assigned_admin_user', 'assigned_admin_user.merchant_no = staff.assigned_admin', 'left');
        $this->db->join('staff as s2_admin', 'staff.assign_to = s2_admin.id', 'left');
        $this->db->where('login_credential.role', $role_id);
        $this->db->where('login_credential.active', $active);
        $this->db->order_by('staff.id', 'ASC');
        return $this->db->get()->result();
    }
     */

    // GET STAFF ALL DETAILS
    public function get_employee_list($role_id, $userID, $active = 1)
    {
        $this->db->select('
    staff.*, 
    login_credential.role as role_id, 
    roles.name as role, 
    s2_admin.name as admin_name,
    packages.name as package_name,
    (
        SELECT COUNT(*) 
        FROM staff AS clients 
        INNER JOIN login_credential AS lc ON lc.user_id = clients.id 
        WHERE clients.assign_to = staff.id 
          AND lc.role = 4 
          AND lc.active = 1
    ) as total_clients,
    (
        SELECT 
            COALESCE(SUM(nr.selected_breakfast), 0) + 
            COALESCE(SUM(nr.selected_lunch), 0) + 
            COALESCE(SUM(nr.selected_dinner), 0)
        FROM nas_router nr
        WHERE nr.assign_to IN (
            SELECT s2.id 
            FROM staff s2 
            WHERE s2.assign_to = staff.id
        )
    ) as total_meals
');


        $this->db->from('staff');
        $this->db->join('login_credential', 'login_credential.user_id = staff.id AND login_credential.role != "7"', 'inner');
        $this->db->join('roles', 'roles.id = login_credential.role', 'left');
        $this->db->join('staff as s2_admin', 'staff.assign_to = s2_admin.id', 'left');
        $this->db->join('packages', 'packages.id = staff.package_id', 'left');

        $this->db->where('login_credential.active', $active);

        if (!empty($userID) && $userID == 1) {
            $this->db->where('login_credential.role', $role_id);
        }

        if (!empty($userID) && $userID != 1) {
            $this->db->where('staff.assign_to', $userID);
            $this->db->where('login_credential.role', $role_id);
        }

        $this->db->order_by('staff.id', 'DESC');
        $this->db->order_by('roles.id', 'DESC');

        return $this->db->get()->result();
    }



    public function get_employee_list_search($role_id, $userID, $packageID, $active = 1)
    {
        $this->db->select('staff.*,login_credential.role as role_id, roles.name as role,s2_admin.name as admin_name');
        $this->db->select('packages.name as package_name');
        $this->db->from('staff');
        $this->db->join('login_credential', 'login_credential.user_id = staff.id and login_credential.role != "7"', 'inner');
        $this->db->join('roles', 'roles.id = login_credential.role', 'left');
        $this->db->join('staff as s2_admin', 'staff.assign_to = s2_admin.id', 'left');
        $this->db->join('packages', 'packages.id = staff.package_id', 'left');
        if (isset($role_id) && !empty($role_id) && $role_id !== null && $role_id != 1) {
            $this->db->where('login_credential.role', $role_id);
        }

        $this->db->where('login_credential.active', $active);
        /* if (in_array($role_id, array(1, 2, 3))) {
            $this->db->where('staff.assign_to', $userID);
        }
        else{
            $this->db->where('staff.id', $userID);
        } */
        $this->db->where('staff.assign_to', $userID);
        if (isset($packageID) && !empty($packageID) && $packageID !== null) {
            $this->db->where('staff.package_id', $packageID);
        }
        $this->db->order_by('staff.id', 'DESC');
        $this->db->order_by('roles.id', 'DESC');
        return $this->db->get()->result();
    }

    public function get_employee_list_search_inactive($role_id, $userID, $packageID, $active = 0)
    {
        $this->db->select('staff.*,login_credential.role as role_id, roles.name as role,s2_admin.name as admin_name');
        $this->db->select('packages.name as package_name');
        $this->db->from('staff');
        $this->db->join('login_credential', 'login_credential.user_id = staff.id and login_credential.role = "4"', 'inner');
        $this->db->join('roles', 'roles.id = login_credential.role', 'left');
        $this->db->join('staff as s2_admin', 'staff.assign_to = s2_admin.id', 'left');
        $this->db->join('packages', 'packages.id = staff.package_id', 'left');
        if (isset($role_id) && !empty($role_id) && $role_id !== null && $role_id != 1) {
            $this->db->where('login_credential.role', $role_id);
        }

        $this->db->where('login_credential.active', $active);
        /* if (in_array($role_id, array(1, 2, 3))) {
            $this->db->where('staff.assign_to', $userID);
        }
        else{
            $this->db->where('staff.id', $userID);
        } */
        $this->db->where('staff.assign_to', $userID);
        if (isset($packageID) && !empty($packageID) && $packageID !== null) {
            $this->db->where('staff.package_id', $packageID);
        }
        $this->db->order_by('staff.id', 'DESC');
        $this->db->order_by('roles.id', 'DESC');
        return $this->db->get()->result();
    }
    public function update_staff_nas($staff_id, $data)
    {
        $this->db->where('id', $staff_id);
        $this->db->update('staff', $data);
        return $this->db->affected_rows();
    }

    public function get_staff_details_by_id($id = '')
    {
        $this->db->select('*');
        $this->db->from('staff');
        $this->db->where('id', $id);

        return $this->db->get()->row_array();
    }

    public function get_staff_details_by_zone_id($zone_id)
    {
        $this->db->select('*');
        $this->db->from('staff');
        $this->db->where('zone_id', $zone_id);

        return $this->db->get()->result_array();
    }

    public function get_staff_details_by_olt_id($olt_id)
    {
        $this->db->select('*');
        $this->db->from('staff');
        $this->db->where('olt_id', $olt_id);

        return $this->db->get()->result_array();
    }
    public function get_staff_details_by_reseller_id($assign_to)
    {
        $this->db->select('*');
        $this->db->from('staff');
        $this->db->where('assign_to', $assign_to);

        return $this->db->get()->result_array();
    }

    public function get_all_user_names()
    {
        $this->db->select('id,name');
        $this->db->from('staff');
        return $this->db->get()->result_array();
    }

    ///
    public function get_all_payment_method()
    {
        $this->db->select('*');
        $this->db->from('payment_method');
        return $this->db->get()->result_array();
    }

    //
    // GET SINGLE EMPLOYEE DETAILS
    public function get_single_employee($id = null)
    {
        $this->db->select('
            staff.*, 
            staff_designation.name as designation_name,
            staff_department.name as department_name,
            login_credential.role as role_id,
            login_credential.active,
            login_credential.username, 
            roles.name as role,
            staff.assigned_admin,
            packages.name as package_name,
            nas_router.name as nas_name,
            assigned_by.name as assign_to_name
        ');

        $this->db->from('staff');

        // Joins
        $this->db->join('login_credential', 'login_credential.user_id = staff.id AND login_credential.role != "7"', 'inner');
        $this->db->join('roles', 'roles.id = login_credential.role', 'left');
        $this->db->join('staff_designation', 'staff_designation.id = staff.designation', 'left');
        $this->db->join('staff_department', 'staff_department.id = staff.department', 'left');
        $this->db->join('packages', 'packages.id = staff.package_id', 'left');
        $this->db->join('nas_router', 'nas_router.id = staff.nas_id', 'left');

        // 👇 Self join to get assigned staff name
        $this->db->join('staff as assigned_by', 'assigned_by.id = staff.assign_to', 'left');

        // WHERE clause
        $this->db->where('staff.id', $id);

        // Execute
        $query = $this->db->get();
        return $query->row_array();
    }


    // GET Customer ALL DETAILS With role_id = 3
    public function get_all_customer($role_id = 3, $active = 1)
    {
        $this->db->select('staff.id,staff.name,staff.merchant_no');
        $this->db->from('staff');
        $this->db->join('login_credential', 'login_credential.user_id = staff.id and login_credential.role != "7"', 'inner');
        $this->db->join('roles', 'roles.id = login_credential.role', 'left');
        $this->db->join('staff_designation', 'staff_designation.id = staff.designation', 'left');
        $this->db->join('staff_department', 'staff_department.id = staff.department', 'left');
        $this->db->where('login_credential.role', $role_id);
        $this->db->where('login_credential.active', $active);
        $this->db->order_by('staff.id', 'ASC');
        $this->db->order_by('roles.id', 'DESC');
        return $this->db->get()->result();
    }

    // GET Reseller and Sub reseller ALL DETAILS
    public function get_reseller_subreseller_list($role_id, $userID, $active = 1)

    {
        $this->db->select('staff.id,staff.name,staff.merchant_no');
        $this->db->from('staff');
        $this->db->join('login_credential', 'login_credential.user_id = staff.id', 'inner');
        if (isset($userID) && !empty($userID) && $userID == 1) {
            $this->db->where_in('login_credential.role', array(2, 3));
        }
        if (isset($userID) && !empty($userID) && $userID != 1 && in_array($role_id, array(2, 3))) {
            $this->db->where('staff.assign_to', $userID);
            $this->db->where_in('login_credential.role', array(3));
        }
        if (isset($userID) && !empty($userID) && $userID != 1 && isset($role_id) && !empty($role_id) && !in_array($role_id, array(1, 2, 3, 4))) {
            $this->db->where('staff.assign_to', 1);
            $this->db->where_in('login_credential.role', array(2, 3));
        }
        $this->db->order_by('staff.id', 'ASC');
        return $this->db->get()->result();
    }
    public function get_reseller_list($userID, $active = 1)
    {
        $this->db->select('staff.id, staff.name, staff.merchant_no');
        $this->db->from('staff');
        $this->db->join('login_credential', 'login_credential.user_id = staff.id', 'inner');

        // Show only users with role = 2 (reseller)
        $this->db->where('login_credential.role', 2);

        // Optional: if you want to check for assign_to logic for non-admins
        if ($userID != 1) {
            $this->db->where('staff.assign_to', $userID);
        }

        $this->db->order_by('staff.id', 'ASC');
        return $this->db->get()->result();
    }

    // GET Reseller and Sub reseller ALL DETAILS
    public function get_only_client_list($role_id, $userID, $active = 1)
    {
        $this->db->select('staff.id,staff.name,staff.staff_id,staff.merchant_no');
        $this->db->from('staff');
        $this->db->join('login_credential', 'login_credential.user_id = staff.id', 'inner');
        if (isset($userID) && !empty($userID) && $userID != 1) {
            $this->db->where('staff.assign_to', $userID);
            $this->db->where_in('login_credential.role', array(4));
        } else {
            $this->db->where('staff.assign_to', $userID);
            $this->db->where_in('login_credential.role', array(4));
        }
        $this->db->order_by('staff.id', 'ASC');
        return $this->db->get()->result();
    }

    // GET Reseller and Sub reseller ALL DETAILS
    public function get_admin_reseller_subreseller_list($role_id, $userID, $active = 1)
    {
        $this->db->select('staff.id, staff.name, staff.merchant_no, roles.name as role_name');
        $this->db->from('staff');
        $this->db->join('login_credential', 'login_credential.user_id = staff.id', 'inner');
        $this->db->join('roles', 'roles.id = login_credential.role', 'left'); // Joining roles to fetch role_name

        if (isset($userID) && !empty($userID) && $userID == 1) {
            $this->db->where_in('login_credential.role', array(1, 2, 3));
        }
        if (isset($userID) && !empty($userID) && $userID != 1) {
            $this->db->where('staff.assign_to', $userID);
            $this->db->where_in('login_credential.role', array(3));
        }
        if (isset($userID) && !empty($userID) && $userID != 1 && isset($role_id) && !empty($role_id) && !in_array($role_id, array(1, 2, 3, 4))) {
            $this->db->where('staff.assign_to', 1);
        }

        $this->db->order_by('staff.id', 'ASC');
        return $this->db->get()->result();
    }


    // GET Customer ALL DETAILS With role_id = 3
    public function get_all_users($user_id = '', $admin_id = '')
    {
        $this->db->select('*');
        $this->db->from('staff');
        $this->db->where('id !=', 1);
        $this->db->where('id !=', $user_id);

        if (isset($admin_id) && !empty($admin_id) && $user_id != 1) {
            $this->db->where('assign_to', $user_id);
        }
        return $this->db->get()->result();
    }

    //used for employee view in the userlist
    public function get_user_merchant_no($user_id = '')
    {
        $this->db->select('merchant_no');
        $this->db->from('staff');
        if (isset($user_id) && !empty($user_id)) {
            $this->db->where('id', $user_id);
        }
        $this->db->where('merchant_no !=', '90931');
        return $this->db->get()->result_array();
    }

    //////////////////////////////////////////////////////////////////////////////////////////////////
    // GET Customer ALL DETAILS With role_id = 2
    public function get_all_admin($role_id = 2, $active = 1)
    {
        $this->db->select('staff.id,staff.name,staff.merchant_no');
        $this->db->from('staff');
        $this->db->join('login_credential', 'login_credential.user_id = staff.id and login_credential.role != "7"', 'inner');
        $this->db->join('roles', 'roles.id = login_credential.role', 'left');
        $this->db->join('staff_designation', 'staff_designation.id = staff.designation', 'left');
        $this->db->join('staff_department', 'staff_department.id = staff.department', 'left');
        $this->db->where('login_credential.role', $role_id);
        $this->db->where('login_credential.active', $active);
        $this->db->order_by('staff.id', 'ASC');
        $this->db->order_by('roles.id', 'DESC');
        return $this->db->get()->result();
    }
    //////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////////////////
    public function new_merchant_no()
    {
        $this->db->select_max('id');
        $query = $this->db->get('staff');
        $result = $query->row_array();

        if ($result && isset($result['id'])) {
            $last_id = $result['id'] + 1;
        } else {
            $last_id = 1; // If no rows, start with id = 1
        }

        $prefix = "100";
        $formattedId = str_pad($last_id, 3, "0", STR_PAD_LEFT); // Changed width to 3
        return $merchant_no = $prefix . $formattedId;
    }


    //////////////////////////////////////////////////////////////////////////////////////////////////


    public function get_merchant_no($user_id = '')
    {
        $this->db->select('merchant_no');
        $this->db->from('staff');
        if (isset($user_id) && !empty($user_id)) {
            $this->db->where('id', $user_id);
        }
        return $this->db->get()->result_array();
    }

    public function update_reseller_expired_time($reseller_id, $new_expired_time)
    {


        // Update all clients under the reseller
        $this->db->where('reseller_id', $reseller_id);
        $this->db->update('clients', ['expired_time' => $new_expired_time]);

        return true;
    }

    public function update_payment($data)
    {
        $new_payment = $data["add_money"];
        if (!is_numeric($new_payment)) {
            return FALSE;
        }

        // Fetch the current user_balance
        $this->db->select('user_balance');
        $this->db->where('id', $data["profile_id"]);
        $query = $this->db->get('staff');

        if ($query->num_rows() > 0) {
            $current_balance = $query->row()->user_balance;
            // Calculate the new balance
            $new_balance = $current_balance + $new_payment;
        }


        $update_staff = array(
            'user_balance' => $new_balance
        );


        $this->db->where('id', $data['profile_id']);
        $this->db->update('staff', $update_staff);

        if (!empty($data["transaction_id"])) {
            $transaction_id = $data["transaction_id"];
        } else {
            $transaction_id = substr(uniqid(), -8);
        }

        $insert_log = [
            'datetime' => date('Y-m-d H:i:s'),
            'payment_method' => $data["payment_method"],
            'pay_id' => $transaction_id,
            'amount' => $new_payment,
            'payment_from' => $data["userID"],
            'payment_for' => $data["profile_id"],
            'remarks' => $data["remarks"],
            'status' => 'success',
            'manager_id' => $data["userID"],
            'credit_in' => $new_payment,
            'in_tran_id' => $transaction_id,
            'creator_id' => get_loggedin_user_id(),
        ];

        $this->db->insert('payment_logs', $insert_log);
        $staff_id = $this->db->insert_id();
    }


    public function deduce_payment($data)
    {
        $new_payment = $data["deduction_money"];
        if (!is_numeric($new_payment)) {
            return FALSE;
        }

        // Fetch the current user_balance
        $this->db->select('user_balance');
        $this->db->where('id', $data["profile_id"]);
        $query = $this->db->get('staff');

        if ($query->num_rows() > 0) {
            $current_balance = $query->row()->user_balance;
            // Calculate the new balance
            $new_balance = $current_balance - $new_payment;
        }


        $update_staff = array(
            'user_balance' => $new_balance
        );

        $this->db->where('id', $data['profile_id']);
        $this->db->update('staff', $update_staff);

        if (!empty($data["transaction_id"])) {
            $transaction_id = $data["transaction_id"];
        } else {
            $transaction_id = substr(uniqid(), -8);
        }

        $insert_log = array(
            'datetime' => date('Y-m-d H:i:s'),
            'payment_method' => $data["payment_method"],
            'pay_id' => $transaction_id,
            'amount' => $new_payment,
            'payment_from' => $data["userID"],
            'payment_for' => $data["profile_id"],
            'remarks' => $data["remarks"],
            'status' => 'success',
            'manager_id' => $data["userID"],
            'credit_out' => $new_payment,
            'out_tran_id' => $transaction_id,
            'creator_id' => get_loggedin_user_id(),
        );

        $this->db->insert('payment_logs', $insert_log);
        $staff_id = $this->db->insert_id();
    }

    /**
     * @param int $id
     * @param array $data
     */
    public function update(int $id, array $data)
    {
        $this->db->where('id', $id);
        $this->db->update('staff', $data);
    }

    public function find(int $id)
    {
        $sta = 'staff';
        $pac = 'packages';

        $this->db->select("$sta.*");
        $this->db->select("$pac.manager_id as manager_id");
        $this->db->from($sta);
        $this->db->join($pac, "$pac.id = $sta.package_id", 'left');
        $this->db->where("$sta.id", $id);
        $query = $this->db->get();
        return $query->row();
    }

    public function get_search_list($search_text, $logged_user_id)
    {
        $this->db->select('staff.id,staff.name,staff.assign_to,staff.photo,staff.status,staff.user_balance,staff.package_id,staff.zone_id');
        $this->db->select('assigned_staff.name as assigned_name,assigned_package.name as package_name');

        $this->db->from('staff');

        $this->db->join('login_credential customer_credential', 'customer_credential.user_id = staff.id', 'inner');
        $this->db->join('packages as assigned_package', 'assigned_package.id = staff.package_id', 'left');
        $this->db->join('staff as assigned_staff', 'assigned_staff.id = staff.assign_to', 'inner');

        $this->db->group_start();
        $this->db->like('staff.staff_id', $search_text);
        $this->db->or_like('customer_credential.username', $search_text);
        $this->db->or_like('staff.name', $search_text);
        $this->db->or_like('staff.mobileno', $search_text);
        $this->db->or_like('staff.email', $search_text);
        $this->db->group_end();
        $this->db->where('customer_credential.role', ROLE_CUSTOMER_ID);

        if (in_array(loggedin_role_id(), [ROLE_RESELLER_ID, ROLE_SUBRESELLER_ID])) {
            $this->db->where('staff.assign_to', $logged_user_id);
        }

        $this->db->order_by('staff.id', 'ASC');
        return $this->db->get()->result();
    }

    public function getParentInfo(int $userId)
    {
        $this->db->select('assigned_staff.id, assigned_staff.name');
        $this->db->from('staff');
        $this->db->join('login_credential', 'login_credential.user_id = staff.id and login_credential.role != "7"', 'inner');
        $this->db->join('roles', 'roles.id = login_credential.role', 'left');
        $this->db->join('packages as assigned_package', 'assigned_package.id = staff.package_id', 'left');
        $this->db->join('staff as assigned_staff', 'assigned_staff.id = staff.assign_to', 'inner');
        $this->db->where('staff.id', $userId);
        $this->db->order_by('staff.id', 'ASC');
        $this->db->order_by('roles.id', 'DESC');
        return $this->db->get()->row();
    }

    public function get_bill_list($id)
    {
        $this->db->select('MAX(billing.id) as id,billing.bill_no, MAX(billing.status) as status, MAX(billing.paid) as paid, MAX(billing.due) as due, MAX(billing.due_date) as due_date, MAX(billing.date) as date, MAX(billing.hash) as hash');
        $this->db->select('SUM(total-discount+tax_amount) as net_amount');
        $this->db->select('MAX(staff.name) as staff_name, MAX(staff.staff_id) as staff_id, MAX(staff.assign_to) as assign_to');
        $this->db->select('assigned_staff.name as assigned_name');
        $this->db->from('billing');
        $this->db->join('staff', 'staff.id = billing.staff_id', 'left');
        $this->db->join('staff as assigned_staff', 'assigned_staff.id = staff.assign_to', 'inner');
        $this->db->where('billing.staff_id', $id);
        $this->db->group_by('billing.bill_no');
        $this->db->order_by('MAX(billing.id)', 'ASC');
        return $this->db->get()->result_array();
    }

public function get_payment_list($id)
{
    $this->db->select('
        payment_logs.*,
        payment_method.name as payment_method,
        login_credential.role as role_id,
        roles.id as role,
        s1_admin.name as payment,
        s2_admin.merchant_no as creator_merchant_no,
        s1_admin.name as payment_from,
        payment_logs.payment_for as client_id,
        client.name as client_name
    ');

    $this->db->from('payment_logs');
    $this->db->join('login_credential', 'login_credential.user_id = payment_logs.payment_for and login_credential.role = 4', 'inner');
    $this->db->join('roles', 'roles.id = login_credential.role', 'left');
    $this->db->join('staff as s2_admin', 'payment_logs.creator_id = s2_admin.id', 'left');
    $this->db->join('staff as s1_admin', 'payment_logs.payment_from = s1_admin.id', 'left');
    $this->db->join('staff as client', 'payment_logs.payment_for = client.id', 'left'); // Join to get client name
    $this->db->join('payment_method', 'payment_method.id = payment_logs.payment_method', 'left');

    $this->db->where('payment_logs.payment_for', $id);
    $this->db->group_by('payment_logs.id');
    $this->db->order_by('MAX(payment_logs.id)', 'ASC');

    return $this->db->get()->result_array();
}


    public function get_package_change_history($id)
    {
        $this->db->select('package_change_history.*, ');
        $this->db->select('packages.name as from_package_name');
        $this->db->select('packages2.name as to_package_name');
        $this->db->from('package_change_history');
        $this->db->join('packages', 'packages.id = package_change_history.from_package_id', 'left');
        $this->db->join('packages as packages2', 'packages2.id = package_change_history.to_package_id', 'left');
        $this->db->where('profile_id', $id);
        return $this->db->get()->result_array();
    }
    public function get_sms_history($id)
    {
        $this->db->select('sms_logs.*, ');

        $this->db->from('sms_logs');

        $this->db->where('user_id', $id);
        return $this->db->get()->result_array();
    }
}
