<?php
defined('BASEPATH') OR exit('No direct script access allowed');

require '/var/www/html/contact_center/ami_api/php_ami/CouchDB/vendor/autoload.php';
use PHPOnCouch\CouchClient;

class Couchdb_model extends MY_Model {
	
	public function __construct()
    {
        parent::__construct();
    }
	

	public function getNextPhoneNumber($campaignId ='') {

		
		$couchHost = 'http://admin:passw0rd@localhost:5984/';
        $couchDatabase = 'campaign_' . $campaignId;
        $couchClient = new CouchClient($couchHost, $couchDatabase);
		
		
		
        try {
            // Retrieve all documents from the CouchDB database with status=null or empty
            $selector = ['status' => ['$in' => [null, '']]];
            $allDocs = $couchClient->setQueryParameters(['selector' => $selector, 'limit' => 1])->getView('myDesign', 'byStatus')->rows;

            if (!empty($allDocs)) {
                // Return the document ID and phone number
                $doc = $allDocs[0]->value;
					 if (empty($doc->status) || is_null($doc->status)) {
						 return [
								'docId' => $doc->_id,
								'id' => $doc->id,
								'datetime' => $doc->datetime,
								'phone' => $doc->phone,
								'status' => $doc->status,
								'group_name' => $doc->group_name,
								'campaign_id' => $doc->campaign_id,
								'unique_id' => $doc->unique_id,
								'agent_received' => $doc->agent_received,
								'result' => $doc->result,
								'observation' => $doc->observation,
								'last_called_datetime' => $doc->last_called_datetime,
								'call_initiate_datetime' => $doc->call_initiate_datetime,
								'call_ringing_datetime' => $doc->call_ringing_datetime,
								'call_answered_datetime' => $doc->call_answered_datetime,
								'call_hangup_datetime' => $doc->call_hangup_datetime,
								'total_duration' => $doc->total_duration,
								'call_cost' => $doc->call_cost,
								'stt_sentiment' => $doc->stt_sentiment,
								'stt_recordfile' => $doc->stt_recordfile
							];
					 }
					 else {
						return 'Not found';
					 }

            } else {
                return 'Not found';
            }

        } catch (Exception $e) {
            // Handle exceptions
            return null;
        } 
    }


	public function getAllCalledNumbers($campaignId ='') {

		$couchHost = 'http://admin:passw0rd@localhost:5984/';
		$couchDatabase = 'campaign_' . $campaignId;
		$couchClient = new CouchClient($couchHost, $couchDatabase);

		try {
			// Retrieve all documents from the CouchDB database with status=called
			$selector = ['status' => 'called'];
			$allDocs = $couchClient->setQueryParameters(['selector' => $selector])->getView('myDesign', 'byStatus')->rows;

			if (!empty($allDocs)) {
				// Return an array of documents with phone numbers and other details
				$result = [];
				foreach ($allDocs as $doc) {
					$result[] = [
						'docId' => $doc->value->_id,
						'id' => $doc->value->id,
						'datetime' => $doc->value->datetime,
						'phone' => $doc->value->phone,
						'status' => $doc->value->status,
						'group_name' => $doc->value->group_name,
						'campaign_id' => $doc->value->campaign_id,
						'campaign_strategy' => $doc->value->campaign_strategy,
						'unique_id' => $doc->value->unique_id,
						'press_value' => $doc->value->press_value,
						'last_called_datetime' => $doc->value->last_called_datetime,
						'call_initiate_datetime' => $doc->value->call_initiate_datetime,
						'call_ringing_datetime' => $doc->value->call_ringing_datetime,
						'call_answered_datetime' => $doc->value->call_answered_datetime,
						'call_hangup_datetime' => $doc->value->call_hangup_datetime,
						'total_duration' => $doc->value->total_duration,
						'cdr_start_time' => $doc->value->cdr_start_time,
						'cdr_src' => $doc->value->cdr_src,
						'stt_sentiment' => $doc->value->stt_sentiment,
						'stt_recordfile' => $doc->value->stt_recordfile,
						'cdr_disposition' => $doc->value->cdr_disposition,
						'cdr_bill_second' => $doc->value->cdr_bill_second,
						'call_cost' => $doc->value->call_cost
						
					];
				}
				return $result;
			} else {
				return 'Not found';
			}

		} catch (Exception $e) {
			// Handle exceptions
			return null;
		} 
	}
	

	public function getAllCalledNumbersbyDate($campaignId = '', $start_date, $end_date) {

		$couchHost = 'http://admin:passw0rd@localhost:5984/';
		$couchDatabase = 'campaign_' . $campaignId;
		$couchClient = new CouchClient($couchHost, $couchDatabase);
	
		try {
			// Retrieve documents from the CouchDB database between the specified start and end dates with status=called
			$start_date = date('Y-m-d', strtotime($start_date));
			$end_date = date('Y-m-d', strtotime($end_date));
			
			$selector = [
				'status' => 'called',
				'$and' => [
					['datetime' => ['$gte' => $start_date . 'T00:00:00']], // Start of start_date
					['datetime' => ['$lt' => date('Y-m-d', strtotime($end_date . ' + 1 day')) . 'T00:00:00']] // Start of next day after end_date
				]
			];
	
			$allDocs = $couchClient->setQueryParameters(['selector' => $selector])->getView('myDesign', 'byStatus')->rows;
	
			if (!empty($allDocs)) {
				// Return an array of documents with phone numbers and other details
				$result = [];
				foreach ($allDocs as $doc) {
					$result[] = [
						'docId' => $doc->value->_id,
						'id' => $doc->value->id,
						'datetime' => $doc->value->datetime,
						'phone' => $doc->value->phone,
						'status' => $doc->value->status,
						'group_name' => $doc->value->group_name,
						'campaign_id' => $doc->value->campaign_id,
						'campaign_strategy' => $doc->value->campaign_strategy,
						'unique_id' => $doc->value->unique_id,
						'press_value' => $doc->value->press_value,
						'last_called_datetime' => $doc->value->last_called_datetime,
						'call_initiate_datetime' => $doc->value->call_initiate_datetime,
						'call_ringing_datetime' => $doc->value->call_ringing_datetime,
						'call_answered_datetime' => $doc->value->call_answered_datetime,
						'call_hangup_datetime' => $doc->value->call_hangup_datetime,
						'total_duration' => $doc->value->total_duration,
						'cdr_start_time' => $doc->value->cdr_start_time,
						'cdr_src' => $doc->value->cdr_src,
						'stt_sentiment' => $doc->value->stt_sentiment,
						'stt_recordfile' => $doc->value->stt_recordfile,
						'cdr_disposition' => $doc->value->cdr_disposition,
						'cdr_bill_second' => $doc->value->cdr_bill_second,
						'call_cost' => $doc->value->call_cost
						
					];
				}
				return $result;
			} else {
				return 'Not found';
			}
	
		} catch (Exception $e) {
			// Handle exceptions
			return null;
		}
	}
	

	public function updatePhoneNumberStatus($data) {
		$docId = $data['docId'];
		$campaignId = $data['campaignid'];
		$agent_received = $data['agent'];
		$last_called_datetime = $data['datetime'];
		$result = $data['result'];
		$observation = $data['observation'];
		$status = "called";

		$couchHost = 'http://admin:passw0rd@localhost:5984/';
		$couchDatabase = 'campaign_' . $campaignId;
		$couchClient = new CouchClient($couchHost, $couchDatabase);

		try {
			// Get the document by ID
			$doc = $couchClient->getDoc($docId);

			if ($doc) {
				// Update the document fields
				$doc->agent_received = $agent_received;
				$doc->last_called_datetime = $last_called_datetime;
				$doc->result = $result;
				$doc->observation = $observation;
				$doc->status = $status;

				// Save the updated document
				$couchClient->storeDoc($doc);
			}

		} catch (Exception $e) {
			// Handle exceptions
			return false;
		}

		return true;
	}
	
	
	public function deleteDatabase($campaignId ='') {
		
		$couchHost = 'http://admin:passw0rd@localhost:5984/';
		$couchDatabase = 'campaign_' . $campaignId;
		$couchClient = new CouchClient($couchHost, $couchDatabase);

		try {
			// Delete the database
			$couchClient->deleteDatabase();

		} catch (Exception $e) {
			// Handle exceptions
			return false;
		}

		return true;
	}

}