<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Contact_model extends MY_Model
{
    public function __construct()
    {
        parent::__construct();
    }
	
	public function get_contact_list($user_id, $contact_id='')
    {
        $this->db->select('*');
        $this->db->from('contact_list');
		$this->db->where('assigned_to', $user_id);
		if (isset($contact_id) && !empty($contact_id)) {
            $this->db->where('id', $contact_id);
		}
        return $this->db->get()->result_array();
    }
	
	
	public function contact_call_groups($user_id)
    {
        $this->db->select('group');
        $this->db->from('contact_list');
		$this->db->where('assigned_to', $user_id);
		$this->db->group_by('group');
        return $this->db->get()->result_array();
    }
	
		public function save_contact($data)
	{
		$insert_data = array(
            'datetime' => $data['datetime'],
            'name' => $data['name'],
            'phone' => $data['phone'],
			'email' => $data['email'],
			'address' => $data['address'],
			'group_name' => $data['group_name'],
			'assigned_to' => $data['user_id']
        );
		
		if (isset($data['contact_id']) && !empty($data['contact_id'])) {
            $this->db->where('id', $data['contact_id']);
            $this->db->update('contact_list', $insert_data);
        }
            return $this->db->insert_id();
	}
	
	public function update_contact($data)
	{
		$insert_data = array(
            'last_modified' => $data['last_modified'],
            'assigned_to' => $data['user_id'],
            'name' => $data['name'],
			'phone' => $data['phone'],
			'email' => $data['email'],
			'address' => $data['address'],
			'group_name' => $data['group_name']
        );
		
		$this->db->where('id', $data['contact_id']);
        $this->db->update('contact_list', $insert_data);
		return true;
	}
	
	
	
	public function save_assign_to($data)
	{
		// Serialize the agent array
		if (isset($data['selected_agents'])) {
			$selected_agents_str = implode(',', $data['selected_agents']);
		} else {
			$selected_agents_str = '';
		}
		
		// Serialize the agent array
		if (isset($data['selected_customers'])) {
			$selected_customers_str = implode(',', $data['selected_customers']);
		} else {
			$selected_customers_str = '';
		}

		$update_data = array(
            'contact_group' => $data['contact_group'],
			'assigned_to' => '{' . $selected_agents_str . '}',
			'assigned_customers' => '{' . $selected_customers_str . '}',
            'status' => $data['status']
        );
		
		
		if (isset($data['id']) && !empty($data['id'])) {
            $this->db->where('id', $data['id']);
            $this->db->update('contact_assign', $update_data);
        } 
	}
	
	
/* 	public function get_contact_group_list($id='')
    {
        $this->db->select('*');
        $this->db->from('contact_assign');
		if (isset($id) && !empty($id)) {
            $this->db->where('id', $id);
		}
        return $this->db->get()->result_array();
    } */
	
	public function get_contact_group_list($id='')
	{
		$this->db->select('contact_assign.*, staff.name as assigned_to_name');
		$this->db->from('contact_assign');
		$this->db->join('staff', 'staff.id = contact_assign.assigned_to', 'left');
		
		if (isset($id) && !empty($id)) {
			$this->db->where('contact_assign.id', $id);
		}
		
		return $this->db->get()->result_array();
	}

	
	/* public function get_contact_count_by_group()
    {
        $this->db->select('group_name, count(*) as contact_count');
        $this->db->from('contact_list');
		$this->db->group_by('group_name');
        return $this->db->get()->result_array();
    } */
	
	
	
}
