<?php defined('BASEPATH') or exit('No direct script access allowed');

/**
 * Class Client_support_model
 *
 * @property CI_DB_query_builder|CI_DB_mysqli_driver $db
 */
class Client_support_model extends Base_model
{
    protected $table = 'client_support';
    protected $returnType = 'object';

    protected $useTimestamps = true;

    protected $useSoftDelete = true;
    protected $allowedFields = [
        'user_id',
        'complained_number',
        'problem_category',
        'problem_priority',
        'problem_description',
        'assign_to',
        'attachment',
        'created_by',
    ];

    /**
     * @return array[]|object[]
     */
    public function findAll(): array
    {
        $this->prepareSelectQuery();
        return $this->db->get($this->table)->result();
    }

    /**
     * @param int|null $id
     * @return array|mixed|object|null
     */
    public function find(int $id = null)
    {
        $this->prepareSelectQuery();
        return $this->db->get_where($this->table, ['client_support.id' => $id])->row();
    }

    private function prepareSelectQuery()
    {
        $this->db->select('client_support.*');
        $this->db->select('staff.name as client_name');
        $this->db->select('assign_to.name as assign_to_name');
        $this->db->select('support_category.name as problem_category_name');
        $this->db->join('staff', 'staff.id = client_support.user_id', 'left');
        $this->db->join('staff as assign_to', 'assign_to.id = client_support.assign_to', 'left');
        $this->db->join('support_category', 'support_category.id = client_support.problem_category', 'left');
    }

    public function problemCategoryNotIn(...$problem_categories): Client_support_model
    {
        $this->db->where_not_in('client_support.problem_category', $problem_categories);
        return $this;
    }

    public function policy(int $logged_id): Client_support_model
    {
        $this->whereGroupStart()
            ->where('client_support.created_by', $logged_id)
            ->orWhere('client_support.assign_to', $logged_id)
            ->whereGroupEnd();
        return $this;
    }

    public function whereAssignTo($assign_to)
    {
        $this->db->where($this->table . '.assign_to', $assign_to);
        return $this;
    }
}