<?php
defined('BASEPATH') or exit('No direct script access allowed');

/**
 * @property CI_DB_query_builder $db
 * @property App_lib $app_lib
 */
class Billing_model extends MY_Model
{
    public function __construct()
    {
        parent::__construct();
    }

    // patient lab test bill data save function
    public function save_test_bill($data): string
    {
        $status = 1;
        $bill_id = $this->app_lib->get_bill_no('billing');
        $payment_amount = $data['payment_amount'] ?? 0;
        $total_discount = $data['total_discount'] ?? 0;
        $tax_amount = $data['tax_amount'] ?? 0;
        $sub_total_amount = $data['sub_total_amount'] ?? 0;
        $net_amount = $data['net_amount'] ?? 0;
        if ($payment_amount > 0) {
            $status = 2;
        }
        if ($payment_amount == $net_amount) {
            $status = 3;
        }
        $array_bill = array(
            'bill_no' => $bill_id,
            'staff_id' => $data['staff_id'],
            'total' => $sub_total_amount,
            'discount' => $total_discount,
            'tax_amount' => $tax_amount,
            'paid' => $payment_amount,
            'due' => floatval($net_amount - $payment_amount),
			'due_date' => date("Y-m-d", strtotime($data['expire_date'])),
            'status' => $status,
            'date' => date("Y-m-d", strtotime($data['bill_date'])),
            'hash' => app_generate_hash(),
            'prepared_by' => get_loggedin_user_id(),
        );
        $this->db->insert('billing', $array_bill);
        $bill_id = $this->db->insert_id();

        // record payment history save in db
        if ($payment_amount > 1) {
			$transaction_id = substr(uniqid(), -8);
			  $insert_log = [
				'datetime' => date('Y-m-d H:i:s'),
				'payment_method' => $data['pay_via'],
				'pay_id' => $transaction_id,
				'bill_id' => $bill_id,
				'amount' => $payment_amount,
				'payment_from' => get_loggedin_user_id(),
				'payment_for' => $data['staff_id'],
				'remarks' => $data['payment_remarks'],
				'status' => 'success',
				'manager_id' => $this->db->select('assign_to')->where('id', $data['staff_id'])->get('staff')->row()->assign_to,
				'credit_in' => $payment_amount,
				'in_tran_id' => $transaction_id,
				'creator_id' => get_loggedin_user_id(),
				];
			$this->db->insert('payment_logs', $insert_log);
			}

        $items = $data['items'];
        $bill_details = array();
        $total_commission = 0;
        foreach ($items as $item) {

            if ($item['category'] == 2) {
                // inventory reagent here
                $assignedResult = $this->db->get_where('product_assigned', array('test_id' => $item['lab_test']))->result_array();
                foreach ($assignedResult as $assign) {
                    $this->db->where('id', $assign['product_id']);
                    $this->db->set('available_stock', 'available_stock - 1', false);
                    $this->db->update('product');
                }
            }

            $array_bill_details = array(
                'billing_id' => $bill_id,
                'category_id' => $item['category'],
                'test_id' => $item['lab_test'],
                'price' => $item['unit_price'],
                'discount' => $item['dis_amount'],
            );
            $bill_details[] = $array_bill_details;
        }
        $this->db->insert_batch('billing_details', $bill_details);

        return base_url('billing/invoice/' . $bill_id . '/' . $array_bill['hash']);
    }

    // patient lab test bill payment data save function
    public function save_billpayment($data)
    {
        $status = 1;
        $bill_id = $data['bill_id'];
        $payment_amount = $data['payment_amount'];
		 $transaction_id = substr(uniqid(), -8);
		  $insert_log = [
			'datetime' => date('Y-m-d H:i:s'),
			'payment_method' => $data['pay_via'],
			'pay_id' => $transaction_id,
			'bill_id' => $bill_id,
			'amount' => $payment_amount,
			'payment_from' => get_loggedin_user_id(),
			'payment_for' => $data["user_id"],
			'remarks' => $data['remarks'],
			'status' => 'success',
			'manager_id' => $data["assign_to"],
			'credit_in' => $payment_amount,
			'in_tran_id' => $transaction_id,
			'creator_id' => get_loggedin_user_id(),
			'coll_type' => 1,
			];
		$this->db->insert('payment_logs', $insert_log);
        if ($data['getbill']['due'] <= $payment_amount) {
            $status = 3;
        } else {
            $status = 2;
        }
        $sql = "UPDATE billing SET status = " . $status . ", paid = paid + " . $payment_amount . ", due = due - " . $payment_amount . " WHERE id = " . $this->db->escape($bill_id);
        $this->db->query($sql);
    }

    // get patient lab test bill information
    public function get_billing($id)
    {
        $this->db->select('billing.*,SUM(total-discount+tax_amount) as net_amount, staff.assign_to as assign_to, staff.id as user_id, staff.name as p_name,staff.staff_id,staff.mobileno as p_mobileno,staff.address as p_address,IFNULL(staff.age, "0") as p_age');
        $this->db->from('billing');
        $this->db->join('staff', 'staff.id = billing.staff_id', 'left');
        $this->db->where('billing.id', $id);
        return $this->db->get()->row_array();
    }

    // get patient lab test bill payment history
    public function get_paymenthistory($id)
    {
        $this->db->select('payment_logs.*,payment_method.name as pay_via,staff.name as collect_by');
        $this->db->from('payment_logs');
        $this->db->join('payment_method', 'payment_method.id = payment_logs.payment_method', 'left');
        $this->db->join('staff', 'staff.id = payment_logs.creator_id', 'left');
        $this->db->where('payment_logs.bill_id', $id);
        $this->db->order_by('payment_logs.id', 'ASC');
        return $this->db->get()->result_array();
    }

    public function get_billing_details($id)
    {
        $this->db->select('billing_details.*,product.name as product_name, packages.name as package_name,bill_category.name as category_name');
        $this->db->from('billing_details');
        // join product/package table here based on category_id
        $this->db->join('bill_category', 'bill_category.id = billing_details.category_id', 'left');
        $this->db->join('packages', 'packages.id = billing_details.test_id AND billing_details.category_id = 1', 'left');
        $this->db->join('product', 'product.id = billing_details.test_id AND billing_details.category_id = 2', 'left');
        $this->db->where('billing_details.billing_id', $id);
        $this->db->order_by('billing_details.id', 'ASC');
        return $this->db->get()->result_array();
    }

    // get patient lab test bill by date range
    public function get_bill_list($start = '', $end = '')
    {
        $this->db->select('MAX(billing.id) as id,billing.bill_no, MAX(billing.status) as status, MAX(billing.paid) as paid, MAX(billing.due) as due, MAX(billing.due_date) as due_date, MAX(billing.date) as date, MAX(billing.hash) as hash');
        $this->db->select('SUM(total-discount+tax_amount) as net_amount');
        $this->db->select('MAX(staff.name) as staff_name, MAX(staff.staff_id) as staff_id, MAX(staff.assign_to) as assign_to');
		$this->db->select('assigned_staff.name as assigned_name');
        $this->db->from('billing');
        $this->db->join('staff', 'staff.id = billing.staff_id', 'left');
		$this->db->join('staff as assigned_staff', 'assigned_staff.id = staff.assign_to', 'inner');
        if (!empty($start) && !empty($end)) {
            $this->db->where('billing.date >=', $start);
            $this->db->where('billing.date <=', $end);
        }
        if (loggedin_role_id() == 4) {
            $this->db->where('billing.staff_id', get_loggedin_user_id());
        }
        $this->db->group_by('billing.bill_no');
        $this->db->order_by('MAX(billing.id)', 'ASC');
        return $this->db->get()->result_array();
    }

    // get lab test bill due collect report
    public function get_due_collect_report($start = '', $end = '')
    {
        $sql = "SELECT payment_logs.*,billing.bill_no,billing.id as bill_id,billing.date as bill_date,billing.hash,billing.status,
		billing.paid,billing.due,client.name as client_name,client.id as client_id, collect.name as collect_by,payment_method.name as pay_via, users.name as assign_to FROM payment_logs
		LEFT JOIN billing ON billing.id = payment_logs.bill_id LEFT JOIN staff AS client ON client.id = billing.staff_id LEFT JOIN staff AS collect ON
		collect.id = payment_logs.creator_id LEFT JOIN payment_method ON payment_method.id = payment_logs.payment_method LEFT JOIN staff AS users ON users.id = payment_logs.manager_id  WHERE
        payment_logs.coll_type = '1' AND payment_logs.datetime >= " . $this->db->escape($start) . " AND payment_logs.datetime <= " .
            $this->db->escape($end) . " ORDER BY payment_logs.id ASC";
        $query = $this->db->query($sql);
        return $query->result_array();
    }

    // get lab test bill paid/due report
    public function get_bill_duepaid_list($start = '', $end = '', $mode = '')
    {
        $this->db->select('billing.*,SUM(total-discount+tax_amount) as net_amount,client.name as client_name');
		$this->db->select('assigned_staff.name as assigned_name');
        $this->db->from('billing');
        $this->db->join('staff AS client', 'client.id = billing.staff_id', 'left');
		$this->db->join('staff as assigned_staff', 'assigned_staff.id = client.assign_to', 'inner');
        if ($mode == 'due') {
            $this->db->where('billing.status !=', 3);
        } elseif ($mode == 'paid') {
            $this->db->where('billing.status', 3);
        }
        $this->db->where('billing.date >=', $start);
        $this->db->where('billing.date <=', $end);
        $this->db->group_by('billing.bill_no');
        $this->db->order_by('billing.id', 'ASC');
        return $this->db->get()->result_array();
    }
}
