<?php
defined('BASEPATH') or exit('No direct script access allowed');

/**
 * @property App_lib $app_lib
 */
class Authentication_model extends MY_Model
{
    // checking login credential
    public function login_credential($username, $password)
    {
        $this->db->select('*');
        $this->db->from('login_credential');
        $this->db->where('username', $username);
        $this->db->limit(1);
        $query = $this->db->get();

        if ($query->num_rows() == 1) {
            $verify_password = $this->app_lib->verify_password($password, $query->row()->password);
            if ($verify_password) {
                return $query->row();
            }
        }
        return false;
    }
    public function get_employee_login($user_id)
{
    $this->db->select('*');
    $this->db->from('login_credential');
    $this->db->where('user_id', $user_id);
    $this->db->limit(1);
    $query = $this->db->get();

    if ($query->num_rows() == 1) {
        return $query->row();
    }
    return false;
}


    // password forgotten
public function lose_password($username)
{
    if (!empty($username)) {
        $this->db->select('*');
        $this->db->from('login_credential');
        $this->db->where('username', $username);
        $this->db->limit(1);
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            $login_credential = $query->row();

            if ($login_credential->role == 7) {
                $getUser = $this->get_list('patient', array('id' => $login_credential->user_id), true, 'name,email');
            } else {
                $getUser = $this->get_list('staff', array('id' => $login_credential->user_id), true, 'name,email');
            }

            $key = hash('sha512', $login_credential->role . $login_credential->username . app_generate_hash());

            // Remove previous reset requests
            $this->db->where('login_credential_id', $login_credential->id);
            $this->db->delete('reset_password');

            // Insert new reset request
            $arrayReset = array(
                'key' => $key,
                'login_credential_id' => $login_credential->id,
                'username' => $login_credential->username,
            );
            $this->db->insert('reset_password', $arrayReset);

            // Build email content
            $resetUrl = base_url('authentication/pwreset?key=' . $key);
            $confirmationMsg = "
                Dear {$getUser['name']},<br><br>
                We received a request to reset your password.<br><br>
                Please click the link below to set a new password:<br><br>
                <a href='{$resetUrl}' target='_blank'>{$resetUrl}</a><br><br>
                If you did not request this, please ignore this email.<br><br>
                Best regards,<br>
                Food MD
            ";

            // Send email using working Gmail SMTP settings
            $this->load->library('email');
            $this->email->initialize([
                'protocol' => 'smtp',
                'smtp_host' => 'smtp.gmail.com',
                'smtp_port' => 587,
                'smtp_user' => 'khanrobin121222@gmail.com',
                'smtp_pass' => 'ezsd upjt fzwz zvvc',
                'smtp_crypto' => 'tls',
                'mailtype' => 'html',
                'charset' => 'utf-8',
                'newline' => "\r\n",
                'crlf' => "\r\n",
                'smtp_timeout' => 10,
                'wordwrap' => true,
            ]);

            $this->email->from('khanrobin121222@gmail.com', 'Food MD');
            $this->email->to($getUser['email']);
            $this->email->subject('Password Reset Request');
            $this->email->message($confirmationMsg);

            if ($this->email->send()) {
                return true;
            } else {
                log_message('error', 'Email sending failed: ' . $this->email->print_debugger());
            }
        }
    }
    return false;
}

}
