<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Ami_model extends MY_Model
{
    public function __construct()
    {
        parent::__construct();
    }
	
	
	public function initiate_call($data)
	{
		
		$call_to = preg_replace('/\s+/', '', $data['call_to']);
		$caller_id = $data['caller_id'];
		$trunk_name = $this->get_trunk_name($data['trunk'], 'trunk_name');
		$trunk_type = $this->get_trunk_name($data['trunk'], 'trunk_type');
		$type = $data['firstDropdown'];
		if($type=='sound'){
			$play_strategy = 'Basic_Audio_Play';
			$play_type = 'audio_play';
			$play_id = $data['soundFile'];
			$play = $this->get_play_details($play_id, $data['firstDropdown']);
			$play = preg_replace('/\.[^.]+$/', '', $play);
		}
		if($type=='tts'){
			$play_strategy = 'Basic_TTS_Play';
			$play_type = 'tts_play';
			$play = $data['ttsFile'];
		}
		
		$ami_data = $this->get_ami_data();
		$amiHost = $ami_data[0]['host']; // Asterisk server IP
		$amiPort = $ami_data[0]['port']; // Default AMI port
		$amiUsername = $ami_data[0]['username']; // Replace with your AMI username
		$amiPassword = $ami_data[0]['password']; // Replace with your AMI password

		$call_to_length = strlen($call_to);
		if ($call_to_length <=5){
			$to = "$trunk_type/$call_to";
		}
		else{
			$to = "$trunk_type/$call_to@$trunk_name";
		}
		
		$from = "$caller_id";


		// Generate a unique ActionID
		$actionId = uniqid();

		// Connect to AMI
		$socket = fsockopen($amiHost, $amiPort, $errno, $errstr, 10);
		if (!$socket) {
			die("Unable to connect to AMI: $errstr ($errno)\n");
		}

		// Login to AMI
		fwrite($socket, "Action: Login\r\n");
		fwrite($socket, "Username: $amiUsername\r\n");
		fwrite($socket, "Secret: $amiPassword\r\n");
		fwrite($socket, "Events: off\r\n\r\n");

		// Wait for response
		while ($line = fgets($socket)) {
			if (strpos($line, 'Message: Authentication accepted') !== false) {
				break;
			}
		}

		// Initiate the call with ActionID
		fwrite($socket, "Action: Originate\r\n");
		fwrite($socket, "Channel: $to\r\n");
		fwrite($socket, "Exten: s\r\n");
		fwrite($socket, "Context: ami-contact-center\r\n");
		fwrite($socket, "Priority: 1\r\n");
		fwrite($socket, "CallerID: 8766766957\r\n");
		fwrite($socket, "Timeout: 30000\r\n");
		fwrite($socket, "Async: true\r\n");
		fwrite($socket, "Variable: play_strategy=$play_strategy\r\n");
		fwrite($socket, "Variable: play_type=$play_type\r\n");
		fwrite($socket, "Variable: play=$play\r\n");
		fwrite($socket, "ActionID: $actionId\r\n\r\n");

		// Close the connection
		fclose($socket);
		
		
		
		
	}
	
	
	
	
	
	public function save_ami($data)
	{
		$insert_data = array(
            'last_updated' => date('Y-m-d H:i:s'),
            'host' => $data['host'],
            'port' => $data['port'],
            'username' => $data['username'],
            'password' => $data['password'],
			'status' => $data['status']
        );
		
		if (isset($data['ami_id']) && !empty($data['ami_id'])) {
            $this->db->where('id', $data['ami_id']);
            $this->db->update('ami_config', $insert_data);
        }
	}
	
	public function get_ami_data()
    {
        $this->db->select('*');
        $this->db->from('ami_config');
        return $this->db->get()->result_array();
    }
	
	
	public function get_trunk_name($trunk_id,$return_data)
	{
		$this->db->select('*');
		$this->db->from('vb_trunks');
		$this->db->where('id', $trunk_id);
		$query = $this->db->get();
		
		if ($query->num_rows() > 0) {
			$row = $query->row();
			return $row->$return_data;
		} else {
			return 0;
		}
	}
	
	public function get_play_details($play_id, $play_type)
	{
		$table_name = ''; // Initialize the table_name variable
		$play_file = ''; // Initialize the play_file variable

		if ($play_type == 'sound') {
			$table_name = 'vb_sounds';
			$play_file = 'file_name'; // Added missing semicolon
		} elseif ($play_type == 'tts') {
			$table_name = 'vb_tts';
			$play_file = 'tts_text'; // Added missing semicolon
		}

		if (empty($table_name)) {
			// Handle an invalid play_type
			return "Invalid play_type";
		}

		$this->db->select('*');
		$this->db->from($table_name);
		$this->db->where('id', $play_id);
		$query = $this->db->get();

		if ($query->num_rows() > 0) {
			$row = $query->row();
			return $row->$play_file;
		} else {
			return 0;
		}
	}


	
	
}
