<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Accounts_model extends MY_Model
{
	public function __construct()
	{
		parent::__construct();
	}

	// account save and update function
	public function save_accounts($data)
	{
		$obal = (empty($data['opening_balance']) ? 0 : $data['opening_balance']);
		$insert_account = array(
			'name' => $data['account_name'],
			'description' => $data['description'],
		);
		if (isset($data['account_id']) && !empty($data['account_id'])) {
			$this->db->where('id', $data['account_id']);
			$this->db->update('accounts', $insert_account);
		}else{
			$insert_account['balance'] = $obal;
			$this->db->insert('accounts', $insert_account);
			$insert_id = $this->db->insert_id();
			if ($obal > 0) {
				$insertTransaction = array(
					'account_id' => $insert_id,
					'voucher_head_id' => '0',
					'type' => 'income',
					'amount' => $obal,
					'dr' => 0,
					'cr' => $obal,
					'bal' => $obal,
					'date' => date('Y-m-d'),
					'description' => 'Opening Balance'
				);
				$this->db->insert('transactions', $insertTransaction);
			}
		}
	}

	// voucher save function
	public function save_voucher($data)
	{
		$account_id = $data['account_id'];
		$voucher_head_id = $data['voucher_head_id'];
		$voucher_type = $data['voucher_type'];
		$ref_no = $data['ref_no'];
		$amount = $data['amount'];
		$date = $data['date'];
		$pay_via = $data['pay_via'];
		$description = $data['description'];
		$qbal = $this->app_lib->get_table('accounts', $account_id, TRUE);
		$cbal = $qbal['balance'];
		if ($voucher_type == 'income') {
			$cr = $amount;
			$dr = 0;
			$bal = $cbal + $amount;
		}elseif ($voucher_type == 'expense') {
			$cr = 0;
			$dr = $amount;
			$bal = $cbal - $amount;
		}
		$insertTransaction = array(
			'account_id' => $account_id,
			'voucher_head_id' => $voucher_head_id,
			'type' => $voucher_type,
			'ref' => $ref_no,
			'amount' => $amount,
			'dr' => $dr,
			'cr' => $cr,
			'bal' => $bal,
			'date' => date("Y-m-d", strtotime($date)),
			'pay_via' => $pay_via,
			'description' => $description
		);

		$this->db->insert('transactions', $insertTransaction);
		$insert_id = $this->db->insert_id();
		$this->db->where('id', $account_id);
		$this->db->update('accounts', array('balance' => $bal));
		return $insert_id;
	}

	// voucher update function
	public function edit_voucher($data)
	{
		$voucher_head_id = $data['voucher_head_id'];
		$ref_no = $data['ref_no'];
		$date = $data['date'];
		$pay_via = $data['pay_via'];
		$description = $data['description'];

		$insertTransaction = array(
			'voucher_head_id' => $voucher_head_id,
			'ref' => $ref_no,
			'date' => date("Y-m-d", strtotime($date)),
			'pay_via' => $pay_via,
			'description' => $description
		);

		if (isset($data['voucher_old_id']) && !empty($data['voucher_old_id'])) {
			$this->db->where('id', $data['voucher_old_id']);
			$this->db->update('transactions', $insertTransaction);
			$insert_id = $data['voucher_old_id'];
			return $insert_id;
		}
	}

	// get voucher list function
	public function get_voucher_list()
	{
		$sql = "SELECT transactions.*, accounts.name as ac_name, voucher_head.name as v_head, payment_method.name as via_name FROM transactions LEFT JOIN accounts ON accounts.id = transactions.account_id LEFT JOIN voucher_head ON voucher_head.id = transactions.voucher_head_id LEFT JOIN payment_method ON payment_method.id = transactions.pay_via ORDER BY transactions.id ASC";
		return $this->db->query($sql)->result_array();
	}


	// duplicate voucher head check in db
	public function unique_voucher_head($name)
	{
		$voucher_head_id = $this->input->post('voucher_head_id');
		if (!empty($voucher_head_id))
			$this->db->where_not_in('id', $voucher_head_id);
		$this->db->where('name', $name);
		$query = $this->db->get('voucher_head');
		if ($query->num_rows() > 0){
			if (!empty($voucher_head_id)){
				set_alert('error', "The Voucher Head name are already used");
			}else{
				$this->form_validation->set_message("unique_voucher_head", "The %s name are already used.");
			}
			return FALSE;
		}else{
			return TRUE;
		}
	}

	// duplicate account name check in db
	public function unique_account_name($name)
	{
		$account_id = $this->input->post('account_id');
		if (!empty($account_id))
			$this->db->where_not_in('id', $account_id);
		$this->db->where('name', $name);
		$query = $this->db->get('accounts');
		if ($query->num_rows() > 0){
			$this->form_validation->set_message("unique_account_name", "The %s name are already used.");
			return FALSE;
		}else{
			return TRUE;
		}
	}
}