<?php defined('BASEPATH') or exit('No direct script access allowed');


class DatatablesBuilder
{

    private $CI;
    private $searchable = array();
    private $style = '';
    private $connection = 'default';

    private $dt_options = array(
        'searchDelay' => '500',
        'autoWidth' => 'false'
    );
    private $ax_options = '';

    /**
     * Load the necessary library from codeigniter and caching the query
     * We use Codeigniter Active Record to generate query
     */
    public function __construct()
    {
        $this->CI = &get_instance();

        $this->_db = $this->CI->load->database($this->connection, TRUE);
        $this->CI->load->helper('url');
        $this->CI->load->library('table');

        $this->_db->start_cache();
    }

    public function __destruct()
    {
        $this->_db->stop_cache();
        $this->_db->flush_cache();
    }

    /**
     * Select column want to fetch from database
     *
     * @param string
     * @return object
     */
    public function select($columns)
    {
        $this->_db->select($columns);

        $this->searchable = $columns;
        return $this;
    }
    public function get_employee_list_search($role_id, $userID, $zoneID, $packageID, $start = null, $end = null, $active = 1)
    {
        $loggedID = get_loggedin_user_id();

        $this->_db->select('
        staff.*,
        login_credential.role as role_id,
        roles.name as role,
        s2_admin.name as admin_name,
        s2_admin.merchant_no as admin_id,
        zones.name as zone_name,
        packages.name as package_name,
DATE_FORMAT(staff.created_at, "%d-%m-%Y %h:%i %p") as created_at_formatted

        ');
        $this->_db->from('staff');
        $this->_db->join('login_credential', 'login_credential.user_id = staff.id and login_credential.role = "4"', 'inner');
        $this->_db->join('roles', 'roles.id = login_credential.role', 'left');
        $this->_db->join('staff as s2_admin', 'staff.assign_to = s2_admin.id', 'left');
        $this->_db->join('packages', 'packages.id = staff.package_id', 'left');
        $this->_db->join('zones', 'zones.id = staff.zone_id', 'left');

        if ($loggedID != 1) {
            if (!empty($userID)) {
                if ($userID == $loggedID && !in_array($role_id, array(2, 3))) {
                    $this->_db->where('staff.assign_to', 1);
                } else {
                    $this->_db->where('staff.assign_to', $userID);
                }
            }
        }

        if (!empty($zoneID)) {
            $this->_db->where('staff.zone_id', $zoneID);
        }

        if (!empty($packageID)) {
            $this->_db->where('staff.package_id', $packageID);
        }

        if (!is_null($start) && !is_null($end)) {
            $this->_db->where('staff.created_at >=', $start);
            $this->_db->where('staff.created_at <=', $end);
        }


        $this->table = 'staff';
        $this->searchable = 'staff.id, staff.idd, staff.name, staff.mobileno, staff.server_username, staff.created_at';

        return $this->_db;
    }

    public function get_recharge_logs_filter($RoleID, $userID, $start = null, $end = null)
    {
        $loggedID = get_loggedin_user_id();
        $this->_db->select('payment_logs.*,payment_method.name as payment_method,login_credential.role as role_id, roles.id as role,s2_admin.name as payment_for,s1_admin.name as payment_from');
        $this->_db->from('payment_logs');
        $this->_db->join('login_credential', 'login_credential.user_id = payment_logs.payment_for and login_credential.role != 4', 'inner');
        $this->_db->join('roles', 'roles.id = login_credential.role', 'left');
        $this->_db->join('staff as s2_admin', 'payment_logs.payment_for = s2_admin.id', 'left');
        $this->_db->join('staff as s1_admin', 'payment_logs.payment_from = s1_admin.id', 'left');
        $this->_db->join('payment_method', 'payment_method.id = payment_logs.payment_method', 'left');
        if (isset($userID) && !empty($userID) && $userID != 1 && isset($RoleID) && !empty($RoleID) && !in_array($RoleID, array(2, 3, 4))) {
            $this->_db->where('payment_logs.manager_id', $loggedID);
            if ($loggedID != $userID) {
                $this->_db->where('payment_logs.payment_for', $userID);
            }
        } else {
            $this->_db->where('payment_logs.manager_id', $loggedID);
            if ($loggedID != $userID) {
                $this->_db->where('payment_logs.payment_for', $userID);
            }
        }
        if (!is_null($start) && !is_null($end)) {
            $this->_db->where('DATE(datetime) >=', $start);
            $this->_db->where('DATE(datetime) <=', $end . ' 23:59:59');
        }

        $this->table = 'payment_logs';
        $this->searchable = 'payment_logs.payment_method, payment_logs.pay_id';
        return $this->_db;
    }

    public function get_client_payment_logs_filter($RoleID, $userID, $start = null, $end = null)
    {
        $loggedID = get_loggedin_user_id();
        $this->_db->select('payment_logs.*,payment_method.name as payment_method,login_credential.role as role_id, roles.id as role,s2_admin.name as payment_for,s1_admin.name as payment_from');
        $this->_db->from('payment_logs');
        $this->_db->join('login_credential', 'login_credential.user_id = payment_logs.payment_for and login_credential.role = 4', 'inner');
        $this->_db->join('roles', 'roles.id = login_credential.role', 'left');
        $this->_db->join('staff as s2_admin', 'payment_logs.payment_for = s2_admin.id', 'left');
        $this->_db->join('staff as s1_admin', 'payment_logs.payment_from = s1_admin.id', 'left');
        $this->_db->join('payment_method', 'payment_method.id = payment_logs.payment_method', 'left');
        if (isset($userID) && !empty($userID) && $userID != 1 && isset($RoleID) && !empty($RoleID) && !in_array($RoleID, array(2, 3, 4))) {
            $this->_db->where('payment_logs.manager_id', $loggedID);
            if ($loggedID != $userID) {
                $this->_db->where('payment_logs.payment_for', $userID);
            }
        } else {
            $this->_db->where('payment_logs.manager_id', $loggedID);
            if ($loggedID != $userID) {
                $this->_db->where('payment_logs.payment_for', $userID);
            }
        }
        if (!is_null($start) && !is_null($end)) {
            $this->_db->where('DATE(datetime) >=', $start);
            $this->_db->where('DATE(datetime) <=', $end);
        }

        if (in_array(loggedin_role_id(), [ROLE_RESELLER_ID, ROLE_SUBRESELLER_ID])) {
            $this->_db->where('payment_logs.manager_id', $loggedID);
        }

        $this->table = 'payment_logs';
        $this->searchable = 'payment_logs.payment_method, payment_logs.pay_id';
        return $this->_db;
    }

    public function get_client_expences_logs($RoleID, $userID, $start = null, $end = null)
    {
        $loggedID = get_loggedin_user_id();

        $this->_db->select('
        payment_logs.*,
        payment_method.name as payment_method,
        login_credential.role as role_id,
        roles.id as role,
        s2_admin.name as payment_for,
        s2_admin.id as client_id, 
        s1_admin.name as payment_from,
        branch_admin.name as branch_name,
                branch_admin.merchant_no as branch_id,
        DATE(payment_logs.datetime) AS date_only,
        DATE_FORMAT(payment_logs.datetime, "%h:%i %p") AS time_only
    ');

        $this->_db->from('payment_logs');

        $this->_db->join('login_credential', 'login_credential.user_id = payment_logs.payment_for AND login_credential.role = 4', 'inner');
        $this->_db->join('roles', 'roles.id = login_credential.role', 'left');
        $this->_db->join('staff as s2_admin', 'payment_logs.payment_for = s2_admin.id', 'left');
        $this->_db->join('staff as s1_admin', 'payment_logs.payment_from = s1_admin.id', 'left');
        $this->_db->join('staff as branch_admin', 'payment_logs.manager_id = branch_admin.id', 'left'); 
        $this->_db->join('payment_method', 'payment_method.id = payment_logs.payment_method', 'left');

        // Access control based on Role and User
        if (!($RoleID == 1 && $userID == 1)) {
            if (isset($userID) && !empty($userID) && $userID != 1 && isset($RoleID) && !empty($RoleID) && !in_array($RoleID, array(2, 3, 4))) {
                $this->_db->where('payment_logs.manager_id', $loggedID);
                if ($loggedID != $userID) {
                    $this->_db->where('payment_logs.payment_for', $userID);
                }
            } else {
                $this->_db->where('payment_logs.manager_id', $loggedID);
                if ($loggedID != $userID) {
                    $this->_db->where('payment_logs.payment_for', $userID);
                }
            }

            if (in_array(loggedin_role_id(), [ROLE_RESELLER_ID, ROLE_SUBRESELLER_ID])) {
                $this->_db->where('payment_logs.manager_id', $loggedID);
            }
        }

        // Date range filter
        if (!is_null($start) && !is_null($end)) {
            $this->_db->where('DATE(datetime) >=', $start);
            $this->_db->where('DATE(datetime) <=', $end);
        }

        $this->table = 'payment_logs';
        $this->searchable = 'payment_logs.payment_for';

        return $this->_db;
    }


    public function get_client_support_ticket_filter($userID, $start = null, $end = null, $editable = true)
    {
        $loggedId = get_loggedin_user_id();
        $this->_db->select('client_support.*');
        $this->_db->select('staff.name as client_name,assign_to.name as assign_to_name');
        $this->_db->select('support_category.name as problem_category_name');
        $this->_db->from('client_support');
        $this->_db->join('staff', 'staff.id = client_support.user_id', 'left');
        $this->_db->join('staff AS assign_to', 'assign_to.id = client_support.assign_to', 'left');
        $this->_db->join('support_category', 'support_category.id = client_support.problem_category', 'left');
        $this->_db->where('support_category.editable', $editable);
        $this->_db->group_start();
        $this->_db->where('client_support.assign_to', $loggedId);
        $this->_db->or_where('client_support.created_by', $loggedId);
        $this->_db->group_end();


        if (!is_null($start) && !is_null($end)) {
            $this->_db->where('client_support.created_at >= ', $start);
            $this->_db->where('client_support.created_at <= ', $end);
        }

        if ($loggedId != $userID) {
            $this->_db->where('client_support.user_id', $userID);
        }

        if (in_array(loggedin_role_id(), [ROLE_RESELLER_ID, ROLE_SUBRESELLER_ID])) {
            $this->_db->where('client_support.assign_to', $loggedId);
        }

        $this->table = 'client_support';
        $this->searchable = 'client_support.user_id';
        return $this->_db;
    }
    public function get_client_expences($RoleID, $userID, $start = null, $end = null)
    {
        $loggedID = get_loggedin_user_id();
        $loggedRoleID = loggedin_role_id();

        $this->_db->select("
        supplier.*,
        CONCAT(FORMAT(price, 0), ' Tk') AS price_formatted,
        CONCAT(quantity, ' ', unit) AS quantity_unit,
        DATE(supplier.date) AS date_only,
        DATE_FORMAT(supplier.date, '%h:%i %p') AS time_only,
        staff.name AS prepared_by_name,
        staff.merchant_no AS prepared_by_merchant
    ");
        $this->_db->from('supplier');
        $this->_db->join('staff', 'staff.id = supplier.prepared_by', 'left');

        // Role-based filtering
        if (!($RoleID == 1 && $userID == 1)) {
            if (in_array($loggedRoleID, [ROLE_RESELLER_ID, ROLE_SUBRESELLER_ID])) {
                $this->_db->where('supplier.prepared_by', $loggedID);
            } else {
                if (!empty($userID) && $userID != 1) {
                    $this->_db->where('supplier.prepared_by', $userID);
                } else {
                    $this->_db->where('supplier.prepared_by', $loggedID);
                }
            }
        }

        // Filter by date range if provided
        if (!is_null($start) && !is_null($end)) {
            $this->_db->where('DATE(supplier.created_at) >=', $start);
            $this->_db->where('DATE(supplier.created_at) <=', $end);
        } else {
            // 🔸 Filter by current month using created_at
            $this->_db->where("DATE_FORMAT(supplier.created_at, '%Y-%m') =", date('Y-m'));
        }

        $this->_db->order_by('supplier.created_at', 'DESC');

        $this->table = 'supplier';
        $this->searchable = 'supplier.company_name';

        return $this->_db->get()->result_array();
    }



    public function get_client_sms_logs_filter($userID, $start = null, $end = null)
    {
        $loggedId = get_loggedin_user_id();
        $this->_db->select('sms_logs.*');
        $this->_db->select('staff.name as client_name,assign_to.name as assign_to_name');
        $this->_db->from('sms_logs');
        $this->_db->join('staff', 'staff.id = sms_logs.user_id', 'left');
        $this->_db->join('staff AS assign_to', 'assign_to.id = sms_logs.assign_to', 'left');
        $this->_db->group_start();
        $this->_db->where('sms_logs.assign_to', $loggedId);
        $this->_db->or_where('sms_logs.creator_id', $loggedId);
        $this->_db->group_end();


        if (!is_null($start) && !is_null($end)) {
            $this->_db->where('sms_logs.created_at >= ', $start);
            $this->_db->where('sms_logs.created_at <= ', $end);
        }

        if ($loggedId != $userID) {
            $this->_db->where('sms_logs.user_id', $userID);
        }

        if (in_array(loggedin_role_id(), [ROLE_RESELLER_ID, ROLE_SUBRESELLER_ID])) {
            $this->_db->where('sms_logs.assign_to', $loggedId);
        }

        $this->table = 'sms_logs';
        $this->searchable = 'sms_logs.user_id';
        return $this->_db;
    }

    public function get_client_refund_logs_filter($userID, $start = null, $end = null)
    {
        $CI = &get_instance();
        $loggedId = get_loggedin_user_id();
        $loggedRoleId = loggedin_role_id();

        $this->_db->select('refund.*');
        $this->_db->from('refund');

        // ------------------------------
        // NEW: Get manager's merchant_no
        // ------------------------------
        $manager_id = null;

        if (!empty($userID)) {
            // Step 1: Get assign_to from staff where id = $userID (idd)
            $CI->db->select('assign_to');
            $CI->db->from('staff');
            $CI->db->where('id', $userID);
            $assign_result = $CI->db->get()->row_array();

            if (!empty($assign_result['assign_to'])) {
                $assign_to = $assign_result['assign_to'];

                // Step 2: Get merchant_no of the assign_to (manager)
                $CI->db->select('merchant_no');
                $CI->db->from('staff');
                $CI->db->where('id', $assign_to);
                $manager_result = $CI->db->get()->row_array();

                if (!empty($manager_result['merchant_no'])) {
                    $manager_id = $manager_result['merchant_no'];
                    // You can now use $manager_id for further filtering if needed
                }
            }
        }

        // Role 2 = Manager
        if ($loggedRoleId == 2) {
            // Get staff assigned to this manager
            $CI->db->select('id');
            $CI->db->from('staff');
            $CI->db->where('assign_to', $loggedId);
            $staffs = $CI->db->get()->result_array();

            $assigned_ids = array_column($staffs, 'id');
            $assigned_ids[] = $loggedId; // Include self

            $this->_db->where_in('refund.refunded_by', $assigned_ids);
        } elseif (in_array($loggedRoleId, [ROLE_RESELLER_ID, ROLE_SUBRESELLER_ID])) {
            $CI->db->select('id');
            $CI->db->from('staff');
            $CI->db->where('assign_to', $loggedId);
            $staffs = $CI->db->get()->result_array();

            $assigned_ids = array_column($staffs, 'id');
            $assigned_ids[] = $loggedId;

            $this->_db->where_in('refund.refunded_by', $assigned_ids);
        } else {
            // Admin or other roles
            if (!empty($userID) && $userID != 1) {
                $this->_db->where('refund.refunded_by', $userID);
            }
        }

        // Date range filtering
        if (!is_null($start) && !is_null($end)) {
            $this->_db->where('refund.refunded_at >=', $start);
            $this->_db->where('refund.refunded_at <=', $end);
        }

        $this->table = 'refund';
        $this->searchable = 'refund.student_name';

        return $this->_db;
    }


    public function get_branch_summery($userID, $start = null, $end = null, $RoleID = '', $packageID = '', $student_id = '')
    {
        $CI = &get_instance();
        $loggedId = get_loggedin_user_id();
        $loggedRoleId = loggedin_role_id();

        $this->_db->select('
        nas_router.*,
        MAX(refund.id) as refund_id,
        MAX(refund.status) as refund_status,
        staff.merchant_no as branch_id -- ✅ Get Branch ID from staff table (via assign_to)
    ');

        $this->_db->from('nas_router');

        // Join refund table for status info
        $this->_db->join('refund', 'refund.request_id = nas_router.id', 'left');

        // ✅ Join staff table using assign_to => staff.id
        $this->_db->join('staff', 'nas_router.assign_to = staff.id', 'left');

        $this->_db->group_by('nas_router.id');

        // Role-based filtering
        if (in_array($loggedRoleId, [ROLE_RESELLER_ID, ROLE_SUBRESELLER_ID])) {
            $CI->db->select('id');
            $CI->db->from('staff');
            $CI->db->where('assign_to', $loggedId);
            $staffs = $CI->db->get()->result_array();

            $assigned_ids = array_column($staffs, 'id');
            $assigned_ids[] = $loggedId;

            $this->_db->where_in('nas_router.assign_to', $assigned_ids);
        } else {
            if (!empty($userID) && $userID != 1) {
                $this->_db->where('nas_router.assign_to', $userID);
            }
        }

        // Package filter
        if (!empty($packageID)) {
            $this->_db->where('nas_router.package_id', $packageID);
        }

        // Student ID filter
        if (!empty($student_id)) {
            $this->_db->where('nas_router.idd', $student_id);
        }

        // Date range filter
        if (!is_null($start) && !is_null($end)) {
            $this->_db->where('nas_router.created_at >=', $start);
            $this->_db->where('nas_router.created_at <=', $end);
        }

        $this->table = 'nas_router';
        $this->searchable = 'nas_router.selected_dates';

        return $this->_db;
    }

    public function get_expense_logs($userID = null, $start = null, $end = null)
    {
        $CI = &get_instance();
        $get_loggedin_user_id = get_loggedin_user_id();
        $loggedRoleId = loggedin_role_id();

        // Get current staff ID
        $CI->db->select('id');
        $CI->db->from('staff');
        $CI->db->where('id', $get_loggedin_user_id);
        $staffRow = $CI->db->get()->row();
        $staffID = $staffRow ? $staffRow->id : 0;

        // Select supplier fields and additional formatting
        $this->_db->select("
        supplier.*, 
        CONCAT(FORMAT(price, 0), ' Tk') AS price_formatted,
        CONCAT(quantity, ' ', unit) AS quantity_unit,
        staff.name AS prepared_by_name
    ");

        $this->_db->from('supplier');
        $this->_db->join('staff', 'staff.id = supplier.prepared_by', 'left');

        if ($loggedRoleId == 2) {
            $this->_db->where('supplier.prepared_by', $staffID);
        }

        // Filter by date range
        if (!is_null($start) && !is_null($end)) {
            $this->_db->where('supplier.date >=', $start);
            $this->_db->where('supplier.date <=', $end);
        }

        $this->_db->order_by('supplier.date', 'DESC');

        $this->table = 'supplier';
        $this->searchable = 'supplier.company_name';

        return $this->_db->get()->result_array();
    }

    public function get_meal_order_logs_filter($userID, $start = null, $end = null, $RoleID = '', $packageID = '', $student_id = '')
    {
        $CI = &get_instance();
        $loggedId = get_loggedin_user_id();
        $loggedRoleId = loggedin_role_id();

        $this->_db->select('
        nas_router.*,
        staff.assign_to as branch_id,
        branch.merchant_no as branch_merchant_no, -- Get merchant_no from branch
        MAX(refund.id) as refund_id,
        MAX(refund.status) as refund_status
    ');
        $this->_db->from('nas_router');
        $this->_db->join('refund', 'refund.request_id = nas_router.id', 'left');

        // First join: Get staff info from nas_router.assign_to
        $this->_db->join('staff', 'staff.id = nas_router.assign_to', 'left');

        // Second join: Get merchant_no from staff.assign_to (branch)
        $this->_db->join('staff as branch', 'branch.id = staff.assign_to', 'left');

        $this->_db->group_by('nas_router.id');

        // Reseller/Subreseller filtering
        if (in_array($loggedRoleId, [ROLE_RESELLER_ID, ROLE_SUBRESELLER_ID])) {
            $CI->db->select('id');
            $CI->db->from('staff');
            $CI->db->where('assign_to', $loggedId);
            $staffs = $CI->db->get()->result_array();

            $assigned_ids = array_column($staffs, 'id');
            $assigned_ids[] = $loggedId;

            $this->_db->where_in('nas_router.assign_to', $assigned_ids);
        } else {
            if (!empty($userID) && $userID != 1) {
                $this->_db->where('nas_router.assign_to', $userID);
            }
        }

        // Filters
        if (!empty($packageID)) {
            $this->_db->where('nas_router.package_id', $packageID);
        }

        if (!empty($student_id)) {
            $this->_db->where('nas_router.idd', $student_id);
        }

        if (!is_null($start) && !is_null($end)) {
            $this->_db->where('nas_router.created_at >=', $start);
            $this->_db->where('nas_router.created_at <=', $end);
        }

        $this->table = 'nas_router';
        $this->searchable = 'nas_router.selected_dates';

        return $this->_db;
    }

    public function get_branch_hisotry($userID, $start = null, $end = null)
    {
        $loggedId = get_loggedin_user_id();

        $this->_db->select('staff.*');

        // Count total clients assigned to merchant
        $this->_db->select('(SELECT COUNT(*) FROM staff AS s WHERE s.assign_to = staff.id) AS total_client');

        // Sum total meals from nas_router for clients of this merchant
        $this->_db->select('(
        SELECT IFNULL(SUM(nr.selected_breakfast + nr.selected_lunch + nr.selected_dinner), 0)
        FROM staff AS c
        LEFT JOIN nas_router AS nr ON nr.assign_to = c.id
        WHERE c.assign_to = staff.id
    ) AS total_meal');

        // Sum total meal cost from nas_router
        $this->_db->select('(
        SELECT IFNULL(SUM(nr.total_amount), 0)
        FROM staff AS c2
        LEFT JOIN nas_router AS nr ON nr.assign_to = c2.id
        WHERE c2.assign_to = staff.id
    ) AS total_meal_cost');

        // Sum total expense from supplier
        $this->_db->select('(
        SELECT IFNULL(SUM(supplier.price), 0)
        FROM supplier
        WHERE supplier.prepared_by = staff.id
    ) AS total_expense');

        // Sum total income from payment_logs (can keep for reference)
        $this->_db->select('(
        SELECT IFNULL(SUM(payment_logs.amount), 0)
        FROM payment_logs
        WHERE payment_logs.payment_from = staff.id
    ) AS total_income');

        // Total credit amount from payment_logs by manager_id
        $this->_db->select('(
        SELECT IFNULL(SUM(pl.credit_in), 0)
        FROM payment_logs AS pl
        WHERE pl.manager_id = staff.id
    ) AS total_credit_amount');

        // Profit or loss based on meal cost - expense
        $this->_db->select('(
        (
            SELECT IFNULL(SUM(nr.total_amount), 0)
            FROM nas_router AS nr
            LEFT JOIN staff AS c ON nr.assign_to = c.id
            WHERE c.assign_to = staff.id
        ) -
        (
            SELECT IFNULL(SUM(supplier.price), 0)
            FROM supplier
            WHERE supplier.prepared_by = staff.id
        )
    ) AS total_profit_loss');

        // Profit only if meal cost > expense
        $this->_db->select('(
        CASE
            WHEN (
                (SELECT IFNULL(SUM(nr.total_amount), 0)
                 FROM nas_router AS nr
                 LEFT JOIN staff AS c ON nr.assign_to = c.id
                 WHERE c.assign_to = staff.id)
                >
                (SELECT IFNULL(SUM(supplier.price), 0)
                 FROM supplier
                 WHERE supplier.prepared_by = staff.id)
            )
            THEN (
                (SELECT IFNULL(SUM(nr.total_amount), 0)
                 FROM nas_router AS nr
                 LEFT JOIN staff AS c ON nr.assign_to = c.id
                 WHERE c.assign_to = staff.id) -
                (SELECT IFNULL(SUM(supplier.price), 0)
                 FROM supplier
                 WHERE supplier.prepared_by = staff.id)
            )
            ELSE 0
        END
    ) AS total_profit');

        // Loss only if expense > meal cost
        $this->_db->select('(
        CASE
            WHEN (
                (SELECT IFNULL(SUM(supplier.price), 0)
                 FROM supplier
                 WHERE supplier.prepared_by = staff.id)
                >
                (SELECT IFNULL(SUM(nr.total_amount), 0)
                 FROM nas_router AS nr
                 LEFT JOIN staff AS c ON nr.assign_to = c.id
                 WHERE c.assign_to = staff.id)
            )
            THEN ABS(
                (SELECT IFNULL(SUM(nr.total_amount), 0)
                 FROM nas_router AS nr
                 LEFT JOIN staff AS c ON nr.assign_to = c.id
                 WHERE c.assign_to = staff.id) -
                (SELECT IFNULL(SUM(supplier.price), 0)
                 FROM supplier
                 WHERE supplier.prepared_by = staff.id)
            )
            ELSE 0
        END
    ) AS total_loss');

        // Sum unused balance of all clients under this merchant
        $this->_db->select('(
        SELECT IFNULL(SUM(s.user_balance), 0)
        FROM staff AS s
        WHERE s.assign_to = staff.id
    ) AS unused_balance');

        // Base table
        $this->_db->from('staff');
        $this->_db->where('staff.merchant_no IS NOT NULL');

        // Exclude logged-in superadmin user (optional)
        if ($loggedId == 1) {
            $this->_db->where('staff.id !=', 1);
        }

        // Optionally apply date filters if $start and $end are provided
        if ($start && $end) {
            $this->_db->where("staff.created_at >=", $start);
            $this->_db->where("staff.created_at <=", $end);
        }

        // Set table and searchable fields (if using for datatables or pagination)
        $this->table = 'staff';
        $this->searchable = 'staff.name, staff.merchant_no';

        return $this->_db;
    }


    public function distinct($columns)
    {

        $this->_db->select('user_id,COUNT(user_id) as total,SUM(route_rate) as route_rate,SUM(sms_rate) as sms_rate');
        $this->_db->group_by('user_id');
        //$this->_db->select($columns);
        //$this->_db->order_by('user_id', 'desc');
        $this->searchable = $columns;
        return $this;
    }

    public function from($table)
    {
        $this->_db->from($table);

        $this->table = $table;
        return $this->_db;
    }

    public function where($data, $table)
    {
        $this->_db->where($data);

        $this->table = $table;
        return $this->_db;
    }

    public function like($data, $table)
    {
        $this->_db->like($data);

        $this->table = $table;
        return $this->_db;
    }

    public function style($data)
    {
        foreach ($data as $option => $value) {
            $this->style .= "$option=\"$value\"";
        }

        return $this;
    }

    /**
     * Set heading for the table
     *
     * @param string $label heading label
     * @param string $source column names
     * @param method $function formatting the output
     * @return object
     */
    public function column($label, $source, $function = null)
    {
        $this->table_heading[] = $label;
        $this->columns[] = array($label, $source, $function);

        return $this;
    }

    /**
     * Initialize Datatables
     */
    public function init($dt_name)
    {
        if (isset($_REQUEST['dt_name'])) {
            if ($_REQUEST['dt_name'] == $dt_name) {
                if (isset($_REQUEST['draw']) && isset($_REQUEST['length']) && isset($_REQUEST['start'])) {
                    $this->json();
                    exit;
                }
            }
        }
    }

    /**
     * Set searchable columns from table
     *
     * @param string $data columns name
     * @return object
     */
    public function searchable($data)
    {
        $this->searchable = $data;
        return $this;
    }

    /**
     *    Add options to datatables jquery
     *
     * @param array / string    $option options name
     * @param string $value value
     */
    public function set_options($option, $value = null)
    {
        if ($option == 'ajax.data') {
            $this->ax_options .= $value;
        } else {
            if (is_array($option)) {
                foreach ($option as $opt => $value) {
                    $this->dt_options[$opt] = $value;
                }
            } else {
                $this->dt_options[$option] = $value;
            }
        }

        return $this;
    }

    /**
     * Generate the datatables table (lol)
     *
     * @return html table
     */
    public function generate($id)
    {
        $this->CI->table->set_template(array(
            'table_open' => "<table id=\"$id\" $this->style>"
        ));
        $this->CI->table->set_heading($this->table_heading);

        echo $this->CI->table->generate();
    }

    /**
     * Jquery for datatables
     *
     * @return javascript
     */
    public function jquery($id)
    {
        $dt_options = '';
        $ax_options = $this->ax_options;

        foreach ($this->dt_options as $opt => $value) {
            $dt_options .= "$opt: $value, \n";
        }

        $output = "
        <script type=\"text/javascript\" defer=\"defer\">
            function createDatatable() {
				erTable_{$id} = $(\"#{$id}\").DataTable({
                    processing: true,
                    serverSide: true,
					language: 
					{          
					\"processing\": \"<img style='width:100px; height:50px;' src='https://media.tenor.com/hlKEXPvlX48AAAAi/loading-loader.gif' />\",
					},
                    {$dt_options}
                    ajax: {
                        url: \"" . site_url(uri_string()) . "\",
						type: \"POST\",
                        data: function (d, dt) {
							console.log(dt);
							d.dt_name = \"{$id}\"

							{$ax_options}
						}
					}
                });
            };

            createDatatable();
        </script>";

        echo $output;
    }

    /**
     * Generate JSON for datatables
     *
     * @return json
     */
    public function json()
    {
        $draw = $_REQUEST['draw'];
        $length = $_REQUEST['length'];
        $start = $_REQUEST['start'];
        $order_by = $_REQUEST['order'][0]['column'];
        $order_dir = $_REQUEST['order'][0]['dir'];
        $search = $_REQUEST['search']["value"];

        $output['data'] = array();

        if ($this->searchable == '*') {
            $field = $this->_db->list_fields($this->table);
            $this->searchable = implode(',', $field);
        }

        $column = explode(',', $this->searchable);
        $this->searchable = array();

        foreach ($column as $key => $col) {
            $col = strtolower($col);
            $col = strstr($col, ' as ', true) ?: $col;
            $this->searchable[] = $col;
        }

        if ($search != "") {
            for ($i = 0; $i < count($this->searchable); $i++) {
                if ($i == 0) $this->_db->like($this->searchable[$i], $search);
                else $this->_db->or_like($this->searchable[$i], $search);
            }
        }

        /** ---------------------------------------------------------------------- */
        /** Count records in database */
        /** ---------------------------------------------------------------------- */

        $total = $this->_db->count_all_results();

        $output['query_count'] = $this->_db->last_query();
        $output['recordsTotal'] = $output['recordsFiltered'] = $total;

        /** ---------------------------------------------------------------------- */
        /** Generate JSON */
        /** ---------------------------------------------------------------------- */

        if ($length != -1) {
            $this->_db->limit($length, $start);
        }
        $this->_db->order_by($this->columns[$order_by][1], $order_dir);

        $result = $this->_db->get()->result_array();
        $output['query'] = $this->_db->last_query();

        foreach ($result as $row) {
            $arr = array();
            foreach ($this->columns as $key => $column) {
                $row_output = $row[$column[1]];
                if (isset($this->columns[$key][2])) {
                    $row_output = call_user_func_array($this->columns[$key][2], array($row_output, $row));
                }
                $arr[] = $row_output;
            }
            $output['data'][] = $arr;
        }

        echo json_encode($output);
    }

    /**
     * @param string $start
     * @param string $end
     * @param $assigned_to
     * @return bool|object
     */
    public function get_bills(string $start, string $end, $assigned_to = null, $payment_status = null)
    {
        $this->searchable = 'billing.bill_no, staff.name,staff.mobileno, staff.email, staff.id, assigned_staff.name';

        $this->_db->select('MAX(billing.id) as id,billing.bill_no, MAX(billing.status) as status, MAX(billing.paid) as paid, MAX(billing.due) as due, MAX(billing.due_date) as due_date, MAX(billing.date) as date, MAX(billing.hash) as hash');
        $this->_db->select('SUM(total-discount+tax_amount) as net_amount');
        $this->_db->select('MAX(staff.name) as staff_name, MAX(staff.staff_id) as staff_id, MAX(staff.assign_to) as assign_to');
        $this->_db->select('assigned_staff.name as assigned_name');
        $this->_db->from('billing');
        $this->_db->join('staff', 'staff.id = billing.staff_id', 'left');
        $this->_db->join('staff as assigned_staff', 'assigned_staff.id = staff.assign_to', 'inner');

        if (!empty($start) && !empty($end)) {
            $this->_db->where('billing.date >=', $start);
            $this->_db->where('billing.date <=', $end);
        }

        if (!empty($assigned_to)) {
            $this->_db->where('staff.assign_to', $assigned_to);
        }

        if (!empty($payment_status)) {
            $this->_db->where('billing.status', $payment_status);
        }

        $this->_db->group_by('billing.bill_no');
        $this->_db->order_by('MAX(billing.id)', 'ASC');


        return $this->_db;
    }
}
