<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Client extends Admin_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('frontend_model');
    }

    // home team
    public function index()
    {
        // check access permission
        if (!get_permission('frontend_client', 'is_view')) {
            access_denied();
        }

        if ($_POST) {
            if (!get_permission('frontend_client', 'is_add')) {
                access_denied();
            }

            $this->client_validation();
            if ($this->form_validation->run() == false) {
                $this->data['validation_error'] = true;
            } else {
                // save information in the database
                $data = $this->input->post();
                $this->frontend_model->save_client($data);
                set_alert('success', translate('information_has_been_saved_successfully'));
                redirect(base_url('frontend/client'));
            }
        }

        $this->data['clientlist'] = $this->frontend_model->get_list('front_cms_client_list', array('item_type' => 'client'));
        $this->data['title'] = translate('frontend');
        $this->data['sub_page'] = 'frontend/client';
        $this->data['main_menu'] = 'frontend';
        $this->load->view('layout/index', $this->data);
    }

    // home team edit
    public function edit($id = '')
    {
        // check access permission
        if (!get_permission('frontend_client', 'is_edit')) {
            access_denied();
        }
        if ($_POST) {
            $this->client_validation();
            if ($this->form_validation->run() == false) {
                $this->data['validation_error'] = true;
            } else {
                // update information in the database
                $data = $this->input->post();
                $this->frontend_model->save_client($data);
                set_alert('success', translate('information_has_been_updated_successfully'));
                redirect(base_url('frontend/client'));
            }
        }

        $this->data['client'] = $this->frontend_model->get_list('front_cms_client_list', array('id' => $id, 'item_type' => 'client'), true);
        $this->data['title'] = translate('frontend');
        $this->data['sub_page'] = 'frontend/client_edit';
        $this->data['main_menu'] = 'frontend';
        $this->load->view('layout/index', $this->data);
    }

    // home team delete
    public function delete($id = '')
    {
        if (!get_permission('frontend_client', 'is_delete')) {
            access_denied();
        }
        $image = $this->db->get_where('front_cms_home', array('id' => $id, 'item_type' => 'client'))->row()->image;
        if ($this->db->where(array('id' => $id, 'item_type' => 'client'))->delete("front_cms_client_list")) {
            // delete gallery team
            $destination = './uploads/frontend/client/';
            if (file_exists($destination . $image)) {
                @unlink($destination . $image);
            }
        }
    }

    private function client_validation()
    {       
        $this->form_validation->set_rules('photo', 'Photo', 'trim|xss_clean|callback_check_image');
    }

    public function check_image()
    {
        if ($this->input->post('client_id')) {
            if (!empty($_FILES['photo']['name'])) {
                $name = $_FILES['photo']['name'];
                $arr = explode('.', $name);
                $ext = end($arr);
                if ($ext == 'jpg' || $ext == 'jpeg' || $ext == 'png') {
                    return true;
                } else {
                    $this->form_validation->set_message('check_image', translate('select_valid_file_format'));
                    return false;
                }
            }
        } else {
            if (isset($_FILES['photo']['name']) && !empty($_FILES['photo']['name'])) {
                $name = $_FILES['photo']['name'];
                $arr = explode('.', $name);
                $ext = end($arr);
                if ($ext == 'jpg' || $ext == 'jpeg' || $ext == 'png') {
                    return true;
                } else {
                    $this->form_validation->set_message('check_image', translate('select_valid_file_format'));
                    return false;
                }
            } else {
                $this->form_validation->set_message('check_image', 'The Photo is required.');
                return false;
            }
        }
    }
}
