<?php defined('BASEPATH') or exit('No direct script access allowed');

class Zone extends Admin_Controller
{
    private $main_menu = 'configuration';
    private $permission = 'zone';

    public function __construct()
    {
        parent::__construct();
        $this->load->model('zone_model');
        $this->load->model('employee_model');
    }

    /**
     * Show all zones
     * Create new zone
     * Store new zone
     *
     * @return object|string
     */
    public function index()
    {
        $this->store();
    
        // Check access permission
        if (!get_permission($this->permission, 'is_view')) {
            access_denied();
        }
    
        $userID = get_loggedin_user_id();
        $RoleID = loggedin_role_id();
    
        $this->data['title'] = translate('Branch');
        $this->data['main_menu'] = $this->main_menu;
        $this->data['sub_page'] = 'zone/index';
    
        $this->data['zones'] = $this->zone_model->get_zone_list_individual($RoleID, $userID);
        
        $this->data['employees'] = $this->employee_model->get_admin_reseller_subreseller_list(ROLE_ADMIN_ID, get_loggedin_user_id());
    
        return $this->load->view('layout/index', $this->data);
    }
    
    
    /**
     * Edit billing profile
     * Update billing profile
     *
     * @param int $id
     * @return object|string
     */
    public function edit(int $id)
    {
        if (!get_permission($this->permission, 'is_edit')) {
            access_denied();
        }
        $thisZone = $this->zone_model->whereManagerId(get_loggedin_user_id())->find($id);

        if (is_null($thisZone)){
            redirect('zone');
        }

        $this->update($id);

        // Process Get Request
        $this->data['title'] = translate('Branch Edit');
        $this->data['main_menu'] = $this->main_menu;
        $this->data['sub_page'] = 'zone/index';
        $this->data['action'] = 'edit';

        $this->data['zones'] = $this->zone_model->findAll();
        $this->data['employees'] = $this->employee_model->get_admin_reseller_subreseller_list(ROLE_ADMIN_ID, get_loggedin_user_id());
        $this->data['thisZone'] = $thisZone;

        return $this->load->view('layout/index', $this->data);
    }

    /**
     * Zone store validation
     * Zone update validation
     *
     * @return mixed
     */
    private function zoneValidation(int $id = null)
    {
        $this->form_validation->set_rules('name', translate('name'), 'trim|required|is_unique[zones.name,id,' . $id . ']');

        return $this->form_validation->run();
    }

    private function store()
    {
        if ($this->input->method(true) === 'POST') {
            if (!get_permission($this->permission, 'is_add')) {
                access_denied();
            }
            try {
                if ($this->zoneValidation()) {
                    if ($this->zone_model->insert($this->input->post())) {
                        set_alert('success', translate('branch_added_successfully'));
                    } else {
                        set_alert('error', translate('branch_added_failed'));
                    }
                } else {
                    set_alert('error', translate('please_fix_form_data_and_try_again'));
                }
            } catch (Exception $e) {
                set_alert('error', $e->getMessage());
            }

            redirect('zone');
        }
    }

    private function update(int $id)
    {
        if ($this->input->method(true) === 'POST') {
            try {
                if ($this->zoneValidation($id)) {
                    if ($this->zone_model->update($id, $this->input->post())) {
                        set_alert('success', translate('branch_updated_successfully'));
                    } else {
                        set_alert('error', translate('branch_updated_failed'));
                    }
                } else {
                    set_alert('error', translate('please_fix_form_data_and_try_again'));
                }
            } catch (Exception $e) {
                set_alert('error', $e->getMessage());
            }

            redirect('zone');
        }
    }
}