<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Voice extends Admin_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('voice_model');
        $this->load->model('employee_model');
        $this->load->model('ami_model');
        $this->load->model('couchdb_model');
    }

    public function index()
    {

		$userID = get_loggedin_user_id();
		
		if ($_POST['camp_submit']) {
			
			$camp_data = $this->input->post();
			$data_id = $camp_data['id'];
			$data_remarks = $camp_data['remarks'];

			$this->voice_model->save_campaign_data($camp_data, $data_id);
			$this->voice_model->update_vb_schedule_status($data_id,$data_remarks);
			set_alert('success', translate('Campaign config updated successfully'));
			redirect(base_url('voice')); 

		}

        if ($_POST['save']) {
			$data = $this->input->post();
			$campaign_id = $this->voice_model->save_schedule_campaign($data);
			
			////for curl///
			$group_name = $data['group_list'];
			$cdb = $this->couchdb_insert_update($group_name,$campaign_id);
			
			//print_r($cdb);
			//die();
			
			
			set_alert('success', translate('New Campaign created successfully'));
			redirect(base_url('voice')); 
        }
		
		if ($_POST['update']) {
			$data = $this->input->post();

			

			$campaign_id = $this->voice_model->save_schedule_campaign($data);
			set_alert('success', translate('New Campaign created successfully'));
			redirect(base_url('voice')); 
        }

		$this->data['contact_call_groups'] = $this->voice_model->contact_call_groups($userID);
        $this->data['schedule_campaign_list'] = $this->voice_model->get_schedule_campaign_list($userID);
		$this->data['schedule_campaign_detail'] = $this->voice_model->get_schedule_campaign_list($userID);
		
		$this->data['contact_count'] = $this->voice_model->get_contact_count_by_group();
		$this->data['config_detail'] = $this->voice_model->get_campaign_config();
		$this->data['callerid_list'] = $this->voice_model->get_callerid_list('',$userID,get_user_admin_id());
		$this->data['trunk_list'] = $this->voice_model->get_trunk_list($userID,get_user_admin_id());
		$this->data['all_customers'] = $this->employee_model->get_all_users($userID,get_user_admin_id());
		$this->data['sounds_list'] = $this->voice_model->get_sound_list($userID);
		$this->data['tts_list'] = $this->voice_model->get_tts_list($userID);
        $this->data['title'] = translate('campaign');
        $this->data['sub_page'] = 'voice/list';
        $this->data['main_menu'] = 'campaign';
        $this->load->view('layout/index', $this->data);
    }
	
	
	public function schedule_campaign_result()
    {
		$id = $this->input->post('id');
		$this->data['campaign_result'] = $this->couchdb_model->getAllCalledNumbers($id);
		$this->load->view('voice/campaign_result', $this->data);
		
    }
	

	public function get_config_cmp_details()
    {
		$userID = get_loggedin_user_id();
		
			$id = $this->input->post('id');
            //$this->db->where('id', $id);
            //$query = $this->db->get('vb_schedule_play');
            //$result = $query->row_array();
            //echo json_encode($result);
			$this->data['user_id'] = $id ;
			$this->data['config_detail'] = $this->voice_model->get_campaign_config($id);
			$this->data['sounds_list'] = $this->voice_model->get_sound_list($userID);
			$this->data['tts_list'] = $this->voice_model->get_tts_list($userID);
			$this->load->view('voice/config_cmp', $this->data);
    }	
	
	public function get_list_view($id = '')
    {
		$userID = get_loggedin_user_id();
		
			$id = $this->input->post('id');
            //$this->db->where('id', $id);
            //$query = $this->db->get('vb_schedule_play');
            //$result = $query->row_array();
            //echo json_encode($result);
			$this->data['user_id'] = $id ;
			$this->data['contact_call_groups'] = $this->voice_model->contact_call_groups($userID);
			$this->data['schedule_campaign_detail'] = $this->voice_model->get_schedule_campaign_list($userID, $id);
			$this->data['config_detail'] = $this->voice_model->get_campaign_config($id);
			$this->data['callerid_list'] = $this->voice_model->get_callerid_list($userID);
			$this->data['trunk_list'] = $this->voice_model->get_trunk_list($userID);
			$this->data['sounds_list'] = $this->voice_model->get_sound_list($userID);
			$this->data['tts_list'] = $this->voice_model->get_tts_list($userID);
			$this->load->view('voice/list_view', $this->data);
    }

	public function get_running_status($id = '')
    {
		$userID = get_loggedin_user_id();
		
			$this->load->view('voice/running_status', $this->data);
    }

    public function edit($id = '')
    {
		$userID = get_loggedin_user_id();
		// check access permission
        if (!get_permission('campaign', 'is_edit')) {
            access_denied();
        }
        if ($this->input->post()) {
            $data = $this->input->post();
			
			$this->voice_model->save_schedule_campaign($data);
			set_alert('success', translate('Campaign updated successfully'));
			redirect(base_url('voice')); 
        }
		
		$this->data['contact_call_groups'] = $this->voice_model->contact_call_groups($userID);
		$this->data['schedule_campaign_detail'] = $this->voice_model->get_schedule_campaign_list($userID, $id);
		$this->data['callerid_list'] = $this->voice_model->get_callerid_list('');
		$this->data['trunk_list'] = $this->voice_model->get_trunk_list($userID);
		$this->data['all_customers'] = $this->employee_model->get_all_users($userID,get_user_admin_id());
		$this->data['sounds_list'] = $this->voice_model->get_sound_list('');
		$this->data['tts_list'] = $this->voice_model->get_tts_list($userID);
		$this->data['title'] = translate('Edit campaign');
        $this->data['sub_page'] = 'voice/list_edit';
        $this->data['main_menu'] = 'campaign';
        $this->load->view('layout/index', $this->data);

    }

    public function delete($id = '')
    {
        if (!get_permission('campaign', 'is_delete')) {
            access_denied();
        }
        $this->db->where(array('id' => $id))->delete("vb_schedule_play");
		$this->db->where(array('campaign_id' => $id))->delete("campaign_config");
		$this->couchdb_model->deleteDatabase($id);
    }
	
	
	
	 public function quick_call()
    {
		$userID = get_loggedin_user_id();
        // check access permission
        if (!get_permission('quick_call', 'is_view')) {
            access_denied();
        }
		

        if ($_POST) {
			$data = $this->input->post();
			$initiate_call = $this->ami_model->initiate_call($data);
			$this->voice_model->save_quick_play($data);
			set_alert('success', translate('Call Initiated successfully'));
			redirect(base_url('voice/quick_call')); 
        }

        $this->data['schedule_campaign_list'] = $this->voice_model->get_schedule_campaign_list($userID);
        $this->data['quick_call_list'] = $this->voice_model->get_quick_call_list($userID);
		$this->data['callerid_list'] = $this->voice_model->get_callerid_list('');
		$this->data['trunk_list'] = $this->voice_model->get_trunk_list($userID);
		$this->data['sounds_list'] = $this->voice_model->get_sound_list($userID);
		$this->data['tts_list'] = $this->voice_model->get_tts_list($userID);
        $this->data['title'] = translate('Quick Call');
        $this->data['sub_page'] = 'voice/quick_call';
        $this->data['main_menu'] = 'campaign';
        $this->load->view('layout/index', $this->data);
    }	
		
	public function report()
	{
		
		 if ($_POST) {
			$data = $this->input->post();
			// Handle the search functionality
			$daterange = explode(' - ', $this->input->post('daterange'));
			$start = date("Y-m-d", strtotime($daterange[0]));
			$end = date("Y-m-d", strtotime($daterange[1]));
			
	

			$camp_id = $this->input->post('camp_id');
			$this->data['campaign_result'] = $this->couchdb_model->getAllCalledNumbersbyDate($camp_id,$start,$end);
			
			//redirect(base_url('voice/report'));
        }
		
		$userID = get_loggedin_user_id();
		$campaigns = $this->voice_model->get_schedule_campaign_list($userID);

		// Pass campaign names to the view
		$this->data['campaigns'] = $campaigns;

		// Set other data
		$this->data['title'] = translate('Report');
		$this->data['sub_page'] = 'voice/report';
		$this->data['main_menu'] = 'campaign';

		// Load the view
		$this->load->view('layout/index', $this->data);
	}
	
/* 	public function get_campaign_results()
	{
		$campaign_id = $this->input->post('campaign_id');
		$campaign_result = $this->couchdb_model->getAllCalledNumbers($campaign_id);

		$this->output->set_content_type('application/json')->set_output(json_encode($campaign_result));
	}
	
	public function schedule_campaign_result()
	{
		$id = $this->input->post('id');
		$campaign_result = $this->couchdb_model->getAllCalledNumbers($id);

		$this->output->set_content_type('application/json')->set_output(json_encode($campaign_result));
	} */
	
	public function get_quick_call_details()
    {
		$userID = get_loggedin_user_id();
		$id = $this->input->post('id');		
		$quick_call_details= $this->voice_model->get_quick_call_list($userID, $id);

		$play_type = $quick_call_details[0]['play_type'];
		$play = $quick_call_details[0]['play'];
		
		if ($play_type=='tts'){
			$sound_play = '';
			$tts_play = $play;
			
		}
		if ($play_type=='sound'){
			$sound_play = $play;
			$tts_play = '';
		}
		
		$data = array(
			'datetime' => date('Y-m-d H:i:s'),
			'user_id' => $userID,
			'call_to' => $quick_call_details[0]['call_to'],
			'trunk' => $quick_call_details[0]['trunk_id'],
			'caller_id' => $quick_call_details[0]['caller_id'],
			'firstDropdown' => $play_type,
			'soundFile' => $sound_play,
			'ttsFile' => $tts_play,
			'save' => 1
		);

		$initiate_call = $this->ami_model->initiate_call($data);
		set_alert('success', translate('Call Re-Initiated successfully'));
		
    }
	
	
	public function qc_delete($id = '')
    {
        $this->db->where(array('id' => $id))->delete("vb_quick_play");
    }
	
	
	public function trunks()
    {
		$userID = get_loggedin_user_id();

        if ($_POST) {
			$data = $this->input->post();
			$caller_id = $this->voice_model->save_trunk($data);
			set_alert('success', translate('New Trunk added successfully'));
			redirect(base_url('voice/trunks')); 
        }
        $this->data['trunk_list'] = $this->voice_model->get_trunk_list($userID);
		$this->data['all_admins'] = $this->employee_model->get_all_admin();
        $this->data['title'] = translate('Trunk\'s');
        $this->data['sub_page'] = 'voice/trunks';
        $this->data['main_menu'] = 'campaign';
        $this->load->view('layout/index', $this->data);
    }
	
	public function trunk_edit()
    {
		if (!get_permission('trunks', 'is_edit')) {
            access_denied();
        }
		$id = $this->input->post('id');
		$this->db->where('id', $id);
		$query = $this->db->get('vb_trunks');
		$result = $query->row_array();
		echo json_encode($result);
    }
	
	public function trunk_delete($id = '')
    {
        if (!get_permission('trunks', 'is_delete')) {
            access_denied();
        }
        $this->db->where(array('id' => $id))->delete("vb_trunks");
    }
	
	
	
	 public function callerids()
    {
		$userID = get_loggedin_user_id();

        if ($_POST) {
			$data = $this->input->post();
			$caller_id = $this->voice_model->save_callerid($data);
			set_alert('success', translate('New CallerID added successfully'));
			redirect(base_url('voice/callerids')); 
        }
		$this->data['trunk_list'] = $this->voice_model->get_trunk_list($userID);
        $this->data['callerid_list'] = $this->voice_model->get_callerid_list('');
        $this->data['title'] = translate('CallerID\'s');
        $this->data['sub_page'] = 'voice/callerids';
        $this->data['main_menu'] = 'campaign';
        $this->load->view('layout/index', $this->data);
    }

	public function callerid_edit()
    {
		if (!get_permission('caller_ids', 'is_edit')) {
            access_denied();
        }
		$id = $this->input->post('id');
		$this->db->where('id', $id);
		$query = $this->db->get('vb_callerid');
		$result = $query->row_array();
		echo json_encode($result);
    }
	
	 public function callerid_delete($id = '')
    {
        if (!get_permission('caller_ids', 'is_delete')) {
            access_denied();
        }
        $this->db->where(array('id' => $id))->delete("vb_callerid");
    }



	public function tts()
    {
		$userID = get_loggedin_user_id();

        if ($_POST) {
			$data = $this->input->post();
			$this->voice_model->save_tts($data);
			set_alert('success', translate('New TTS added successfully'));
			redirect(base_url('voice/tts')); 
        }
        $this->data['tts_list'] = $this->voice_model->get_tts_list($userID);
		$this->data['userID'] = get_loggedin_user_id();
		$this->data['RoleID'] = loggedin_role_id();
        $this->data['title'] = translate('Text To Speech');
        $this->data['sub_page'] = 'voice/tts';
        $this->data['main_menu'] = 'campaign';
        $this->load->view('layout/index', $this->data);
    }
	
	
		
	public function tts_verify($id = '')
    {
		$this->db->update('vb_tts', array('status' => 'Active'), array('id' => $id));
		set_alert('success', translate('TTS File verified'));
		redirect(base_url('voice/tts')); 
    }
	
	public function tts_unverify($id = '')
    {
		$this->db->update('vb_tts', array('status' => 'Inactive'), array('id' => $id));
		set_alert('success', translate('TTS File verified'));
		redirect(base_url('voice/tts')); 
    }
	
	
	
	
	public function tts_edit()
    {
		if (!get_permission('text_to_speech', 'is_edit')) {
            access_denied();
        }
		$id = $this->input->post('id');
		$this->db->where('id', $id);
		$query = $this->db->get('vb_tts');
		$result = $query->row_array();
		echo json_encode($result);
    }
	
	public function tts_delete($id = '')
    {
        if (!get_permission('text_to_speech', 'is_delete')) {
            access_denied();
        }
        $this->db->where(array('id' => $id))->delete("vb_tts");
    }
	
	
	
	
	public function sounds()
    {
		$userID = get_loggedin_user_id();
		$RoleID = loggedin_role_id();

        if ($_POST) {
			$data = $this->input->post();
			$this->voice_model->save_sound($data);
			set_alert('success', translate('New Sound added successfully'));
			redirect(base_url('voice/sounds')); 
        }
        $this->data['sounds_list'] = $this->voice_model->get_sound_list($userID);
        $this->data['userID'] = get_loggedin_user_id();
        $this->data['RoleID'] = loggedin_role_id();
        $this->data['title'] = translate('Sounds');
        $this->data['sub_page'] = 'voice/sounds';
        $this->data['main_menu'] = 'campaign';
        $this->load->view('layout/index', $this->data);
    }
	
	public function sounds_edit()
    {
		if (!get_permission('sound_files', 'is_edit')) {
            access_denied();
        }
		$id = $this->input->post('id');
		$this->db->where('id', $id);
		$query = $this->db->get('vb_sounds');
		$result = $query->row_array();
		echo json_encode($result);
    }
	
	public function sound_verify($id = '')
    {
		$this->db->update('vb_sounds', array('status' => 'Active'), array('id' => $id));
		set_alert('success', translate('Sound File verified'));
		redirect(base_url('voice/sounds')); 
    }
	
	public function sound_unverify($id = '')
    {
		$this->db->update('vb_sounds', array('status' => 'Inactive'), array('id' => $id));
		set_alert('success', translate('Sound File verified'));
		redirect(base_url('voice/sounds')); 
    }
	
	public function sound_delete($id = '')
    {
        if (!get_permission('sound_files', 'is_delete')) {
            access_denied();
        }
        $this->db->where(array('id' => $id))->delete("vb_sounds");
    }
	
	
	public function couchdb_insert_update($group_name, $campaign_id)
	{
		$url = 'https://202.59.208.113/contact_center/ami_api/php_ami/CouchDB/insert_data.php';

		$data = array(
			'group_name' => $group_name,
			'campaign_id' => $campaign_id
		);

		$data_string = http_build_query($data);

		$ch = curl_init($url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
		curl_setopt($ch, CURLOPT_HTTPHEADER, array(
			'Content-Type: application/x-www-form-urlencoded',
			'Content-Length: ' . strlen($data_string)
		));
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // disable SSL verification
		curl_setopt($ch, CURLOPT_VERBOSE, true);

		$response = curl_exec($ch);

		if (curl_errno($ch)) {
			echo 'Curl error: ' . curl_error($ch);
		}

		curl_close($ch);

		// Check for a successful response
		if ($response === false) {
			echo 'cURL request failed.';
		} else {
			echo $response;
		}
	}



	
	
	
	
	
	
	
	
	
	
	
	

	
}
