<?php defined('BASEPATH') or exit('No direct script access allowed');

/**
 * Class Client_support
 *
 * @property CI_Form_validation $form_validation
 * @property CI_Input $input
 * @property Client_support_model $client_support_model
 * @property Employee_model $employee_model
 * @property Nas_model $nas_model
 * @property Support_category_model $support_category_model
 * @property Routerosapi $routerosapi
 * @property Image_uploader $image_uploader
 * @property Datatables $datatables
 */
class Support_history extends Admin_Controller
{
    private $main_menu = 'support';
    private $permission = 'support_history';

    public function __construct()
    {
        parent::__construct();
        $this->load->model('client_support_model');
        $this->load->model('employee_model');
        $this->load->model('nas_model');
        $this->load->model('support_category_model');
        $this->load->library('routerosapi');
        $this->load->library('image_uploader');
    }

    /**
     * @return void
     */
    public function index_clientside()
    {
        if (!get_permission($this->permission, 'is_view')) {
            access_denied();
        }

        $this->data['title'] = translate('Support History');
        $this->data['main_menu'] = $this->main_menu;
        $this->data['sub_page'] = 'support_history/index_clientside';

        $this->data['client_supports'] = $this->client_support_model->where('support_category.editable', false)
            ->policy(get_loggedin_user_id())
            ->findAll();

        $this->data['support_categories'] = $this->support_category_model->findAll();
        $this->load->view('layout/index', $this->data);
    }

    public function index()
    {
        if (!get_permission($this->permission, 'is_view')) {
            access_denied();
        }

        $logged_id = get_loggedin_user_id();

        ///User ID
        $search_user_id = $this->input->post('client_id');

        if (empty($search_user_id)) {
            $search_user_id = $logged_id;
        }

        $daterange = explode(' - ', $this->input->post('daterange'));
        if (isset($daterange) && !empty($daterange) && $daterange !== null) {
            if (isset($daterange[0]) && !empty($daterange[0]) && $daterange[0] !== null) {
                $start = date("Y-m-d", strtotime($daterange[0]));
            } else {
                $start = date("Y-m-1");
            }
            if (isset($daterange[1]) && !empty($daterange[1]) && $daterange[1] !== null) {
                $end = date("Y-m-d", strtotime($daterange[1]));
            } else {
                $end = date("Y-m-d");
            }
        }
        $this->load->library('datatables');
        $dt_authors = $this->datatables->init();
        $dt_authors->get_client_support_ticket_filter($search_user_id, $start, $end, false);

        $dt_authors
            ->style(array(
                'class' => 'table table-bordered table-striped dataTable dtr-inline table-hover table-condensed dataTable no-footer',
            ))
            ->set_options('responsive', 'true')
            ->set_options('autoWidth', 'false')
            ->set_options('pagingType', '\'full_numbers\'')
            ->set_options('pageLength', '10')
            ->set_options('order', '[[0, \'desc\']]')
            ->set_options('lengthMenu', '[[ 10, 25, 50, 1000, 5000 ],[ \'10\', \'25\', \'50\', \'1000\', \'5000\' ]]')
            ->set_options('dom', '\'<"container-fluid"<"row"<"col-sm-4"l><"col-sm-4"B><"col-sm-4"f>>>rtip\'')
            ->set_options('buttons', '["copy", "csv", "excel", "pdf", "print", "colvis"]')
            ->set_options('ajax.data', 'd.client_id = $(\'#client_id\').val();')
            ->set_options('ajax.data', 'd.daterange = $(\'#daterange\').val();')
            ->column('Id', 'id')
            ->column('Client Name', 'client_name')
            ->column('Problem Category', 'problem_category_name', function ($data, $clientSupport) {
                return $this->load->view('client_support/change_problem_category', compact('data', 'clientSupport'), true);
            })
            ->column('Problem Priority', 'problem_priority')
            ->column('Complained Number', 'complained_number')
            ->column('Assign To', 'assign_to_name')
            ->column('Problem Description', 'problem_description')
            ->column('Action', 'id', function ($data, $clientSupport) {
                return '<a href="#" class="btn btn-xs btn-default support-chat-button" style="color: #ff04ff;" onclick=" supportChat(' . $clientSupport['id'] . ')"><i class="fa fa-comments"></i>' . translate('chat') . '</a>';
            });

        $this->datatables->create('dt_authors', $dt_authors);

        $this->data['title'] = translate('Support History');
        $this->data['main_menu'] = $this->main_menu;
        $this->data['sub_page'] = 'support_history/index';
        $this->data['client_id_list'] = $this->employee_model->get_only_client_list('', $logged_id, '');
        $this->data['support_categories'] = $this->support_category_model->findAll();
        $this->load->view('layout/index', $this->data);
    }
}
