<?php defined('BASEPATH') or exit('No direct script access allowed');

/**
 * Class Support_chat
 *
 * @property CI_Input $input
 * @property Client_support_model $client_support_model
 * @property Support_chat_model $support_chat_model
 */
class Support_chat extends Admin_Controller
{
    private $main_menu = 'support';
    private $permission = 'support_chat';

    public function __construct()
    {
        parent::__construct();
        $this->load->model('client_support_model');
        $this->load->model('support_chat_model');
    }

    /**
     * @return void
     */
    public function index()
    {
        // check is ajax request
        if ($this->input->is_ajax_request()) {
            try {
                if ($this->input->method() === 'post') {
                    if ($this->store()) {
                        echo json_encode(['status' => 'success', 'message' => translate('message_sent')]);
                    } else {
                        echo json_encode(['status' => 'error', 'message' => translate('message_not_sent')]);
                    }
                } else {

                    $this->data['client_support'] = $this->client_support_model->find($this->input->get('support_id'));
                    $this->data['chatMessages'] = $this->support_chat_model->where('client_support_id', $this->input->get('support_id'))->findAll();
                    $this->load->view('support_chat/chat_modal', $this->data);
                }
            } catch (Exception $e) {
                echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
            }
        } else {
            show_404();
        }
    }

    private function store()
    {
        $support_id = $this->input->post('support_id');
        $message = $this->input->post('message');
        $messageFrom = get_loggedin_user_id();
        return $this->support_chat_model->insert([
            'client_support_id' => $support_id,
            'message' => $message,
            'sender_id' => $messageFrom,
        ]);
    }
}
