<?php defined('BASEPATH') or exit('No direct script access allowed');

class Support_category extends Admin_Controller
{
    private $main_menu = 'support';
    private $permission = 'support_category';

    public function __construct()
    {
        parent::__construct();
        $this->load->model('role_model');
        $this->load->model('support_category_model');
    }

    public function index()
    {
        if (!get_permission($this->permission, 'is_view') && !get_permission($this->permission, 'is_view_own')) {
            access_denied();
        }

        if ($this->input->method(true) === 'POST') {
            if ($this->support_category_store_filter()) {
                $data = $this->input->post();
                $data['created_by'] = get_loggedin_user_id();
                $this->support_category_model->insert($data);
                set_alert('success', translate('support_category_created_successfully'));
            } else {
                set_alert('error', translate('please_fix_form_data_and_try_again'));
            }

            redirect('support_category');
        }

        $this->data['title'] = translate('Support Category');
        $this->data['main_menu'] = $this->main_menu;
        $this->data['sub_page'] = 'support_category/index';
        $this->data['supportCategories'] = $this->support_category_model->orderBy('id', 'DESC')->findAll();
        $this->load->view('layout/index', $this->data);
    }

    public function edit(int $id)
    {
        if (!get_permission($this->permission, 'is_edit') && !get_permission($this->permission, 'is_edit_own')) {
            access_denied();
        }

        if ($this->input->method(true) === 'POST') {
            if ($this->support_category_store_filter()) {
                $this->update($id);
            } else {
                set_alert('error', translate('please_fix_form_data_and_try_again'));
            }
        }

        $this->data['title'] = translate('Edit Support Category');
        $this->data['main_menu'] = $this->main_menu;
        $this->data['sub_page'] = 'support_category/index';
        $this->data['supportCategory'] = $this->support_category_model->find($id);
        $this->data['supportCategories'] = $this->support_category_model->orderBy('id', 'DESC')->findAll();

        $this->load->view('layout/index', $this->data);
    }

    public function update(int $id)
    {
        $data = array(
            'name' => $this->input->post('name'),
            'description' => $this->input->post('description')
        );
        $this->support_category_model->update($id, $data);
        redirect('support_category');
    }

    public function delete($id)
    {
        $this->support_category_model->delete($id);
        redirect('support_category');
    }

    private function support_category_store_filter()
    {
        $this->form_validation->set_rules('name', translate('name'), 'trim|required');
        $this->form_validation->set_rules('description', translate('description'), 'trim');

        return $this->form_validation->run();
    }

}
