<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Sms extends Admin_Controller
{
    private $main_menu = 'sms';
    private $permission = 'sms';

    public function __construct()
    {
        parent::__construct();
        $this->load->model('sms_model');
        $this->load->model('employee_model');
        $this->load->model('zone_model');
        $this->load->model('olt_model');
        $this->load->library('datatables');
    }


    //--------------- SEND SMS -------------------->
    public function send_sms()
    {
        if (!get_permission('send_sms', 'is_view')) {
            access_denied();
        }

        $logged_id = get_loggedin_user_id();

        if ($_POST) {
            $user_ids = $this->input->post('client_id');
            $sms_text = $this->input->post('message');

            if (!empty($user_ids) && !empty($sms_text)) {
                foreach ($user_ids as $user_id) {
                    // Fetch each client's details
                    $admin_data = $this->employee_model->get_staff_details_by_id($user_id);

                    if (!empty($admin_data)) {
                        $assign_to = $admin_data['assign_to'];

                        // Prepare data for SMS log
                        $data = [
                            'user_id'   => $user_id,
                            'sms_text'  => $sms_text,
                            'assign_to' => $assign_to,
                            'remarks'   => 'Web',
                        ];

                        // Save SMS log for each client
                        $this->sms_model->save_sms_log($data);
                    }
                }

                set_alert('success', 'Notice submitted successfully.');
            } else {
                set_alert('error', 'Please select at least one student and enter a message.');
            }

            redirect(base_url('sms/send_sms'));
        }

        // Load view data
        $this->data['title'] = 'Send Notice';
        $this->data['sub_page'] = 'sms/send_sms';
        $this->data['main_menu'] = $this->main_menu;
        $this->data['client_id_list'] = $this->employee_model->get_only_client_list('', $logged_id, '');
        $this->load->view('layout/index', $this->data);
    }


    //--------------- SEND SMS TO ZONE -------------------->
    public function send_sms_zone()
    {
        if (!get_permission('send_sms_zone', 'is_view')) {
            access_denied();
        }

        $userID = get_loggedin_user_id();
        $RoleID = loggedin_role_id();
        if ($_POST) {
            $message = $this->input->post('message');
            $zone_ids = $this->input->post('zone'); // Get the zone IDs (array)

            $this->send_sms_to_zone($zone_ids, $message);

            set_alert('success', 'SMS sent successfully to the specified zones');
            redirect(base_url('sms/send_sms_zone'));
        }

        $this->data['zones'] = $this->zone_model->get_zone_list_individual($RoleID, $userID);
        $this->data['title'] = 'Send SMS to Zone';
        $this->data['sub_page'] = 'sms/send_sms_zone';
        $this->data['main_menu'] = $this->main_menu;
        $this->load->view('layout/index', $this->data);
    }

    //--------------- SEND SMS TO OLT -------------------->
    public function send_sms_olt()
    {
        if (!get_permission('send_sms_olt', 'is_view')) {
            access_denied();
        }

        $userID = get_loggedin_user_id();
        $RoleID = loggedin_role_id();
        if ($_POST) {
            $message = $this->input->post('message');
            $olt_ids = $this->input->post('olt'); // Get the selected OLT IDs (array)

            // Send SMS to the selected OLTs
            $this->send_sms_to_olt($olt_ids, $message);

            set_alert('success', 'SMS sent successfully for selected OLTs');
            redirect(base_url('sms/send_sms_olt'));
        }

        // Fetch the list of OLTs for the dropdown
        $this->data['olts'] = $this->olt_model->get_olt_list_individual($RoleID, $userID);
        $this->data['title'] = 'Send SMS to OLT';
        $this->data['sub_page'] = 'sms/send_sms_olt';
        $this->data['main_menu'] = $this->main_menu;
        $this->load->view('layout/index', $this->data);
    }

    //--------------- SMS LOGS -------------------->
    public function sms_logs()
    {
        if (!get_permission('sms_logs', 'is_view')) {
            access_denied();
        }

        $logged_id = get_loggedin_user_id();

        $search_user_id = $this->input->post('client_id');
        $search_user_id = empty($search_user_id) ? $logged_id : $search_user_id;

        $daterange = explode(' - ', $this->input->post('daterange'));
        if (isset($daterange) && !empty($daterange)) {
            $start = isset($daterange[0]) ? date("Y-m-d 00:00:00", strtotime($daterange[0])) : date("Y-m-d 00:00:00");
            $end = isset($daterange[1]) ? date("Y-m-d 23:59:59", strtotime($daterange[1])) : date("Y-m-d 23:59:59");
        } else {
            $start = date("Y-m-d 00:00:00");
            $end = date("Y-m-d 23:59:59");
        }

        $this->load->library('datatables');
        $dt_authors = $this->datatables->init();
        $dt_authors->get_client_sms_logs_filter($search_user_id, $start, $end, false);

        $dt_authors
            ->style(array(
                'class' => 'table table-bordered table-striped dataTable dtr-inline table-hover table-condensed dataTable no-footer',
            ))
            ->set_options('responsive', 'true')
            ->set_options('autoWidth', 'false')
            ->set_options('pagingType', '\'full_numbers\'')
            ->set_options('pageLength', '10')
            ->set_options('order', '[[0, \'desc\']]')
            ->set_options('lengthMenu', '[[ 10, 25, 50, 1000, 5000 ],[ \'10\', \'25\', \'50\', \'1000\', \'5000\' ]]')
            ->set_options('dom', '\'<"container-fluid"<"row"<"col-sm-4"l><"col-sm-4"B><"col-sm-4"f>>>rtip\'')
            ->set_options('buttons', '["copy", "csv", "excel", "pdf", "print", "colvis"]')
            ->set_options('ajax.data', 'd.client_id = $(\'#client_id\').val();')
            ->set_options('ajax.data', 'd.daterange = $(\'#daterange\').val();')
            ->column('Id', 'id')
            ->column('Student Name', 'client_name')
            ->column('Notice Body', 'sms_text')
            // ->column('Status', 'status')
            ->column('Manager', 'assign_to_name');
        // ->column('Remarks', 'remarks')

        $this->datatables->create('dt_authors', $dt_authors);

        $this->data['title'] = translate('Notice Logs');
        $this->data['sub_page'] = 'sms/sms_logs';
        $this->data['main_menu'] = $this->main_menu;
        $this->data['client_id_list'] = $this->employee_model->get_only_client_list('', $logged_id, '');
        $this->load->view('layout/index', $this->data);
    }

    // Helper function to send SMS to OLTs in a zone
    private function send_sms_to_zone($zone_ids, $message)
    {
        foreach ($zone_ids as $zone_id) {
            $client_data = $this->employee_model->get_staff_details_by_zone_id($zone_id);
            if (!empty($client_data)) {
                $admin_data = $this->employee_model->get_staff_details_by_id(get_loggedin_user_id());

                foreach ($client_data as $client) {
                    $insert_data = [
                        'user_id' => $client['id'],
                        'sms_text' => $message,
                        'status' => 'Pending',
                        'creator_id' => get_loggedin_user_id(),
                        'creation_by' => $admin_data['name'],
                        'assign_to' => $client['assign_to'],
                        'remarks' => 'Web',
                    ];

                    // Log the data before saving
                    log_message('debug', 'Inserting SMS Log Data: ' . json_encode($insert_data));

                    // Save SMS log in the sms_logs table
                    $this->sms_model->save_sms_log($insert_data);
                }
            } else {
                log_message('error', 'Client data is empty or missing for Zone ID: ' . $zone_id);
            }
        }
    }

    private function send_sms_to_olt($olt_ids, $message)
    {
        foreach ($olt_ids as $olt_id) {
            $client_data = $this->employee_model->get_staff_details_by_olt_id($olt_id);

            if (!empty($client_data)) {
                $admin_data = $this->employee_model->get_staff_details_by_id(get_loggedin_user_id());

                foreach ($client_data as $client) {
                    $insert_data = [
                        'user_id' => $client['id'],
                        'sms_text' => $message,
                        'status' => 'Pending',
                        'creator_id' => get_loggedin_user_id(),
                        'creation_by' => $admin_data['name'],
                        'assign_to' => isset($client['assign_to']) ? $client['assign_to'] : null, 
                        'remarks' => 'Web',
                    ];

                    log_message('debug', 'Inserting SMS Log Data: ' . json_encode($insert_data));

                    $this->sms_model->save_sms_log($insert_data);
                }
            } else {
                log_message('error', 'Client data is empty or missing for OLT ID: ' . $olt_id);
            }
        }
    }
}
