<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Food_shop extends Admin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('shop_model');
    }

    public function index()
    {
        $this->data['managers'] = $this->food_shop_model->get_managers();
        $this->data['food_items'] = $this->food_shop_model->get_food_items();
        $this->data['title'] = 'Food Shop';
        $this->data['sub_page'] = 'shop/index';
        $this->data['main_menu'] = 'shop';
        $this->load->view('layout/index', $this->data);
    }

    public function save()
    {
        $manager_id = $this->input->post('manager_id');
        $food_items = $this->input->post('food_items');
        $quantities = $this->input->post('quantities');

        if (!empty($manager_id) && !empty($food_items)) {
            foreach ($food_items as $index => $item_id) {
                $this->food_shop_model->insert([
                    'manager_id' => $manager_id,
                    'food_item_id' => $item_id,
                    'quantity' => $quantities[$index],
                    'created_at' => date('Y-m-d H:i:s')
                ]);
            }
            set_alert('success', 'Shop items saved successfully');
        } else {
            set_alert('error', 'Something went wrong');
        }

        redirect('food_shop');
    }
}
